/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterTemplateController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.inputs.OperationInput;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ConfigurationPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.OperationGeneralPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.OperationRuntimePage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.ParameterPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.UserAttributePage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterTemplateWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterWidget;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.OperationManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class OperationEditor
extends RepositoryEditor
implements ParameterController,
ParameterTemplateController {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".editors.operation";
    private Operation operation;
    private OperationRuntimePage runtimePage;
    private ParameterPage parameterPage;
    private ConfigurationPage configPage;

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof OperationInput)) {
            throw new PartInitException("Invalid input: need OperationInput");
        }
        super.init(site, input);
        this.operation = (Operation)((OperationInput)input).getAdapter(Operation.class);
        if (this.operation == null) {
            throw new PartInitException("Could not get operation");
        }
        this.setReadOnly(((OperationInput)input).isReadOnly());
    }

    protected void addPages() {
        try {
            this.parameterPage = new ParameterPage(this, "Parameters", this, this, this.operation.getParameterChangePolicy(), null, false);
            this.runtimePage = new OperationRuntimePage(this);
            this.configPage = new ConfigurationPage(this, "Configuration", this.operation.getConfigurationDescription(), (InheritedConfiguration)this.operation.getConfiguration(), (InheritedConfiguration)this.operation.getTestConfiguration(), this.isReadOnly());
            this.addPage((IFormPage)new OperationGeneralPage(this));
            this.addPage((IFormPage)this.runtimePage);
            this.addPage((IFormPage)this.parameterPage);
            this.addPage((IFormPage)this.configPage);
            this.addPage((IFormPage)new UserAttributePage(this, (UserAttributeContainer)this.operation, this.isReadOnly()));
        }
        catch (PartInitException exp) {
            exp.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (ARMHelper.getBranch() == null) {
            return;
        }
        InheritedConfigurationDescription newConfigDescription = this.configPage.getConfigurationDescription();
        InheritedActivityConfiguration newConfig = (InheritedActivityConfiguration)this.configPage.getConfiguration();
        InheritedActivityConfiguration newTestConfig = (InheritedActivityConfiguration)this.configPage.getTestConfiguration();
        if (newConfigDescription != null) {
            this.operation.setConfigurationDescription(newConfigDescription);
        }
        if (newConfig != null) {
            this.operation.setConfiguration(newConfig);
        }
        if (newTestConfig != null) {
            this.operation.setTestConfiguration(newTestConfig);
        }
        this.startSave(monitor);
        if (this.parameterPage.isInitialized()) {
            this.operation.setParameterChangePolicy(this.parameterPage.getParameterChangePolicy());
        }
        OperationManager opMan = EditorHelper.activityRepository.getOperationManager();
        SessionToken session = Activator.getService().getSessionToken();
        opMan.storeDevelopmentOperation(session, this.operation.getStorageOperation(), ARMHelper.getBranch().longValue());
        this.endSave();
        this.configPage.setConfigurationDescription(this.operation.getConfigurationDescription());
        this.configPage.setConfiguration((InheritedConfiguration)this.operation.getConfiguration());
        this.configPage.setTestConfiguration((InheritedConfiguration)this.operation.getTestConfiguration());
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterWidget widget) {
        return ParameterChangePolicy.GENERIC;
    }

    @Override
    public InheritedCollection<String, ActivityModelParameter> getParameters(ParameterWidget widget, ActivityConstants.AccessType accessType) {
        return this.operation.getParameters(accessType);
    }

    @Override
    public void parametersChanged(InheritedCollection<String, ActivityModelParameter> parameters, ActivityConstants.AccessType accessType) {
        this.operation.setParameters(accessType, parameters);
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterTemplateWidget widget) {
        return ParameterChangePolicy.GENERIC;
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates(ParameterTemplateWidget widget) {
        return this.operation.getParameterTemplates();
    }

    @Override
    public void parameterTemplatesChanged(InheritedCollection<String, ParameterTemplate> parameters) {
        this.operation.setParameterTemplates(parameters);
    }
}

