/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class RepositoryEditor
extends FormEditor {
    protected boolean dirty = false;
    private boolean isReadOnly;
    Set<IFormPage> pages = new HashSet<IFormPage>();

    public RepositoryEditor() {
        this.setReadOnly(false);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
    }

    public int addPage(IFormPage page) throws PartInitException {
        int index = super.addPage(page);
        this.pages.add(page);
        return index;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void setName(String name) {
        this.setPartName(name);
        this.firePropertyChange(1);
    }

    public void startSave(IProgressMonitor monitor) {
        for (IFormPage page : this.pages) {
            page.doSave(monitor);
            if (!(page instanceof RepositoryPage)) continue;
            ((RepositoryPage)page).validate();
        }
    }

    public void endSave() {
        this.setDirty(false);
        ARMHelper.refreshRepositoryBrowserView();
        for (IFormPage page : this.pages) {
            if (!(page instanceof RepositoryPage)) continue;
            ((RepositoryPage)page).saveDone();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }
}

