/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.ActivityTemplateDefinitionEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.TextInheritedWidget;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ATDGeneralPage
extends RepositoryPage
implements SelectionListener {
    private ActivityTemplateDefinitionEditor editor;
    private TextInheritedWidget txtDeveloperDescription;
    private TextInheritedWidget txtLicence;
    private TextInheritedWidget txtDescription;
    private TextInheritedWidget txtStaffAssignmentRule;
    private Text txtUUID;
    private Text txtName;
    private Button btnSARDialogue;
    private boolean initialized = false;
    private StaffAssignmentRuleDialogueProvider[] sarProviders;
    private Label lblState;
    private Label lblRevision;

    public ATDGeneralPage(RepositoryEditor editor) {
        super(editor, "atd-general", "General");
        this.editor = (ActivityTemplateDefinitionEditor)editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        final Composite parent = form.getBody();
        form.setText("General");
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        Label lbl = toolkit.createLabel(parent, "UUID");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.txtUUID = toolkit.createText(parent, "");
        this.txtUUID.setEditable(false);
        TableWrapData twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.txtUUID.setLayoutData((Object)twd);
        lbl = toolkit.createLabel(parent, "Name");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.txtName = toolkit.createText(parent, "");
        twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.txtName.setLayoutData((Object)twd);
        this.txtName.setEditable(false);
        lbl = toolkit.createLabel(parent, "Revision");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.lblRevision = toolkit.createLabel(parent, "");
        twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.lblRevision.setLayoutData((Object)twd);
        lbl = toolkit.createLabel(parent, "State");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.lblState = toolkit.createLabel(parent, "");
        twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.lblState.setLayoutData((Object)twd);
        int multiStyle = 578;
        lbl = toolkit.createLabel(parent, "Description");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.txtDescription = new TextInheritedWidget(parent, multiStyle, "", Boolean.FALSE, this.editor.isReadOnly(), this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        twd.heightHint = 60;
        this.txtDescription.setLayoutData(twd);
        lbl = toolkit.createLabel(parent, "Developer Description");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.txtDeveloperDescription = new TextInheritedWidget(parent, multiStyle, "", Boolean.FALSE, this.editor.isReadOnly(), this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtDeveloperDescription.setLayoutData(twd);
        lbl = toolkit.createLabel(parent, "Licence Information");
        lbl.setLayoutData((Object)new TableWrapData(2));
        this.txtLicence = new TextInheritedWidget(parent, multiStyle, "", Boolean.FALSE, this.editor.isReadOnly(), this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtLicence.setLayoutData(twd);
        lbl = toolkit.createLabel(parent, "Staff Assignment Rule");
        twd = new TableWrapData(2);
        twd.rowspan = 2;
        lbl.setLayoutData((Object)twd);
        this.txtStaffAssignmentRule = new TextInheritedWidget(parent, multiStyle, "", Boolean.FALSE, this.editor.isReadOnly(), this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtStaffAssignmentRule.setLayoutData(twd);
        this.txtStaffAssignmentRule.addSelectionListener(this);
        this.btnSARDialogue = toolkit.createButton(parent, "Change Staff Assignment Rule", 8);
        this.sarProviders = StaffAssignmentRuleDialogueRegistry.getProviders();
        if (this.sarProviders.length == 0) {
            this.btnSARDialogue.setEnabled(false);
        }
        this.btnSARDialogue.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StaffAssignmentRuleDialogue dialogue = ATDGeneralPage.this.sarProviders[0].createDialogue(parent.getShell(), Activator.getService().getOrgModelManager());
                dialogue.open(ATDGeneralPage.this.txtStaffAssignmentRule.getValue());
                if (dialogue.wasStaffAssignmentRuleChanged()) {
                    ATDGeneralPage.this.txtStaffAssignmentRule.setValue(dialogue.getStaffAssignmentRule());
                    if (ATDGeneralPage.this.editor != null) {
                        ATDGeneralPage.this.editor.setDirty(true);
                    }
                }
            }
        });
        this.btnSARDialogue.setLayoutData((Object)new TableWrapData(256, 128));
        this.btnSARDialogue.setEnabled(!this.editor.isReadOnly());
        this.showData();
        this.initialized = true;
    }

    public void showData() {
        ActivityTemplateDefinition atd = this.editor.getATD();
        this.txtUUID.setText(atd.getID().toString());
        this.txtName.setText(atd.getName());
        this.lblRevision.setText(Long.toString(atd.getRevision()));
        this.lblState.setText(atd.getState().toString());
        this.txtDescription.setValue(atd.getDescription());
        this.txtDescription.setInherited(atd.isDescriptionInherited());
        this.txtDeveloperDescription.setValue(atd.getDeveloperDescription());
        this.txtDeveloperDescription.setInherited(atd.isDeveloperDescriptionInherited());
        this.txtLicence.setValue(atd.getLicenceInformation());
        this.txtLicence.setInherited(atd.isLicenceInformationInherited());
        this.txtStaffAssignmentRule.setValue(atd.getStaffAssignmentRule());
        this.txtStaffAssignmentRule.setInherited(atd.isStaffAssignmentRuleInherited());
        this.btnSARDialogue.setEnabled(!this.txtStaffAssignmentRule.isInherited() && this.sarProviders.length > 0);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.initialized) {
            ActivityTemplateDefinition atd = this.editor.getATD();
            if (this.txtDescription.isInherited()) {
                atd.removeOwnDescription();
            } else {
                atd.setDescription(this.txtDescription.getValue());
            }
            if (this.txtDeveloperDescription.isInherited()) {
                atd.removeOwnDeveloperDescription();
            } else {
                atd.setDeveloperDescription(this.txtDeveloperDescription.getValue());
            }
            if (this.txtLicence.isInherited()) {
                atd.removeOwnLicenceInformation();
            } else {
                atd.setLicenceInformation(this.txtLicence.getValue());
            }
            if (this.txtStaffAssignmentRule.isInherited()) {
                atd.removeOwnStaffAssignmentRule();
            } else {
                atd.setStaffAssignmentRule(this.txtStaffAssignmentRule.getValue());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.txtStaffAssignmentRule) {
            this.btnSARDialogue.setEnabled(!this.txtStaffAssignmentRule.isInherited());
        }
    }
}

