/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.ActivityTemplateDefinitionEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ExecutionControlPropertiesSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.GUISection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ImplementationSection;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ATDRuntimePage
extends RepositoryPage {
    private ActivityTemplateDefinitionEditor editor;
    private GUISection sectionGUI;
    private ExecutionControlPropertiesSection sectionECP;
    private ImplementationSection sectionImplementation;
    private boolean initialized = false;

    public ATDRuntimePage(ActivityTemplateDefinitionEditor editor) {
        super(editor, "atd-runtime", "Runtime");
        this.editor = editor;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.initialized) {
            return;
        }
        ActivityTemplateDefinition atd = this.editor.getATD();
        if (this.sectionGUI.isGUIContextIDInherited()) {
            atd.removeOwnGUIContextID();
        } else {
            atd.setGUIContextID(this.sectionGUI.getGUIContextID());
        }
        if (this.sectionGUI.isIconIDInherited()) {
            atd.removeOwnIconID();
        } else {
            atd.setIconID(this.sectionGUI.getIconID());
        }
        if (this.sectionECP.isInherited()) {
            atd.removeOwnExecutionControlProperties();
        } else {
            atd.setExecutionControlProperties(this.sectionECP.getExecutionControlProperties());
        }
        if (this.sectionImplementation.isClassInherited()) {
            atd.removeOwnImplementationClass();
        } else {
            atd.setImplementationClass(this.sectionImplementation.getImplementationClass());
        }
        if (this.sectionImplementation.isSingletonInherited()) {
            atd.removeOwnSingleton();
        } else {
            atd.setSingleton(this.sectionImplementation.isSingleton());
        }
        if (this.sectionImplementation.isViewOnlyInherited()) {
            atd.removeOwnSupportsViewOnly();
        } else {
            atd.setSupportsViewOnly(this.sectionImplementation.isViewOnly());
        }
        if (this.sectionImplementation.isTestExecutionInherited()) {
            atd.removeOwnSupportsTestExecution();
        } else {
            atd.setSupportsTestExecution(this.sectionImplementation.isTestExecution());
        }
        atd.setClassPath(this.sectionImplementation.getClassPath());
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText("Runtime");
        toolkit.decorateFormHeading(form.getForm());
        parent.setLayout((Layout)new TableWrapLayout());
        this.sectionGUI = new GUISection(parent, 64, "GUI", "Specify settings according the GUI here", "NullContext", null, this.editor, false, false, this.editor.isReadOnly(), true, true, toolkit);
        this.sectionGUI.setLayoutData(new TableWrapData(256, 16));
        this.sectionECP = new ExecutionControlPropertiesSection(parent, 64, this.editor.getATD().getExecutionControlProperties(), "Execution Control Properties", "Specify the execution control properties here", true, new Boolean(this.editor.getATD().areExecutionControlPropertiesInterited()), this.editor.isReadOnly(), toolkit, this.editor);
        this.sectionECP.setLayoutData(new TableWrapData(256, 16));
        ActivityTemplateDefinition atd = this.editor.getATD();
        List<String> inheritedClassPath = atd.getClassPath().subList(atd.getOwnClassPath().size(), atd.getClassPath().size());
        this.sectionImplementation = new ImplementationSection(parent, 64, "Implementation", "Specify settings according the implementation here", this.editor, this.editor.isReadOnly(), "", atd.getOwnClassPath(), inheritedClassPath, true, false, false, true, false, true, false, true, false, true, false, true, false, true, toolkit);
        this.sectionImplementation.setLayoutData(new TableWrapData(256, 16));
        toolkit.paintBordersFor(parent);
        this.showData();
        this.initialized = true;
    }

    public void showData() {
        ActivityTemplateDefinition atd = this.editor.getATD();
        List<String> inheritedClassPath = atd.getClassPath().subList(atd.getOwnClassPath().size(), atd.getClassPath().size());
        this.sectionGUI.setGUIContext(atd.getGUIContextID());
        this.sectionGUI.setGUIContextInherited(atd.isGUIContextIDInherited());
        this.sectionGUI.setIconID(atd.getIconID());
        this.sectionGUI.setIconInherited(atd.isIconIDInherited());
        this.sectionECP.setExecutionControlProperties(atd.getExecutionControlProperties());
        this.sectionECP.setInherited(atd.areExecutionControlPropertiesInterited());
        this.sectionImplementation.setImplementationClass(atd.getImplementationClass());
        this.sectionImplementation.setClassInherited(atd.isImplementationClassInherited());
        this.sectionImplementation.setClassPath(atd.getOwnClassPath());
        this.sectionImplementation.setInheritedClassPath(inheritedClassPath);
        this.sectionImplementation.setSingleton(atd.isSingleton());
        this.sectionImplementation.setSingletonInherited(atd.isSingletonInherited());
        this.sectionImplementation.setViewOnly(atd.supportsViewOnly());
        this.sectionImplementation.setViewOnlyInherited(atd.isSupportsViewOnlyInherited());
        this.sectionImplementation.setTestExecution(atd.supportsTestExecution());
        this.sectionImplementation.setTestExecutionInherited(atd.isSupportsTestExecutionInherited());
    }
}

