/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationDescriptionSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationDescriptionWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationSection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConfigurationPage
extends RepositoryPage
implements ConfigurationDescriptionWidget.ConfigurationDescriptionChangedListener {
    protected RepositoryEditor editor;
    protected String pageTitle;
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedConfiguration configuration;
    protected InheritedConfiguration testConfiguration;
    protected ConfigurationDescriptionSection configurationDescriptionSection;
    protected ConfigurationSection configurationSection;
    protected ConfigurationSection testConfigurationSection;
    protected boolean isReadOnly;

    public ConfigurationPage(RepositoryEditor editor, String pageTitle, InheritedConfigurationDescription configurationDescription, InheritedConfiguration configuration, InheritedConfiguration testConfiguration, boolean readOnly) {
        super(editor, pageTitle.toLowerCase(), pageTitle);
        this.editor = editor;
        this.pageTitle = pageTitle;
        this.configurationDescription = configurationDescription;
        this.configuration = configuration;
        this.testConfiguration = testConfiguration;
        this.isReadOnly = readOnly;
    }

    public InheritedConfigurationDescription getConfigurationDescription() {
        if (this.configurationDescription == null || this.configurationDescriptionSection == null) {
            return null;
        }
        return this.configurationDescriptionSection.getConfigurationDescription();
    }

    public void setConfigurationDescription(InheritedConfigurationDescription newConfigDescription) {
        this.configurationDescription = newConfigDescription;
        if (this.configurationDescriptionSection != null && this.configurationSection != null && this.testConfigurationSection != null) {
            this.configurationDescriptionSection.setConfigurationDescription(this.configurationDescription);
            this.configurationSection.setConfigurationDescription(newConfigDescription);
            this.testConfigurationSection.setConfigurationDescription(this.configurationDescription);
        }
    }

    public InheritedConfiguration getConfiguration() {
        if (this.configuration == null || this.configurationSection == null) {
            return null;
        }
        return this.configurationSection.getConfiguration();
    }

    public void setConfiguration(InheritedConfiguration newConfiguration) {
        this.configuration = newConfiguration;
        if (this.configurationSection != null) {
            this.configurationSection.setConfiguration(this.configuration);
        }
    }

    public InheritedConfiguration getTestConfiguration() {
        if (this.testConfiguration == null || this.testConfigurationSection == null) {
            return null;
        }
        return this.testConfigurationSection.getConfiguration();
    }

    public void setTestConfiguration(InheritedConfiguration newTestConfiguration) {
        this.testConfiguration = newTestConfiguration;
        if (this.testConfigurationSection != null) {
            this.testConfigurationSection.setConfiguration(this.testConfiguration);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText(this.pageTitle);
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        parent.setLayout((Layout)layout);
        this.configurationDescriptionSection = new ConfigurationDescriptionSection(parent, 64, "Configuration description", "Shows detailed information about the possible configuration values", this.configurationDescription, this.editor, this.isReadOnly, false, toolkit);
        this.configurationDescriptionSection.setLayoutData(new TableWrapData(256, 256));
        this.configurationDescriptionSection.addChangeListener(this);
        if (this.configuration != null) {
            this.configurationSection = new ConfigurationSection(parent, 64, "Configuration", "Shows detailed information about the concrete values of the configuration", this.configurationDescription, this.configuration, this.editor, this.isReadOnly, false, false, toolkit);
            this.configurationSection.setLayoutData(new TableWrapData(256, 256));
        }
        if (this.testConfiguration != null) {
            this.testConfigurationSection = new ConfigurationSection(parent, 64, "Test Configuration", "Shows detailed information about the concrete values of the configuration, that is used in test mode.", this.configurationDescription, this.testConfiguration, this.editor, this.isReadOnly, true, false, toolkit);
            this.testConfigurationSection.setLayoutData(new TableWrapData(256, 256));
        }
        toolkit.paintBordersFor(parent);
    }

    @Override
    public void configurationDescriptionChanged(ConfigurationDescriptionWidget widget) {
        if (this.configuration != null) {
            this.configurationSection.setConfigurationDescription(this.configurationDescription);
        }
        if (this.testConfiguration != null) {
            this.testConfigurationSection.setConfigurationDescription(this.configurationDescription);
        }
    }
}

