/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.ExecutableComponentDescriptionEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ECDGeneralSection;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.util.NullArgumentException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ECDGeneralPage
extends RepositoryPage {
    protected ExecutableComponentDescriptionEditor editor;
    protected String pageTitle;
    protected ExecutableComponentDescription ecd;
    protected ECDGeneralSection generalSection;
    private boolean initialized = false;

    public ECDGeneralPage(ExecutableComponentDescriptionEditor editor, String pageTitle, ExecutableComponentDescription ecd) {
        super(editor, pageTitle.toLowerCase(), pageTitle);
        if (ecd == null) {
            throw new NullArgumentException("The executable component description must no ne null.");
        }
        this.editor = editor;
        this.pageTitle = pageTitle;
        this.ecd = ecd;
        this.generalSection = null;
    }

    public ExecutableComponentDescription getExecutableComponentDescription() {
        if (this.generalSection == null) {
            return this.ecd;
        }
        this.ecd.setDeveloperDescription(this.generalSection.getDeveloperDescription());
        return this.ecd;
    }

    public void setExecutableComponentDescription(ExecutableComponentDescription ecd) {
        this.ecd = ecd;
        if (this.generalSection != null) {
            this.generalSection.setName(ecd.getName());
            this.generalSection.setDeveloperDescription(ecd.getDeveloperDescription());
            this.generalSection.setRevision(ecd.getRevision());
            this.generalSection.setState(ecd.getState());
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText(this.pageTitle);
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        parent.setLayout((Layout)layout);
        this.generalSection = new ECDGeneralSection(parent, 64, "General information", "", this.editor, this.editor.isReadOnly(), this.ecd.getName(), this.ecd.getDeveloperDescription(), this.ecd.getLicenceInformation(), this.ecd.getRevision(), this.ecd.getState(), toolkit, true);
        this.generalSection.setLayoutData(new TableWrapData(256, 256));
        toolkit.paintBordersFor(parent);
        this.initialized = true;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.initialized) {
            return;
        }
        ExecutableComponentDescription newECD = this.editor.getECD();
        newECD.setDeveloperDescription(this.generalSection.getDeveloperDescription());
        newECD.setLicenceInformation(this.generalSection.getLicenceInformation());
    }
}

