/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.ExecutableComponentDescriptionEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ExecutionControlPropertiesSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.GUISection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ImplementationSection;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ECDRuntimePage
extends RepositoryPage {
    protected RepositoryEditor editor;
    protected String pageTitle;
    protected ExecutableComponentDescription ecd;
    protected ExecutionControlPropertiesSection executionPropSection;
    protected GUISection guiSection;
    protected ImplementationSection implementationSection;
    protected boolean initialized = false;

    public ECDRuntimePage(RepositoryEditor editor, String pageTitle, ExecutableComponentDescription ecd) {
        super(editor, pageTitle.toLowerCase(), pageTitle);
        if (ecd == null) {
            throw new NullArgumentException("The executable component description must no ne null.");
        }
        this.editor = editor;
        this.pageTitle = pageTitle;
        this.ecd = ecd;
        this.executionPropSection = null;
        this.guiSection = null;
        this.implementationSection = null;
    }

    public ExecutableComponentDescription getExecutableComponentDescription() {
        if (this.executionPropSection == null || this.guiSection == null || this.implementationSection == null) {
            return this.ecd;
        }
        this.ecd.setExecutionControlProperties(this.executionPropSection.getExecutionControlProperties());
        this.ecd.setGUIContextID(this.guiSection.getGUIContextID());
        this.ecd.setIconID(this.guiSection.getIconID());
        this.ecd.setImplementationClass(this.implementationSection.getImplementationClass());
        this.ecd.setClassPath(this.implementationSection.getClassPath());
        this.ecd.setSingleton(this.implementationSection.isSingleton());
        return this.ecd;
    }

    public void setExecutableComponentDescription(ExecutableComponentDescription ecd) {
        this.ecd = ecd;
        if (this.executionPropSection != null && this.guiSection != null && this.implementationSection != null) {
            this.executionPropSection.setExecutionControlProperties(ecd.getExecutionControlProperties());
            this.guiSection.setGUIContext(ecd.getGUIContextID());
            this.guiSection.setIconID(ecd.getIconID());
            this.implementationSection.setImplementationClass(ecd.getImplementationClass());
            this.implementationSection.setClassPath(ecd.getClassPath());
            this.implementationSection.setSingleton(ecd.isSingleton());
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText(this.pageTitle);
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        parent.setLayout((Layout)layout);
        this.guiSection = new GUISection(parent, 64, "GUI information", "Shows information about GUI aspects of the activity", this.ecd.getGUIContextID(), this.ecd.getIconID(), this.editor, false, false, this.editor.isReadOnly(), false, true, toolkit);
        this.guiSection.setLayoutData(new TableWrapData(256, 256));
        this.executionPropSection = new ExecutionControlPropertiesSection(parent, 64, this.ecd.getExecutionControlProperties(), "Execution control properties", "Shows information about the execution control properties", true, null, this.editor.isReadOnly(), toolkit, this.editor);
        this.executionPropSection.setLayoutData(new TableWrapData(256, 256));
        this.implementationSection = new ImplementationSection(parent, 64, "Implementation details", "This section shows the details of the implementation of the executable component descripition", this.editor, this.editor.isReadOnly(), this.ecd.getImplementationClass(), this.ecd.getClassPath(), new ArrayList<String>(), false, false, this.ecd.isSingleton(), false, false, false, false, false, false, false, false, false, false, true, toolkit);
        this.implementationSection.setLayoutData(new TableWrapData(256, 256));
        toolkit.paintBordersFor(parent);
        this.initialized = true;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.initialized) {
            return;
        }
        ExecutableComponentDescription newECD = ((ExecutableComponentDescriptionEditor)this.editor).getECD();
        newECD.setGUIContextID(this.guiSection.getGUIContextID());
        newECD.setExecutionControlProperties(this.executionPropSection.getExecutionControlProperties());
        newECD.setImplementationClass(this.implementationSection.getImplementationClass());
        newECD.setClassPath(this.implementationSection.getClassPath());
        newECD.setSingleton(this.implementationSection.isSingleton());
    }
}

