/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.IdentifierEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class IdentifierGeneralPage
extends RepositoryPage
implements ModifyListener {
    boolean initialized = false;
    protected IdentifierEditor editor;
    private Text txtName;
    private Text txtDescription;
    private Label lblID;
    private Label lblRevision;
    private Label lblState;

    public IdentifierGeneralPage(IdentifierEditor editor) {
        super(editor, "general", "General");
        this.editor = editor;
    }

    public void modifyText(ModifyEvent e) {
        this.editor.setDirty(true);
        if (e.widget == this.txtName) {
            this.editor.setName(this.txtName.getText());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.initialized) {
            Identifier id = this.editor.getIdentifier();
            id.setName(this.txtName.getText());
            id.setDescription(this.txtDescription.getText());
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText("General");
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        int styleMulti = 578;
        TableWrapData twd = null;
        Label label = toolkit.createLabel(parent, "ID");
        label.setLayoutData((Object)new TableWrapData(2));
        this.lblID = toolkit.createLabel(parent, "");
        this.lblID.setLayoutData((Object)new TableWrapData(256, 16));
        label = toolkit.createLabel(parent, "Revision");
        label.setLayoutData((Object)new TableWrapData(2));
        this.lblRevision = toolkit.createLabel(parent, "");
        this.lblRevision.setLayoutData((Object)new TableWrapData(256, 16));
        label = toolkit.createLabel(parent, "State");
        label.setLayoutData((Object)new TableWrapData(2));
        this.lblState = toolkit.createLabel(parent, "");
        this.lblState.setLayoutData((Object)new TableWrapData(256, 16));
        label = toolkit.createLabel(parent, "Name");
        label.setLayoutData((Object)new TableWrapData(2));
        this.txtName = toolkit.createText(parent, "", 4);
        twd = new TableWrapData(256, 16);
        this.txtName.setLayoutData((Object)twd);
        label = toolkit.createLabel(parent, "Description");
        label.setLayoutData((Object)new TableWrapData(2));
        this.txtDescription = toolkit.createText(parent, "", styleMulti);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        this.txtDescription.setLayoutData((Object)twd);
        if (this.editor.isReadOnly()) {
            this.txtName.setEnabled(false);
            this.txtDescription.setEnabled(false);
        }
        this.showData();
        toolkit.paintBordersFor(parent);
        this.initialized = true;
    }

    protected void showData() {
        Identifier id = this.editor.getIdentifier();
        this.txtDescription.removeModifyListener((ModifyListener)this);
        this.txtName.removeModifyListener((ModifyListener)this);
        this.txtDescription.setText(id.getDescription());
        this.txtName.setText(id.getName());
        this.lblID.setText(id.getID().toString());
        this.lblRevision.setText(Long.toString(id.getRevision()));
        this.lblState.setText(id.getState().toString());
        this.txtDescription.addModifyListener((ModifyListener)this);
        this.txtName.addModifyListener((ModifyListener)this);
    }
}

