/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.OperationEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.TextInheritedWidget;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OperationGeneralPage
extends RepositoryPage
implements ModifyListener,
SelectionListener {
    boolean initialized = false;
    protected OperationEditor editor;
    private TextInheritedWidget txtDescription;
    private TextInheritedWidget txtStaffAssignmentRule;
    private Text txtName;
    private TextInheritedWidget txtDeveloperDescription;
    private TextInheritedWidget txtLicence;
    private Label lblState;
    private Label lblRevision;

    public OperationGeneralPage(OperationEditor editor) {
        super(editor, "general", "General");
        this.editor = editor;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.initialized) {
            Operation operation = this.editor.getOperation();
            operation.setDescription(this.txtDescription.getValue());
            operation.setStaffAssignmentRule(this.txtStaffAssignmentRule.getValue());
            if (this.txtDeveloperDescription.isInherited()) {
                operation.removeOwnDeveloperDescription();
            } else {
                operation.setDeveloperDescription(this.txtDeveloperDescription.getValue());
            }
            if (this.txtLicence.isInherited()) {
                operation.removeOwnLicenceInformation();
            } else {
                operation.setLicenceInformation(this.txtLicence.getValue());
            }
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        final Composite parent = form.getBody();
        form.setText("General");
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        int styleMulti = 578;
        Label label = toolkit.createLabel(parent, "Name");
        label.setLayoutData((Object)new TableWrapData(2));
        this.txtName = toolkit.createText(parent, "");
        TableWrapData twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.txtName.setLayoutData((Object)twd);
        this.txtName.setEditable(false);
        label = toolkit.createLabel(parent, "Revision");
        label.setLayoutData((Object)new TableWrapData(2));
        this.lblRevision = toolkit.createLabel(parent, "");
        twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.lblRevision.setLayoutData((Object)twd);
        label = toolkit.createLabel(parent, "State");
        label.setLayoutData((Object)new TableWrapData(2));
        this.lblState = toolkit.createLabel(parent, "");
        twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        this.lblState.setLayoutData((Object)twd);
        Label lblDescription = toolkit.createLabel(parent, "Description");
        lblDescription.setLayoutData((Object)new TableWrapData(2));
        this.txtDescription = new TextInheritedWidget(parent, styleMulti, "", null, false, this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtDescription.setLayoutData(twd);
        Label lblDeveloperDescription = toolkit.createLabel(parent, "Developer Description");
        lblDeveloperDescription.setLayoutData((Object)new TableWrapData(2));
        this.txtDeveloperDescription = new TextInheritedWidget(parent, styleMulti, "", Boolean.FALSE, this.editor.isReadOnly(), this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtDeveloperDescription.setLayoutData(twd);
        Label lblLicense = toolkit.createLabel(parent, "Licence Information");
        lblLicense.setLayoutData((Object)new TableWrapData(2));
        this.txtLicence = new TextInheritedWidget(parent, styleMulti, "", Boolean.FALSE, this.editor.isReadOnly(), this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtLicence.setLayoutData(twd);
        Label lblStaffAssignemtnRule = toolkit.createLabel(parent, "Staff Assignment Rule");
        twd = new TableWrapData(2);
        twd.rowspan = 2;
        lblStaffAssignemtnRule.setLayoutData((Object)twd);
        this.txtStaffAssignmentRule = new TextInheritedWidget(parent, styleMulti, "", null, false, this.editor, toolkit);
        twd = new TableWrapData(256, 16);
        twd.heightHint = 60;
        twd.colspan = 2;
        this.txtStaffAssignmentRule.setLayoutData(twd);
        Button btnSARDialogue = toolkit.createButton(parent, "Change Staff Assignment Rule", 8);
        final StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
        if (providers.length == 0) {
            btnSARDialogue.setEnabled(false);
        }
        btnSARDialogue.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(parent.getShell(), Activator.getService().getOrgModelManager());
                dialogue.open(OperationGeneralPage.this.txtStaffAssignmentRule.getValue());
                if (dialogue.wasStaffAssignmentRuleChanged()) {
                    OperationGeneralPage.this.txtStaffAssignmentRule.setValue(dialogue.getStaffAssignmentRule());
                    if (OperationGeneralPage.this.editor != null) {
                        OperationGeneralPage.this.editor.setDirty(true);
                    }
                }
            }
        });
        twd = new TableWrapData(256, 128);
        btnSARDialogue.setLayoutData((Object)twd);
        if (this.editor.isReadOnly()) {
            this.txtDescription.setEnabled(false);
            this.txtDeveloperDescription.setEnabled(false);
            this.txtStaffAssignmentRule.setEnabled(false);
            btnSARDialogue.setEnabled(false);
            this.txtLicence.setEnabled(false);
        }
        this.showOperationData();
        this.initialized = true;
    }

    protected void showOperationData() {
        Operation operation = this.editor.getOperation();
        this.txtDescription.removeModifyListener(this);
        this.txtDeveloperDescription.removeModifyListener(this);
        this.txtLicence.removeModifyListener(this);
        this.txtStaffAssignmentRule.removeModifyListener(this);
        this.txtName.setText(operation.getName());
        this.lblRevision.setText(Long.toString(operation.getRevision()));
        this.lblState.setText(operation.getState().toString());
        this.txtDescription.setValue(operation.getDescription());
        this.txtDeveloperDescription.setValue(operation.getDeveloperDescription());
        this.txtDeveloperDescription.setInherited(operation.isDeveloperDescriptionInherited());
        this.txtLicence.setValue(operation.getLicenceInformation());
        this.txtLicence.setInherited(operation.isLicenceInformationInherited());
        this.txtStaffAssignmentRule.setValue(operation.getStaffAssignmentRule());
        this.txtDescription.addModifyListener(this);
        this.txtDeveloperDescription.addModifyListener(this);
        this.txtLicence.addModifyListener(this);
        this.txtStaffAssignmentRule.addModifyListener(this);
    }

    public void modifyText(ModifyEvent e) {
        this.editor.setDirty(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.editor.setDirty(true);
    }
}

