/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.OperationEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ExecutionControlPropertiesSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.GUISection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ImplementationSection;
import de.aristaflow.adept2.model.activitymodel.Operation;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OperationRuntimePage
extends RepositoryPage {
    boolean initialized = false;
    protected OperationEditor editor;
    private GUISection sectionGUI;
    private ExecutionControlPropertiesSection sectionECP;
    private ImplementationSection sectionImplementation;

    public OperationRuntimePage(OperationEditor editor) {
        super(editor, "runtime", "Runtime");
        this.editor = editor;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.initialized) {
            Operation operation = this.editor.getOperation();
            if (this.sectionGUI.isGUIContextIDInherited()) {
                operation.removeOwnGUIContextID();
            } else {
                operation.setGUIContextID(this.sectionGUI.getGUIContextID());
            }
            if (this.sectionGUI.isIconIDInherited()) {
                operation.removeOwnIconID();
            } else {
                operation.setIconID(this.sectionGUI.getIconID());
            }
            if (this.sectionECP.isInherited()) {
                operation.removeOwnExecutionControlProperties();
            } else {
                operation.setExecutionControlProperties(this.sectionECP.getExecutionControlProperties());
            }
            if (this.sectionImplementation.isClassInherited()) {
                operation.removeOwnImplementationClass();
            } else {
                operation.setImplementationClass(this.sectionImplementation.getImplementationClass());
            }
            if (this.sectionImplementation.isSingletonInherited()) {
                operation.removeOwnSingleton();
            } else {
                operation.setSingleton(this.sectionImplementation.isSingleton());
            }
            operation.setSupportsViewOnly(this.sectionImplementation.isViewOnly());
            operation.setSupportsTestExecutionOnly(this.sectionImplementation.isTestExecution());
            operation.setClassPath(this.sectionImplementation.getClassPath());
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText("Runtime");
        toolkit.decorateFormHeading(form.getForm());
        parent.setLayout((Layout)new TableWrapLayout());
        this.sectionGUI = new GUISection(parent, 64, "GUI", "Specify settings according the GUI here", "NullContext", null, this.editor, false, false, this.editor.isReadOnly(), true, true, toolkit);
        this.sectionGUI.setLayoutData(new TableWrapData(256, 16));
        this.sectionECP = new ExecutionControlPropertiesSection(parent, 64, this.editor.getOperation().getExecutionControlProperties(), "Execution Control Properties", "Specify the execution control properties here", true, new Boolean(this.editor.getOperation().areExecutionControlPropertiesInterhited()), this.editor.isReadOnly(), toolkit, this.editor);
        this.sectionECP.setLayoutData(new TableWrapData(256, 16));
        Operation operation = this.editor.getOperation();
        ArrayList<String> inheritedClassPath = new ArrayList<String>(operation.getClassPath().subList(operation.getOwnClassPath().size(), operation.getClassPath().size()));
        this.sectionImplementation = new ImplementationSection(parent, 64, "Implementation", "Specify settings according the implementation here", this.editor, this.editor.isReadOnly(), "", operation.getOwnClassPath(), inheritedClassPath, true, false, false, true, false, true, false, false, false, true, false, false, false, true, toolkit);
        this.sectionImplementation.setLayoutData(new TableWrapData(256, 16));
        toolkit.paintBordersFor(parent);
        this.initialized = true;
        this.showData();
    }

    public void showData() {
        if (this.initialized) {
            Operation operation = this.editor.getOperation();
            ArrayList<String> inheritedClassPath = new ArrayList<String>(operation.getClassPath().subList(operation.getOwnClassPath().size(), operation.getClassPath().size()));
            this.sectionGUI.setGUIContext(operation.getGUIContextID());
            this.sectionGUI.setGUIContextInherited(operation.isGUIContextIDInherited());
            this.sectionGUI.setIconID(operation.getIconID());
            this.sectionGUI.setIconInherited(operation.isIconIDInherited());
            this.sectionECP.setExecutionControlProperties(operation.getExecutionControlProperties());
            this.sectionECP.setInherited(operation.areExecutionControlPropertiesInterhited());
            this.sectionImplementation.setImplementationClass(operation.getImplementationClass());
            this.sectionImplementation.setClassInherited(operation.isImplementationClassInherited());
            this.sectionImplementation.setClassPath(operation.getOwnClassPath());
            this.sectionImplementation.setInheritedClassPath(inheritedClassPath);
            this.sectionImplementation.setSingleton(operation.isSingleton());
            this.sectionImplementation.setSingletonInherited(operation.isSingletonInherited());
            this.sectionImplementation.setViewOnly(operation.supportsViewOnly());
            this.sectionImplementation.setTestExecution(operation.supportsTestExecution());
        }
    }
}

