/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterTemplateController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.DropDownInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterTemplateSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterTemplateWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ParameterWidget;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ParameterPage
extends RepositoryPage
implements ParameterController,
ParameterTemplateController {
    private final RepositoryEditor editor;
    private final String pageTitle;
    private final ParameterController paramController;
    private final ParameterTemplateController templateController;
    private Boolean parameterChangePolicyInherited;
    private ParameterChangePolicy parameterChangePolicy;
    private ParameterTemplateSection sectionParameterTemplates;
    private ParameterSection sectionParameter;
    private DropDownInheritedWidget pcp;
    private Map<ParameterChangePolicy, Integer> pcpIndex = new HashMap<ParameterChangePolicy, Integer>();
    private final boolean showParentPCP;
    private Label lblParentPCP;
    private boolean initialized = false;

    public ParameterPage(RepositoryEditor editor, String pageTitle, ParameterController paramController, ParameterTemplateController templateController, ParameterChangePolicy parameterChangePolicy, Boolean parameterChangePolicyInherited, boolean showParentPCP) {
        super(editor, pageTitle.toLowerCase(), pageTitle);
        this.editor = editor;
        this.pageTitle = pageTitle;
        this.paramController = paramController;
        this.templateController = templateController;
        this.parameterChangePolicy = parameterChangePolicy;
        this.parameterChangePolicyInherited = parameterChangePolicyInherited;
        this.showParentPCP = showParentPCP;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText(this.pageTitle);
        toolkit.decorateFormHeading(form.getForm());
        parent.setLayout((Layout)new GridLayout(2, false));
        if (this.parameterChangePolicy != null) {
            toolkit.createLabel(parent, "Parameter Change Policy:");
            this.pcp = new DropDownInheritedWidget(parent, 0, this.parameterChangePolicyInherited, this.editor.isReadOnly(), this.editor, toolkit);
            ParameterChangePolicy[] parameterChangePolicyArray = ParameterChangePolicy.values();
            int n = parameterChangePolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterChangePolicy value = parameterChangePolicyArray[n2];
                this.pcp.addItem(value.toString(), value);
                this.pcpIndex.put(value, this.pcp.size() - 1);
                ++n2;
            }
            this.pcp.setLayoutData(new GridData(4, 1, true, false));
            if (this.showParentPCP) {
                toolkit.createLabel(parent, "Parent Parameter Change Policy:");
                this.lblParentPCP = toolkit.createLabel(parent, "");
            }
        }
        if (this.paramController != null) {
            this.sectionParameter = new ParameterSection(parent, 64, this, this, "Parameters", "Enter data of parameters here", false, this.editor.isReadOnly(), toolkit, this.editor);
            this.sectionParameter.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        } else {
            this.sectionParameter = null;
        }
        if (this.templateController != null) {
            this.sectionParameterTemplates = new ParameterTemplateSection(parent, 64, this, "Parameter templates", "Enter data of parameter templates here", false, this.editor.isReadOnly(), toolkit, this.editor);
            this.sectionParameterTemplates.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        } else {
            this.sectionParameterTemplates = null;
        }
        if (this.editor.isReadOnly() && this.pcp != null) {
            this.pcp.setEnabled(false);
        }
        this.showData();
        this.initialized = true;
        toolkit.paintBordersFor(parent);
    }

    private void showData() {
        if (this.pcp != null) {
            this.pcp.setIndex(this.pcpIndex.get(this.parameterChangePolicy));
            if (this.showParentPCP) {
                this.lblParentPCP.setText(this.paramController.getParameterChangePolicy(null).toString());
            }
        }
        if (this.sectionParameter != null) {
            this.sectionParameter.showData();
        }
        if (this.sectionParameterTemplates != null) {
            this.sectionParameterTemplates.showData();
        }
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterWidget widget) {
        return this.paramController.getParameterChangePolicy(widget);
    }

    @Override
    public InheritedCollection<String, ActivityModelParameter> getParameters(ParameterWidget widget, ActivityConstants.AccessType accessType) {
        return this.paramController.getParameters(widget, accessType);
    }

    @Override
    public void parametersChanged(InheritedCollection<String, ActivityModelParameter> parameters, ActivityConstants.AccessType accessType) {
        this.paramController.parametersChanged(parameters, accessType);
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy(ParameterTemplateWidget widget) {
        return this.templateController.getParameterChangePolicy(widget);
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates(ParameterTemplateWidget widget) {
        return this.templateController.getParameterTemplates(widget);
    }

    @Override
    public void parameterTemplatesChanged(InheritedCollection<String, ParameterTemplate> parameters) {
        this.templateController.parameterTemplatesChanged(parameters);
    }

    public ParameterChangePolicy getParameterChangePolicy() {
        if (this.pcp != null) {
            return (ParameterChangePolicy)this.pcp.getSelectedData();
        }
        return null;
    }

    public void setParameterChangePolicy(ParameterChangePolicy value) {
        this.parameterChangePolicy = value;
        this.showData();
    }

    public boolean isParameterChangePolicyInherited() {
        return this.pcp.isInherited();
    }

    public void setParameterChangePolicyInherited(boolean value) {
        this.parameterChangePolicyInherited = value;
        this.showData();
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

