/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.pages.RepositoryPage;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.UserAttributeSection;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class UserAttributePage
extends RepositoryPage {
    protected RepositoryEditor editor;
    protected UserAttributeContainer userAttributes;
    protected UserAttributeSection attributeSection;
    protected boolean isReadonly;
    protected boolean initialized = false;

    public UserAttributePage(RepositoryEditor editor, UserAttributeContainer userAttributes, boolean isReadonly) {
        super(editor, "userattribute", "User Attributes");
        this.editor = editor;
        this.userAttributes = userAttributes;
        this.isReadonly = isReadonly;
    }

    public void setUserAttributes(UserAttributeContainer userAttributes) {
        this.userAttributes = userAttributes;
        this.attributeSection.setUserAttributes(new HashMap<String, String>(userAttributes.getUserAttributes()));
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        form.setText("User Attributes");
        toolkit.decorateFormHeading(form.getForm());
        TableWrapLayout layout = new TableWrapLayout();
        parent.setLayout((Layout)layout);
        this.attributeSection = new UserAttributeSection(parent, 64, "User defined attributes", "Shows the attributes, that were defined by the user, and allows to change them", new HashMap<String, String>(this.userAttributes.getUserAttributes()), this.editor, this.isReadonly, true, toolkit);
        this.attributeSection.setLayoutData(new TableWrapData(256, 256));
        toolkit.paintBordersFor(parent);
        this.initialized = true;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.initialized) {
            for (Map.Entry<String, String> guiEntry : this.attributeSection.getUserAttributes().entrySet()) {
                if (this.userAttributes.getUserAttributes().containsKey(guiEntry.getKey()) && ((String)this.userAttributes.getUserAttributes().get(guiEntry.getKey())).equals(guiEntry.getValue())) continue;
                this.userAttributes.setUserAttributeValue(guiEntry.getKey(), guiEntry.getValue());
            }
            HashMap tmp = new HashMap(this.userAttributes.getUserAttributes());
            for (Map.Entry paramEntry : tmp.entrySet()) {
                if (this.attributeSection.getUserAttributes().containsKey(paramEntry.getKey())) continue;
                this.userAttributes.removeUserAttributeValue((String)paramEntry.getKey());
            }
        }
    }
}

