/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AdeptValueWidget
extends Composite
implements SelectionListener,
ModifyListener {
    private FormToolkit toolkit;
    private Text stringBox;
    private Text intBox;
    private Text floatBox;
    private Text uriBox;
    private Button boolBox;
    private Text udtBox;
    private DateTime datePicker;
    private Control currentWidget;
    private ProcessConstants.AdeptDataType datatype;
    private String stringValue;
    private URI uriValue;
    private Double floatValue;
    private Long intValue;
    private Date dateValue;
    private Boolean boolValue;
    private byte[] udtValue;
    private boolean isValid;
    private List<ModifyListener> modifyListeners;
    private List<SelectionListener> selectionListeners;
    private boolean modifyEventsEnabled;
    private boolean selectionEventsEnabled;
    private Boolean inherited;
    private Button inheritedWidget;
    private final boolean isReadOnly;
    private final RepositoryEditor editor;
    private final int style;
    private String inheritedTextValue = "inherit";

    public AdeptValueWidget(Composite parent, int style, ProcessConstants.AdeptDataType datatype, Boolean inherited, boolean readOnly, RepositoryEditor editor, FormToolkit toolkit) {
        super(parent, 0);
        this.style = style;
        this.isReadOnly = readOnly;
        this.editor = editor;
        this.stringValue = "";
        this.selectionEventsEnabled = false;
        this.modifyEventsEnabled = false;
        this.modifyListeners = new ArrayList<ModifyListener>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.toolkit = toolkit != null ? toolkit : new FormToolkit(parent.getDisplay());
        this.setLayout((Layout)new GridLayout(inherited == null ? 1 : 2, false));
        this.currentWidget = null;
        this.isValid = true;
        this.inherited = inherited;
        this.toolkit.adapt((Composite)this);
        this.setDatatype(datatype);
        this.selectionEventsEnabled = true;
        this.modifyEventsEnabled = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public ProcessConstants.AdeptDataType getDatatype() {
        return this.datatype;
    }

    public void setDatatype(ProcessConstants.AdeptDataType datatype) {
        this.selectionEventsEnabled = false;
        this.modifyEventsEnabled = false;
        try {
            boolean lastInheritedState;
            this.datatype = datatype;
            if (this.currentWidget != null) {
                this.currentWidget.dispose();
                this.currentWidget = null;
            }
            boolean bl = lastInheritedState = this.inherited == null ? false : this.inherited;
            if (this.inheritedWidget != null) {
                lastInheritedState = this.inheritedWidget.getSelection();
                this.inheritedWidget.dispose();
                this.inheritedWidget = null;
            }
            this.layout(true);
            switch (datatype) {
                case BOOLEAN: {
                    this.boolBox = this.toolkit.createButton((Composite)this, "", 0x20 | this.style | 0x800);
                    this.boolBox.addSelectionListener((SelectionListener)this);
                    if (this.boolValue == null) {
                        this.boolValue = Boolean.FALSE;
                    }
                    this.boolBox.setSelection(this.boolValue.booleanValue());
                    this.currentWidget = this.boolBox;
                    break;
                }
                case FLOAT: {
                    this.floatBox = this.toolkit.createText((Composite)this, this.floatValue == null ? "" : Double.toString(this.floatValue.floatValue()), this.style | 0x800);
                    this.floatBox.addModifyListener((ModifyListener)this);
                    this.currentWidget = this.floatBox;
                    break;
                }
                case INTEGER: {
                    this.intBox = this.toolkit.createText((Composite)this, this.intValue == null ? "" : Long.toString(this.intValue), this.style | 0x800);
                    this.intBox.addModifyListener((ModifyListener)this);
                    this.currentWidget = this.intBox;
                    break;
                }
                case STRING: {
                    this.stringBox = this.toolkit.createText((Composite)this, this.stringValue == null ? "" : this.stringValue, this.style | 0x800);
                    this.stringBox.addModifyListener((ModifyListener)this);
                    this.currentWidget = this.stringBox;
                    break;
                }
                case DATE: {
                    this.datePicker = new DateTime((Composite)this, this.style);
                    this.datePicker.setLayoutData((Object)new GridData(1, 1, false, false));
                    if (this.dateValue == null) {
                        this.dateValue = new Date();
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.dateValue);
                    this.datePicker.setYear(cal.get(1));
                    this.datePicker.setMonth(cal.get(2));
                    this.datePicker.setDay(cal.get(5));
                    this.datePicker.setHours(cal.get(11));
                    this.datePicker.setMinutes(cal.get(12));
                    this.datePicker.setSeconds(cal.get(13));
                    this.datePicker.addSelectionListener((SelectionListener)this);
                    this.currentWidget = this.datePicker;
                    break;
                }
                case URI: {
                    this.uriBox = this.toolkit.createText((Composite)this, this.uriValue == null ? "" : this.uriValue.toASCIIString(), this.style | 0x800);
                    this.uriBox.addModifyListener((ModifyListener)this);
                    this.currentWidget = this.uriBox;
                    break;
                }
                case USERDEFINED: {
                    this.udtBox = this.toolkit.createText((Composite)this, this.udtValue == null ? "" : new String(this.udtValue), this.style | 0x800);
                    this.udtBox.addModifyListener((ModifyListener)this);
                    this.currentWidget = this.udtBox;
                }
            }
            boolean cfr_ignored_0 = this.currentWidget instanceof Text;
            this.modifyValue((Widget)this.currentWidget);
            if (this.currentWidget != null) {
                this.currentWidget.setLayoutData((Object)new GridData(4, 1, true, false));
                this.currentWidget.setEnabled(!this.isReadOnly);
            }
            if (this.inherited != null) {
                this.inheritedWidget = this.toolkit.createButton((Composite)this, this.inheritedTextValue, 32);
                this.inheritedWidget.setSelection(lastInheritedState);
                if (!this.isReadOnly) {
                    this.currentWidget.setEnabled(!lastInheritedState);
                    this.inheritedWidget.addSelectionListener((SelectionListener)this);
                } else {
                    this.inheritedWidget.setEnabled(false);
                }
            }
            this.layout(true);
            this.redraw();
            this.update();
        }
        finally {
            this.selectionEventsEnabled = true;
            this.modifyEventsEnabled = true;
        }
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
        this.setDatatype(this.datatype);
    }

    public Double getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(Double value) {
        this.floatValue = value;
        this.setDatatype(this.datatype);
    }

    public Long getIntValue() {
        return this.intValue;
    }

    public void setIntValue(Long value) {
        this.intValue = value;
        this.setDatatype(this.datatype);
    }

    public Boolean getBoolVaue() {
        return this.boolValue;
    }

    public void setBoolValue(Boolean value) {
        this.boolValue = value;
        this.setDatatype(this.datatype);
    }

    public URI getURIValue() {
        return this.uriValue;
    }

    public void setURIValue(URI value) {
        this.uriValue = value;
        this.setDatatype(this.datatype);
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date value) {
        this.dateValue = value;
        this.setDatatype(this.datatype);
    }

    public byte[] getUDTValue() {
        return this.udtValue;
    }

    public void setUDTValue(byte[] value) {
        this.udtValue = value;
        this.setDatatype(this.datatype);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.datePicker) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.datePicker.getYear());
            cal.set(2, this.datePicker.getMonth());
            cal.set(5, this.datePicker.getDay());
            cal.set(11, this.datePicker.getHours());
            cal.set(12, this.datePicker.getMinutes());
            cal.set(13, this.datePicker.getSeconds());
            this.dateValue.setTime(cal.getTimeInMillis());
            this.informModifyListener();
        } else if (e.widget == this.inheritedWidget) {
            this.currentWidget.setEnabled(!this.inheritedWidget.getSelection());
            this.informSelectionListeners();
        } else if (e.widget == this.boolBox) {
            this.modifyValue((Widget)this.boolBox);
        }
        if (this.editor != null && this.selectionEventsEnabled) {
            this.editor.setDirty(true);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.modifyValue(e.widget);
        if (this.editor != null && this.modifyEventsEnabled) {
            this.editor.setDirty(true);
        }
    }

    protected void modifyValue(Widget widget) {
        if (widget == this.stringBox) {
            this.stringValue = this.stringBox.getText();
            this.isValid = true;
        } else if (widget == this.intBox) {
            try {
                this.intValue = new Long(this.intBox.getText());
                this.isValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.isValid = false;
                this.intValue = null;
            }
        } else if (widget == this.floatBox) {
            try {
                this.floatValue = new Double(this.floatBox.getText());
                this.isValid = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.floatValue = null;
                this.isValid = false;
            }
        } else if (widget == this.boolBox) {
            this.boolValue = this.boolBox.getSelection();
            this.isValid = true;
        } else if (widget == this.uriBox) {
            try {
                this.uriValue = new URI(this.uriBox.getText());
                this.isValid = true;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.isValid = false;
                this.uriValue = null;
            }
        } else if (widget == this.udtBox) {
            this.udtValue = this.udtBox.getText().getBytes();
            this.isValid = true;
        }
        this.informModifyListener();
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListner(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    protected void informModifyListener() {
        if (!this.modifyEventsEnabled) {
            return;
        }
        for (ModifyListener listener : this.modifyListeners) {
            Event e = new Event();
            e.widget = this;
            listener.modifyText(new ModifyEvent(e));
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void informSelectionListeners() {
        if (!this.selectionEventsEnabled) {
            return;
        }
        for (SelectionListener listener : this.selectionListeners) {
            Event e = new Event();
            e.widget = this;
            listener.widgetSelected(new SelectionEvent(e));
        }
    }

    public void setValue(String value) throws IllegalArgumentException {
        switch (this.datatype) {
            case BOOLEAN: {
                boolean newValue = Boolean.parseBoolean(value);
                this.setBoolValue(newValue);
                break;
            }
            case FLOAT: {
                try {
                    double newValue = value.length() > 0 ? Double.parseDouble(value) : 0.0;
                    this.setFloatValue(newValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Float value cannot be parsed", e);
                }
            }
            case INTEGER: {
                try {
                    long newValue = value.length() > 0 ? Long.parseLong(value) : 0L;
                    this.setIntValue(newValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Integer value cannot be parsed", e);
                }
            }
            case STRING: {
                this.setStringValue(value);
                break;
            }
            case DATE: {
                Date newValue;
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 3, Activator.getService().getActiveAgent().getLocale());
                if (value.length() > 0) {
                    try {
                        newValue = formatter.parse(value);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Date value cannot be parsed", e);
                    }
                } else {
                    newValue = new Date(System.currentTimeMillis());
                }
                this.setDateValue(newValue);
                break;
            }
            case URI: {
                try {
                    URI newValue = new URI(value);
                    this.setURIValue(newValue);
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("URI cannot be parsed", e);
                }
            }
            case USERDEFINED: {
                this.setUDTValue(value.getBytes());
            }
        }
    }

    public String getValue() {
        switch (this.datatype) {
            case BOOLEAN: {
                return this.getBoolVaue().toString();
            }
            case FLOAT: {
                return this.getFloatValue().toString();
            }
            case INTEGER: {
                return this.getIntValue().toString();
            }
            case STRING: {
                return this.getStringValue();
            }
            case DATE: {
                DateFormat formatter = DateFormat.getDateTimeInstance(2, 3, Activator.getService().getActiveAgent().getLocale());
                return formatter.format(this.getDateValue());
            }
            case URI: {
                return this.getURIValue().toString();
            }
            case USERDEFINED: {
                return new String(this.getUDTValue());
            }
        }
        return null;
    }

    public void setInherited(boolean inherited) {
        if (this.inherited != null) {
            this.inherited = inherited;
            if (this.inheritedWidget != null) {
                this.inheritedWidget.setSelection(inherited);
                this.currentWidget.setEnabled(!inherited);
            }
        }
    }

    public boolean isInherited() {
        if (this.inheritedWidget != null) {
            return this.inheritedWidget.getSelection();
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        if (this.inheritedWidget != null) {
            this.inheritedWidget.setEnabled(enabled);
        }
        this.currentWidget.setEnabled(enabled && (this.inheritedWidget == null || !this.inheritedWidget.getSelection()));
        super.setEnabled(enabled);
    }

    public void setInheritedTextValue(String value) {
        if (this.inheritedWidget != null) {
            this.inheritedTextValue = value;
            this.inheritedWidget.setText(value);
        }
    }
}

