/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BooleanInheritedWidget
extends Composite
implements SelectionListener {
    private Button valueButton;
    private Button inheritedButton;
    private RepositoryEditor editor;
    private List<SelectionListener> selectionListeners;
    private boolean selectionEventsEnabled;
    private final boolean isReadOnly;

    public BooleanInheritedWidget(Composite parent, int style, boolean defaultValue, Boolean inherited, boolean readOnly, RepositoryEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.isReadOnly = readOnly;
        this.editor = parentEditor;
        this.selectionEventsEnabled = false;
        this.setLayout((Layout)new GridLayout(3, false));
        this.selectionListeners = new ArrayList<SelectionListener>();
        toolkit.adapt((Composite)this);
        this.valueButton = toolkit.createButton((Composite)this, "", style | 0x20);
        this.valueButton.setLayoutData((Object)new GridData());
        this.valueButton.addSelectionListener((SelectionListener)this);
        if (inherited != null) {
            toolkit.createLabel((Composite)this, " | ");
            this.inheritedButton = toolkit.createButton((Composite)this, "inherit", 32);
            this.inheritedButton.setLayoutData((Object)new GridData());
            this.inheritedButton.addSelectionListener((SelectionListener)this);
            this.inheritedButton.setSelection(inherited.booleanValue());
        } else {
            this.inheritedButton = null;
        }
        this.valueButton.setSelection(defaultValue);
        if (this.isReadOnly) {
            this.valueButton.setEnabled(false);
            if (this.inheritedButton != null) {
                this.inheritedButton.setEnabled(false);
            }
        }
        this.selectionEventsEnabled = true;
    }

    public void setInherited(boolean inherited) {
        if (this.inheritedButton == null) {
            return;
        }
        this.selectionEventsEnabled = false;
        this.inheritedButton.setSelection(inherited);
        this.valueButton.setEnabled(!inherited && !this.isReadOnly);
        this.selectionEventsEnabled = true;
    }

    public boolean isInherited() {
        if (this.inheritedButton == null) {
            return false;
        }
        return this.inheritedButton.getSelection();
    }

    public void setValue(boolean value) {
        this.selectionEventsEnabled = false;
        this.valueButton.setSelection(value);
        this.selectionEventsEnabled = true;
    }

    public boolean getValue() {
        return this.valueButton.getSelection();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void selectionEvent() {
        if (!this.selectionEventsEnabled) {
            return;
        }
        for (SelectionListener listener : this.selectionListeners) {
            Event e = new Event();
            e.widget = this;
            listener.widgetSelected(new SelectionEvent(e));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.inheritedButton != null) {
            this.valueButton.setEnabled(!this.inheritedButton.getSelection());
        }
        if (this.editor != null && this.selectionEventsEnabled) {
            this.editor.setDirty(true);
        }
        this.selectionEvent();
    }

    public void setEnabled(boolean enabled) {
        if (this.inheritedButton != null) {
            this.inheritedButton.setEnabled(enabled);
        }
        this.valueButton.setEnabled(enabled && (this.inheritedButton == null || !this.inheritedButton.getSelection()));
        super.setEnabled(enabled);
    }

    public void setInheritedTextValue(String value) {
        if (this.inheritedButton != null) {
            this.inheritedButton.setText(value);
        }
    }
}

