/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ClassPathWidget
extends Composite
implements SelectionListener {
    protected Table tblClassPaths;
    protected Button btnAddClassPath;
    protected Button btnDeleteClassPath;
    protected Button btnEditClassPath;
    protected Button btnMoveTop;
    protected Button btnMoveUp;
    protected Button btnMoveDown;
    protected Button btnMoveBottom;
    protected List<String> classPathList;
    protected List<String> inheritedClassPathList;
    protected RepositoryEditor editor;
    protected boolean readonly;
    private List<ModifyListener> modifyListeners;
    private boolean modifyEventsEnabled;

    public ClassPathWidget(Composite parent, int style, RepositoryEditor editor, List<String> classPathList, List<String> inheritedClassPath, boolean readonly, FormToolkit toolkit) {
        super(parent, 0);
        this.classPathList = new ArrayList<String>(classPathList);
        this.inheritedClassPathList = new ArrayList<String>(inheritedClassPath);
        this.editor = editor;
        this.readonly = readonly;
        this.modifyListeners = new ArrayList<ModifyListener>();
        this.modifyEventsEnabled = false;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.tblClassPaths = toolkit.createTable((Composite)this, style | 4 | 0x800 | 0x10000);
        this.tblClassPaths.setHeaderVisible(false);
        this.tblClassPaths.setLinesVisible(false);
        TableColumnLayout columnlayout = new TableColumnLayout();
        this.tblClassPaths.setLayout((Layout)columnlayout);
        String[] titles = new String[]{"Classpath"};
        TableColumn column = new TableColumn(this.tblClassPaths, 0);
        columnlayout.setColumnData((Item)column, new ColumnData(1.0f));
        column.setText(titles[0]);
        GridData gd = new GridData(4, 1, true, false, 1, 7);
        gd.heightHint = 212;
        this.tblClassPaths.setLayoutData((Object)gd);
        this.tblClassPaths.addSelectionListener((SelectionListener)this);
        this.btnAddClassPath = toolkit.createButton((Composite)this, "Add", 8);
        this.btnAddClassPath.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnAddClassPath.addSelectionListener((SelectionListener)this);
        this.btnDeleteClassPath = toolkit.createButton((Composite)this, "Delete", 8);
        this.btnDeleteClassPath.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnDeleteClassPath.addSelectionListener((SelectionListener)this);
        this.btnEditClassPath = toolkit.createButton((Composite)this, "Edit", 8);
        this.btnEditClassPath.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnEditClassPath.addSelectionListener((SelectionListener)this);
        this.btnMoveTop = toolkit.createButton((Composite)this, "Top", 8);
        this.btnMoveTop.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnMoveTop.addSelectionListener((SelectionListener)this);
        this.btnMoveUp = toolkit.createButton((Composite)this, "Up", 8);
        this.btnMoveUp.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnMoveUp.addSelectionListener((SelectionListener)this);
        this.btnMoveDown = toolkit.createButton((Composite)this, "Down", 8);
        this.btnMoveDown.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnMoveDown.addSelectionListener((SelectionListener)this);
        this.btnMoveBottom = toolkit.createButton((Composite)this, "Bottom", 8);
        this.btnMoveBottom.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnMoveBottom.addSelectionListener((SelectionListener)this);
        if (readonly) {
            this.btnAddClassPath.setVisible(false);
            this.btnDeleteClassPath.setVisible(false);
            this.btnEditClassPath.setVisible(false);
            this.btnMoveTop.setVisible(false);
            this.btnMoveUp.setVisible(false);
            this.btnMoveDown.setVisible(false);
            this.btnMoveBottom.setVisible(false);
        }
        this.showData();
        this.modifyEventsEnabled = true;
    }

    public List<String> getClassPathList() {
        return this.classPathList;
    }

    public void setClassPathList(List<String> classPathList) {
        this.classPathList = new ArrayList<String>(classPathList);
        this.showData();
    }

    public void setInheritedClassPath(List<String> classPathList) {
        this.inheritedClassPathList = new ArrayList<String>(classPathList);
        this.showData();
    }

    public void showData() {
        this.showData(0);
    }

    public void showData(int selectionIndex) {
        TableItem item;
        this.tblClassPaths.removeAll();
        for (String classPath : this.classPathList) {
            item = new TableItem(this.tblClassPaths, 0);
            item.setText(0, classPath);
        }
        for (String inheritedClassPath : this.inheritedClassPathList) {
            item = new TableItem(this.tblClassPaths, 0);
            item.setText(0, inheritedClassPath);
            FontData oldFontData = item.getFont().getFontData()[0];
            FontData newFontData = new FontData(oldFontData.getName(), oldFontData.getHeight(), oldFontData.getStyle() | 2);
            item.setFont(new Font(item.getFont().getDevice(), newFontData));
        }
        if (selectionIndex >= this.classPathList.size()) {
            if (!this.classPathList.isEmpty()) {
                this.tblClassPaths.setSelection(this.classPathList.size() - 1);
            }
        } else {
            this.tblClassPaths.setSelection(selectionIndex);
        }
        this.updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (!this.readonly) {
            this.editClassPathItem();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.tblClassPaths) {
            this.updateButtons();
        } else if (e.widget == this.btnAddClassPath) {
            this.addClassPath();
        } else if (e.widget == this.btnDeleteClassPath) {
            this.deleteClassPath();
        } else if (e.widget == this.btnEditClassPath) {
            this.editClassPathItem();
        } else if (e.widget == this.btnMoveTop) {
            this.moveSelectedEntryToTop();
        } else if (e.widget == this.btnMoveUp) {
            this.moveSelectedEntryUp();
        } else if (e.widget == this.btnMoveDown) {
            this.moveSelectedEntryDown();
        } else if (e.widget == this.btnMoveBottom) {
            this.moveSelectedEntryToBottom();
        }
    }

    protected void addClassPath() {
        ClassPathDialog dialog = new ClassPathDialog("");
        if (dialog.openDialog(this.getShell())) {
            int index = this.tblClassPaths.getSelectionIndex();
            int showIndex = 0;
            if (index >= 0 && index < this.classPathList.size()) {
                this.classPathList.add(index + 1, dialog.getClassPath());
                showIndex = index + 1;
            } else {
                this.classPathList.add(dialog.getClassPath());
                showIndex = this.classPathList.size() - 1;
            }
            if (this.editor != null) {
                this.editor.setDirty(true);
            }
            this.showData(showIndex);
            this.modifyEvent();
        }
    }

    protected void deleteClassPath() {
        if (this.tblClassPaths.getSelectionIndex() >= this.classPathList.size()) {
            return;
        }
        int index = this.tblClassPaths.getSelectionIndex();
        this.classPathList.remove(index);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
        this.modifyEvent();
        this.showData(index);
    }

    protected void editClassPathItem() {
        if (this.tblClassPaths.getSelectionIndex() >= this.classPathList.size()) {
            return;
        }
        int index = this.tblClassPaths.getSelectionIndex();
        ClassPathDialog dialog = new ClassPathDialog(this.classPathList.get(index));
        if (dialog.openDialog(this.getShell())) {
            this.classPathList.set(index, dialog.getClassPath());
            this.showData(index);
            if (this.editor != null) {
                this.editor.setDirty(true);
            }
            this.modifyEvent();
        }
    }

    protected void moveSelectedEntryToTop() {
        if (this.tblClassPaths.getSelectionIndex() >= this.classPathList.size()) {
            return;
        }
        int index = this.tblClassPaths.getSelectionIndex();
        String entry = this.classPathList.get(index);
        if (index < 1 || index >= this.classPathList.size()) {
            return;
        }
        this.classPathList.remove(index);
        this.classPathList.add(0, entry);
        this.showData(0);
    }

    protected void moveSelectedEntryUp() {
        if (this.tblClassPaths.getSelectionIndex() >= this.classPathList.size()) {
            return;
        }
        int index = this.tblClassPaths.getSelectionIndex();
        String entry = this.classPathList.get(index);
        if (index < 1 || index >= this.classPathList.size()) {
            return;
        }
        this.classPathList.remove(index);
        this.classPathList.add(index - 1, entry);
        this.showData(index - 1);
    }

    protected void moveSelectedEntryDown() {
        if (this.tblClassPaths.getSelectionIndex() >= this.classPathList.size()) {
            return;
        }
        int index = this.tblClassPaths.getSelectionIndex();
        String entry = this.classPathList.get(index);
        if (index < 0 || index >= this.classPathList.size() - 1) {
            return;
        }
        this.classPathList.remove(index);
        this.classPathList.add(index + 1, entry);
        this.showData(index + 1);
    }

    protected void moveSelectedEntryToBottom() {
        if (this.tblClassPaths.getSelectionIndex() >= this.classPathList.size()) {
            return;
        }
        int index = this.tblClassPaths.getSelectionIndex();
        String entry = this.classPathList.get(index);
        if (index < 0 || index >= this.classPathList.size() - 1) {
            return;
        }
        this.classPathList.remove(index);
        this.classPathList.add(entry);
        this.showData(this.classPathList.size() - 1);
    }

    protected void updateButtons() {
        if (this.tblClassPaths.getSelectionCount() > 0) {
            boolean isInherited = !this.isSelectionInherited();
            int index = this.tblClassPaths.getSelectionIndex();
            this.btnDeleteClassPath.setEnabled(isInherited);
            this.btnEditClassPath.setEnabled(isInherited);
            this.btnMoveTop.setEnabled(isInherited && index > 0 && index <= this.classPathList.size() - 1);
            this.btnMoveUp.setEnabled(isInherited && index > 0 && index <= this.classPathList.size() - 1);
            this.btnMoveDown.setEnabled(isInherited && index >= 0 && index < this.classPathList.size() - 1);
            this.btnMoveBottom.setEnabled(isInherited && index >= 0 && index < this.classPathList.size() - 1);
        } else {
            this.btnEditClassPath.setEnabled(false);
            this.btnDeleteClassPath.setEnabled(false);
            this.btnMoveTop.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            this.btnMoveBottom.setEnabled(false);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    private void modifyEvent() {
        if (!this.modifyEventsEnabled) {
            return;
        }
        for (ModifyListener listener : this.modifyListeners) {
            Event e = new Event();
            e.widget = this;
            listener.modifyText(new ModifyEvent(e));
        }
    }

    public void setEnabled(boolean enabled) {
        this.btnAddClassPath.setEnabled(enabled);
        this.btnDeleteClassPath.setEnabled(enabled && this.tblClassPaths.getSelectionCount() > 0);
        this.btnEditClassPath.setEnabled(enabled && this.tblClassPaths.getSelectionCount() > 0);
        super.setEnabled(enabled);
    }

    protected boolean isSelectionInherited() {
        if (this.tblClassPaths.getSelectionCount() > 0) {
            return this.tblClassPaths.getSelectionIndex() >= this.classPathList.size();
        }
        return false;
    }

    public class ClassPathDialog {
        protected String path;
        protected boolean aborted;

        public ClassPathDialog(String classPath) {
            this.path = classPath != null ? classPath : new String();
            this.aborted = true;
        }

        public String getClassPath() {
            return this.path;
        }

        public boolean openDialog(Shell shell) {
            final Shell dialog = new Shell(shell, 16844896);
            dialog.setText("Class path dialog");
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 10;
            formLayout.marginHeight = 10;
            formLayout.spacing = 10;
            dialog.setLayout((Layout)formLayout);
            Label label = new Label((Composite)dialog, 0);
            label.setText("Class path");
            FormData data = new FormData();
            label.setLayoutData((Object)data);
            Button cancel = new Button((Composite)dialog, 8);
            cancel.setText("Cancel");
            data = new FormData();
            data.width = 60;
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            cancel.setLayoutData((Object)data);
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClassPathDialog.this.aborted = true;
                    dialog.close();
                }
            });
            final Text text = new Text((Composite)dialog, 2048);
            data = new FormData();
            data.width = 470;
            data.left = new FormAttachment((Control)label, 0, -1);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)label, 0, 0x1000000);
            data.bottom = new FormAttachment((Control)cancel, 0, -1);
            text.setLayoutData((Object)data);
            text.setText(this.path);
            text.setFocus();
            Button ok = new Button((Composite)dialog, 8);
            ok.setText("OK");
            data = new FormData();
            data.width = 60;
            data.right = new FormAttachment((Control)cancel, 0, -1);
            data.bottom = new FormAttachment(100, 0);
            ok.setLayoutData((Object)data);
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClassPathDialog.this.path = text.getText();
                    ClassPathDialog.this.aborted = false;
                    dialog.close();
                }
            });
            dialog.setDefaultButton(ok);
            dialog.pack();
            dialog.open();
            while (!dialog.isDisposed()) {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
            return !this.aborted;
        }
    }
}

