/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.ConfigurationEntryWizard;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationDescriptionWidget
extends Composite
implements SelectionListener {
    protected Table tblConfigFields;
    protected Button btnAddConfig;
    protected Button btnDeleteConfig;
    protected Button btnEditConfig;
    protected Button btnRestoreConfig;
    protected RepositoryEditor editor;
    protected InheritedConfigurationDescription configDescription;
    protected boolean isReadOnly;
    private List<ConfigurationDescriptionChangedListener> changedListeners;

    public ConfigurationDescriptionWidget(Composite parent, int style, RepositoryEditor editor, InheritedConfigurationDescription configDescription, boolean readOnly, FormToolkit toolkit) {
        super(parent, 0);
        this.editor = editor;
        this.configDescription = configDescription;
        this.isReadOnly = readOnly;
        this.btnAddConfig = null;
        this.btnDeleteConfig = null;
        this.btnEditConfig = null;
        this.btnRestoreConfig = null;
        this.tblConfigFields = null;
        this.changedListeners = new ArrayList<ConfigurationDescriptionChangedListener>();
        this.setLayout((Layout)new GridLayout(2, false));
        this.tblConfigFields = toolkit.createTable((Composite)this, style | 4 | 0x10000 | 0x800);
        this.tblConfigFields.setHeaderVisible(true);
        this.tblConfigFields.setLinesVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.tblConfigFields.setLayout((Layout)columnLayout);
        String[] titles = new String[]{"Name", "Description", "Datatype", "Inheritance", "Optional"};
        int[] prefWidths = new int[]{-1, 50, -1, -1, -1};
        float[] weights = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.tblConfigFields, 0);
            column.setText(titles[i]);
            columnLayout.setColumnData((Item)column, new ColumnData(prefWidths[i], weights[i]));
            ++i;
        }
        GridData gd = new GridData(4, 1, true, false, 1, 4);
        gd.heightHint = 200;
        this.tblConfigFields.setLayoutData((Object)gd);
        this.tblConfigFields.addSelectionListener((SelectionListener)this);
        this.btnAddConfig = toolkit.createButton((Composite)this, "Add", 8);
        this.btnAddConfig.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnAddConfig.setToolTipText("Adds a new own entry");
        this.btnAddConfig.addSelectionListener((SelectionListener)this);
        this.btnDeleteConfig = toolkit.createButton((Composite)this, "Delete", 8);
        this.btnDeleteConfig.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnDeleteConfig.setToolTipText("Deletes an own entry");
        this.btnDeleteConfig.addSelectionListener((SelectionListener)this);
        this.btnDeleteConfig.setEnabled(false);
        this.btnEditConfig = toolkit.createButton((Composite)this, "Edit", 8);
        this.btnEditConfig.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnEditConfig.setToolTipText("Overwrites an inherited entry or changes an own entry");
        this.btnEditConfig.addSelectionListener((SelectionListener)this);
        this.btnEditConfig.setEnabled(false);
        this.btnRestoreConfig = toolkit.createButton((Composite)this, "Inherit", 8);
        this.btnRestoreConfig.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnRestoreConfig.setToolTipText("Restores an inherited entry");
        this.btnRestoreConfig.addSelectionListener((SelectionListener)this);
        this.btnRestoreConfig.setEnabled(false);
        this.showData(0);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String editString = ConfigurationDescriptionWidget.this.btnEditConfig.getText();
                ConfigurationDescriptionWidget.this.btnEditConfig.setText("Overwrite_");
                ConfigurationDescriptionWidget.this.layout();
                ConfigurationDescriptionWidget.this.btnEditConfig.setText(editString);
            }
        });
    }

    public void addChangeListener(ConfigurationDescriptionChangedListener listener) {
        this.changedListeners.add(listener);
    }

    public void removeChangeListener(ConfigurationDescriptionChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    protected void informChangeListeners() {
        for (ConfigurationDescriptionChangedListener listener : this.changedListeners) {
            listener.configurationDescriptionChanged(this);
        }
    }

    public void setConfigurationDescription(InheritedConfigurationDescription description) {
        this.configDescription = description;
        this.showData(0);
    }

    public InheritedConfigurationDescription getConfigurationDescription() {
        return this.configDescription;
    }

    protected void showData(int selectionIndex) {
        this.tblConfigFields.removeAll();
        for (String entryName : this.configDescription.getEntries().keySet()) {
            this.addConfigTableItem(entryName);
        }
        if (this.tblConfigFields.getItemCount() > selectionIndex) {
            this.tblConfigFields.setSelection(selectionIndex);
        } else if (this.tblConfigFields.getItemCount() > 0) {
            this.tblConfigFields.setSelection(0);
        }
        this.updateButtons();
    }

    private void addConfigTableItem(String entryName) {
        TableItem item = new TableItem(this.tblConfigFields, 0);
        ConfigurationDescription.ConfigurationEntry entry = this.configDescription.getEntry(entryName);
        boolean isEntryInherited = this.configDescription.isEntryInherited(entryName);
        boolean isEntryRemoved = this.configDescription.getEntry(entryName) == null;
        boolean isEntryOverwritten = this.configDescription.isOverridingEntry(entryName);
        String description = "";
        String datatypeName = "";
        String strIsOptional = "";
        String inheritedString = "false";
        if (isEntryInherited) {
            inheritedString = "inherited";
        } else if (isEntryRemoved) {
            inheritedString = "deleted";
        } else if (isEntryOverwritten) {
            inheritedString = "overwritten";
        }
        if (entry != null) {
            description = entry.getDescription();
            datatypeName = entry.getDataType().name();
            strIsOptional = entry.isOptional() ? "true" : "false";
        } else {
            item.setForeground(this.getDisplay().getSystemColor(15));
        }
        item.setText(0, entryName);
        item.setText(1, description);
        item.setText(2, datatypeName);
        item.setText(3, inheritedString);
        item.setText(4, strIsOptional);
        item.setData("entryName", (Object)entryName);
        if (this.configDescription.isEntryInherited(entryName)) {
            FontData oldFontData = item.getFont().getFontData()[0];
            FontData newFontData = new FontData(oldFontData.getName(), oldFontData.getHeight(), oldFontData.getStyle() | 2);
            item.setFont(new Font(item.getFont().getDevice(), newFontData));
        }
    }

    private void updateButtons() {
        if (!this.isEnabled()) {
            this.btnAddConfig.setEnabled(false);
            this.btnDeleteConfig.setEnabled(false);
            this.btnEditConfig.setEnabled(false);
            this.btnRestoreConfig.setEnabled(false);
            return;
        }
        this.btnAddConfig.setEnabled(true);
        if (this.tblConfigFields.getSelectionCount() > 0) {
            int index = this.tblConfigFields.getSelectionIndex();
            String entryName = (String)this.tblConfigFields.getItem(index).getData("entryName");
            ConfigurationDescription.ConfigurationEntry entry = this.configDescription.getEntry(entryName);
            boolean isEntryInherited = this.configDescription.isEntryInherited(entryName);
            boolean isEntryRemoved = this.configDescription.getEntry(entryName) == null;
            boolean isEntryOverwritten = this.configDescription.isOverridingEntry(entryName);
            if (index < 0) {
                this.btnDeleteConfig.setEnabled(false);
                this.btnEditConfig.setEnabled(false);
                this.btnEditConfig.setText("Edit");
                this.btnRestoreConfig.setEnabled(false);
            } else {
                this.btnDeleteConfig.setEnabled(!isEntryRemoved && (entry.isOptional() || !isEntryInherited && !isEntryOverwritten));
                this.btnEditConfig.setEnabled(!isEntryRemoved);
                this.btnEditConfig.setText(isEntryInherited ? "Overwrite" : "Edit");
                this.btnRestoreConfig.setEnabled(isEntryRemoved || isEntryOverwritten);
            }
        } else {
            this.btnDeleteConfig.setEnabled(false);
            this.btnEditConfig.setEnabled(false);
            this.btnEditConfig.setText("Edit");
            this.btnRestoreConfig.setEnabled(false);
        }
        this.btnAddConfig.setVisible(!this.isReadOnly);
        this.btnEditConfig.setVisible(!this.isReadOnly);
        this.btnDeleteConfig.setVisible(!this.isReadOnly);
        this.btnRestoreConfig.setVisible(!this.isReadOnly);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.tblConfigFields && !this.isReadOnly) {
            this.editConfigurationField();
            this.informChangeListeners();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.tblConfigFields) {
            this.updateButtons();
        } else if (e.widget == this.btnAddConfig) {
            this.addConfigurationField();
        } else if (e.widget == this.btnDeleteConfig) {
            this.deleteConfigurationField();
        } else if (e.widget == this.btnEditConfig) {
            this.editConfigurationField();
        } else if (e.widget == this.btnRestoreConfig) {
            this.restoreConfigurationField();
        }
        this.informChangeListeners();
    }

    protected void addConfigurationField() {
        ArrayList<String> namesInUse = new ArrayList<String>(this.configDescription.getEntries().keySet());
        ConfigurationEntryWizard wizard = new ConfigurationEntryWizard(namesInUse);
        WizardDialog dialog = new WizardDialog(this.getParent().getShell(), (IWizard)wizard);
        dialog.setPageSize(this.getParent().getShell().getSize().x / 2, 300);
        if (dialog.open() != 0) {
            return;
        }
        String name = wizard.getEntry().getName();
        if (this.configDescription.getEntries().keySet().contains(name)) {
            MessageBox box = new MessageBox(this.getShell());
            box.setMessage("There is already an entry with the given name");
            box.open();
        } else {
            this.configDescription.setEntry(wizard.getEntry());
        }
        this.showData(0);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void deleteConfigurationField() {
        int index = this.tblConfigFields.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String entryName = (String)this.tblConfigFields.getItem(index).getData("entryName");
        boolean isEntryInherited = this.configDescription.isEntryInherited(entryName);
        boolean isEntryOverwritten = this.configDescription.isOverridingEntry(entryName);
        if (isEntryInherited || isEntryOverwritten) {
            this.configDescription.removeInheritedEntry(entryName);
        } else {
            this.configDescription.removeEntry(entryName);
        }
        this.showData(0);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void editConfigurationField() {
        int index = this.tblConfigFields.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String entryName = (String)this.tblConfigFields.getItem(index).getData("entryName");
        boolean inherited = this.configDescription.isEntryInherited(entryName) || this.configDescription.isOverridingEntry(entryName);
        ConfigurationDescription.ConfigurationEntry entry = this.configDescription.getEntry(entryName);
        if (entry == null) {
            return;
        }
        ConfigurationEntryWizard wizard = new ConfigurationEntryWizard(entry, inherited);
        WizardDialog dialog = new WizardDialog(this.getParent().getShell(), (IWizard)wizard);
        dialog.setPageSize(this.getParent().getShell().getSize().x / 2, 300);
        if (dialog.open() != 0) {
            return;
        }
        if (inherited) {
            this.configDescription.overrideEntry(wizard.getEntry());
        } else {
            this.configDescription.setEntry(wizard.getEntry());
        }
        this.showData(index);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void restoreConfigurationField() {
        int index = this.tblConfigFields.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String entryName = (String)this.tblConfigFields.getItem(index).getData("entryName");
        ConfigurationDescription.ConfigurationEntry entry = this.configDescription.getEntry(entryName);
        if (entry == null || this.configDescription.isOverridingEntry(entryName)) {
            this.configDescription.removeEntry(entryName);
        }
        this.showData(index);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
    }

    public static interface ConfigurationDescriptionChangedListener {
        public void configurationDescriptionChanged(ConfigurationDescriptionWidget var1);
    }
}

