/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationWidget;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ConfigurationSection
extends Composite
implements IExpansionListener {
    protected InheritedConfigurationDescription configurationDescription;
    protected ConfigurationWidget confWidget;
    protected FormToolkit toolkit;
    protected RepositoryEditor editor;
    protected boolean isReadOnly;
    private Section section;
    private List<IExpansionListener> expansionListeners;

    public ConfigurationSection(Composite parent, int style, String sectionTitle, String sectionDescription, InheritedConfigurationDescription configurationDescription, InheritedConfiguration configuration, RepositoryEditor editor, boolean readonly, boolean isTestConfiguration, boolean collapseable, FormToolkit toolkit) {
        super(parent, 0);
        this.configurationDescription = configurationDescription;
        this.editor = editor;
        this.isReadOnly = readonly;
        this.expansionListeners = new ArrayList<IExpansionListener>();
        this.setLayout((Layout)new FillLayout());
        int usedStyle = style | 0x100 | 0x80;
        if (collapseable) {
            usedStyle |= 2;
        }
        this.section = toolkit.createSection((Composite)this, usedStyle);
        this.section.setText(sectionTitle);
        this.section.setDescription(sectionDescription);
        this.section.addExpansionListener((IExpansionListener)this);
        Composite client = toolkit.createComposite((Composite)this.section);
        client.setLayout((Layout)new FillLayout());
        this.confWidget = new ConfigurationWidget(client, 0, editor, configuration, configurationDescription, this.isReadOnly, isTestConfiguration, toolkit);
        this.section.setClient((Control)client);
    }

    public InheritedConfiguration getConfiguration() {
        return this.confWidget.getConfiguration();
    }

    public void setConfiguration(InheritedConfiguration configuration) {
        this.confWidget.setConfiguration(configuration);
    }

    public void setConfigurationDescription(InheritedConfigurationDescription newDescription) {
        this.configurationDescription = newDescription;
        this.confWidget.setConfigurationDescription(newDescription);
    }

    public void addExpansionListener(IExpansionListener listener) {
        this.expansionListeners.add(listener);
    }

    public void removeExpansionListener(IExpansionListener listener) {
        this.expansionListeners.remove(listener);
    }

    public void expansionStateChanged(ExpansionEvent e) {
        ExpansionEvent ee = new ExpansionEvent((Object)this, e.getState());
        for (IExpansionListener listener : this.expansionListeners) {
            listener.expansionStateChanged(ee);
        }
    }

    public void expansionStateChanging(ExpansionEvent e) {
        ExpansionEvent ee = new ExpansionEvent((Object)this, e.getState());
        for (IExpansionListener listener : this.expansionListeners) {
            listener.expansionStateChanging(ee);
        }
    }
}

