/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.ConfigurationValueWizard;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationWidget
extends Composite
implements SelectionListener {
    protected InheritedConfiguration configuration;
    protected InheritedConfigurationDescription configurationDescription;
    protected ActivityModelFactory factory;
    protected Table tblConfig;
    protected Button btnAdd;
    protected Button btnDelete;
    protected Button btnEdit;
    protected Button btnRestore;
    protected RepositoryEditor editor;
    protected boolean isReadOnly;
    protected boolean isTestConfiguration;

    public ConfigurationWidget(Composite parent, int style, RepositoryEditor editor, InheritedConfiguration configuration, InheritedConfigurationDescription configurationDescription, boolean readonly, boolean isTestConfiguration, FormToolkit toolkit) {
        super(parent, 0);
        this.configurationDescription = configurationDescription;
        this.configuration = configuration;
        this.isReadOnly = readonly;
        this.isTestConfiguration = isTestConfiguration;
        this.editor = editor;
        this.btnAdd = null;
        this.btnDelete = null;
        this.btnEdit = null;
        this.btnRestore = null;
        this.tblConfig = null;
        this.setLayout((Layout)new GridLayout(2, false));
        this.tblConfig = toolkit.createTable((Composite)this, style | 4 | 0x10000 | 0x800);
        this.tblConfig.setHeaderVisible(true);
        this.tblConfig.setLinesVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.tblConfig.setLayout((Layout)columnLayout);
        String[] titles = new String[]{"Name", "Datatype", "Direct value", "From input parameter", "From process configuration", "Inheritance", "Fixed"};
        float[] weights = new float[]{0.14f, 0.05f, 0.22f, 0.22f, 0.22f, 0.1f, 0.05f};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.tblConfig, 0);
            column.setText(titles[i]);
            columnLayout.setColumnData((Item)column, new ColumnData(weights[i]));
            ++i;
        }
        GridData gd = new GridData(4, 1, true, false, 1, 4);
        gd.heightHint = 200;
        this.tblConfig.setLayoutData((Object)gd);
        this.tblConfig.addSelectionListener((SelectionListener)this);
        this.btnAdd = toolkit.createButton((Composite)this, "Add", 8);
        this.btnAdd.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnDelete = toolkit.createButton((Composite)this, "Delete", 8);
        this.btnDelete.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnDelete.addSelectionListener((SelectionListener)this);
        this.btnDelete.setEnabled(false);
        this.btnEdit = toolkit.createButton((Composite)this, "Edit", 8);
        this.btnEdit.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnEdit.addSelectionListener((SelectionListener)this);
        this.btnEdit.setEnabled(false);
        this.btnRestore = toolkit.createButton((Composite)this, "Inherit", 8);
        this.btnRestore.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnRestore.addSelectionListener((SelectionListener)this);
        this.btnRestore.setEnabled(false);
        this.btnAdd.setVisible(!this.isReadOnly);
        this.btnEdit.setVisible(!this.isReadOnly);
        this.btnDelete.setVisible(!this.isReadOnly);
        this.btnRestore.setVisible(!this.isReadOnly);
        this.showData();
    }

    public InheritedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InheritedConfiguration configuration) {
        this.configuration = configuration;
        this.showData();
    }

    public void setConfigurationDescription(InheritedConfigurationDescription newDescription) {
        this.configurationDescription = newDescription;
        this.updateButtons();
    }

    protected void showData() {
        this.showData(0);
    }

    protected void showData(int selectionIndex) {
        this.tblConfig.removeAll();
        for (String entryName : this.configuration.getAllEntries()) {
            this.addConfigTableItem(entryName);
        }
        if (this.tblConfig.getItemCount() > selectionIndex) {
            this.tblConfig.setSelection(selectionIndex);
        } else if (this.tblConfig.getItemCount() > 0) {
            this.tblConfig.setSelection(0);
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String editString = ConfigurationWidget.this.btnEdit.getText();
                ConfigurationWidget.this.btnEdit.setText("Overwrite_");
                ConfigurationWidget.this.layout();
                ConfigurationWidget.this.btnEdit.setText(editString);
            }
        });
        this.updateButtons();
    }

    protected void showData(String entry) {
        this.tblConfig.removeAll();
        TableItem selectItem = null;
        for (String entryName : this.configuration.getAllEntries()) {
            TableItem item = this.addConfigTableItem(entryName);
            if (!entry.equals(entryName)) continue;
            selectItem = item;
        }
        if (selectItem != null) {
            this.tblConfig.setSelection(selectItem);
        } else if (this.tblConfig.getItemCount() > 0) {
            this.tblConfig.setSelection(0);
        }
        this.updateButtons();
    }

    protected TableItem addConfigTableItem(String entryName) {
        TableItem item = new TableItem(this.tblConfig, 0);
        boolean isFixedByParent = this.isFixedByParent(entryName);
        boolean isFixedForChildren = this.isFixedForChildren(entryName);
        boolean isInherited = this.isInherited(entryName);
        String parameterEntry = this.fromInputParameter(entryName);
        String processEntry = this.fromProcessConfiguration(entryName);
        boolean isRemoved = this.isRemoved(entryName);
        boolean isDeprecated = this.isDeprecated(entryName);
        boolean isOverwritten = this.isOverwritten(entryName);
        String valueStr = this.configuration.getString(entryName);
        String fixedStr = "no";
        String inheritedStr = "not inherited";
        String datatypeStr = "";
        ProcessConstants.AdeptDataType datatype = null;
        if (!isDeprecated) {
            datatype = this.configurationDescription.getEntry(entryName).getDataType();
            datatypeStr = datatype.toString();
        }
        if (isFixedByParent) {
            fixedStr = "by parent";
        } else if (isFixedForChildren) {
            fixedStr = "for children";
        }
        if (isRemoved) {
            inheritedStr = "deleted";
        } else if (isOverwritten) {
            inheritedStr = "overwritten";
        } else if (isInherited) {
            inheritedStr = "inherited";
        }
        item.setText(0, entryName);
        item.setText(1, datatypeStr);
        item.setText(2, valueStr != null ? valueStr : "N/A");
        item.setText(3, parameterEntry != null ? parameterEntry : "N/A");
        item.setText(4, processEntry != null ? processEntry : "N/A");
        item.setText(5, inheritedStr);
        item.setText(6, fixedStr);
        item.setData("datatype", (Object)datatype);
        item.setData("entry", (Object)entryName);
        if (isRemoved) {
            item.setForeground(this.getDisplay().getSystemColor(15));
        }
        if (isDeprecated) {
            item.setForeground(this.getDisplay().getSystemColor(3));
        }
        if (isInherited) {
            FontData oldFontData = item.getFont().getFontData()[0];
            FontData newFontData = new FontData(oldFontData.getName(), oldFontData.getHeight(), oldFontData.getStyle() | 2);
            item.setFont(new Font(item.getFont().getDevice(), newFontData));
        }
        return item;
    }

    protected void updateButtons() {
        if (!this.isEnabled()) {
            this.btnAdd.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRestore.setEnabled(false);
            return;
        }
        this.btnAdd.setEnabled(this.getUnusedEntryCount() > 0);
        if (this.tblConfig.getSelectionCount() == 0) {
            this.btnDelete.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnEdit.setText("Edit");
            this.btnDelete.setText("Delete");
        } else {
            String entryName = (String)this.tblConfig.getItem(this.tblConfig.getSelectionIndex()).getData("entry");
            this.btnEdit.setEnabled((!this.isFixedByParent(entryName) || this.isTestConfiguration) && !this.isReadOnly && !this.isDeprecated(entryName));
            this.btnDelete.setEnabled((!this.isFixedByParent(entryName) || this.isTestConfiguration) && !this.isRemoved(entryName));
            this.btnRestore.setEnabled(this.isOverwritten(entryName));
            if (this.isInherited(entryName)) {
                this.btnEdit.setText("Overwrite");
            } else {
                this.btnEdit.setText("Edit");
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.tblConfig && this.btnEdit.isEnabled() && !this.isReadOnly) {
            this.editConfigurationValue();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.tblConfig) {
            this.updateButtons();
        } else if (e.widget == this.btnAdd) {
            this.addConfigurationValue();
        } else if (e.widget == this.btnDelete) {
            this.deleteConfigurationValue();
        } else if (e.widget == this.btnEdit) {
            this.editConfigurationValue();
        } else if (e.widget == this.btnRestore) {
            this.restoreConfigurationValue();
        }
    }

    protected void addConfigurationValue() {
        ConfigurationValueWizard wizard;
        try {
            wizard = new ConfigurationValueWizard(this.configuration, this.configurationDescription, !this.isTestConfiguration);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageBox box = new MessageBox(this.getShell());
            box.setText("Error");
            box.setMessage("There are no configuration description entries left for creating a new configuration value!");
            box.open();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getParent().getShell(), (IWizard)wizard);
        dialog.setPageSize(this.getParent().getShell().getSize().x / 2, 350);
        if (dialog.open() != 0) {
            return;
        }
        this.configuration = wizard.getConfiguration();
        this.showData(wizard.getEntryName());
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void deleteConfigurationValue() {
        int index = this.tblConfig.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String entryName = (String)this.tblConfig.getItem(index).getData("entry");
        if (this.isInherited(entryName) || this.isOverwritten(entryName)) {
            this.configuration.removeInheritedValue(entryName);
        } else {
            this.configuration.remove(entryName);
        }
        this.showData();
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void editConfigurationValue() {
        int index = this.tblConfig.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String entryName = (String)this.tblConfig.getItem(index).getData("entry");
        ConfigurationValueWizard wizard = new ConfigurationValueWizard(entryName, this.configuration, this.configurationDescription, !this.isTestConfiguration);
        WizardDialog dialog = new WizardDialog(this.getParent().getShell(), (IWizard)wizard);
        dialog.setPageSize(this.getParent().getShell().getSize().x / 2, 350);
        if (dialog.open() != 0) {
            return;
        }
        this.configuration = wizard.getConfiguration();
        this.showData(wizard.getEntryName());
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void restoreConfigurationValue() {
        int index = this.tblConfig.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String entryName = (String)this.tblConfig.getItem(index).getData("entry");
        this.configuration.remove(entryName);
        this.showData(entryName);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected int getUnusedEntryCount() {
        int unusedEntries = 0;
        for (String entryName : this.configurationDescription.getEntries().keySet()) {
            if (this.configuration.getString(entryName) != null) continue;
            ++unusedEntries;
        }
        return unusedEntries;
    }

    protected boolean isFixedByParent(String configurationEntry) {
        return this.configuration.isFixed(configurationEntry);
    }

    protected boolean isFixedForChildren(String configurationEntry) {
        return this.configuration.isFixedForChildren(configurationEntry);
    }

    protected boolean isInherited(String configurationEntry) {
        return this.configuration.isInherited(configurationEntry);
    }

    protected boolean isOverwritten(String configurationEntry) {
        return this.configuration.isOverriding(configurationEntry);
    }

    protected boolean isRemoved(String configurationEntry) {
        return this.isOverwritten(configurationEntry) && this.configuration.getString(configurationEntry) == null;
    }

    protected boolean isDeprecated(String configurationEntry) {
        return !this.configurationDescription.getEntries().keySet().contains(configurationEntry) || this.configurationDescription.getEntry(configurationEntry) == null;
    }

    protected String fromInputParameter(String configurationEntry) {
        if (this.configuration instanceof InheritedActivityConfiguration) {
            return ((InheritedActivityConfiguration)this.configuration).fromInputParameter(configurationEntry);
        }
        return null;
    }

    protected String fromProcessConfiguration(String configurationEntry) {
        if (this.configuration instanceof InheritedActivityConfiguration) {
            return ((InheritedActivityConfiguration)this.configuration).fromProcessConfiguration(configurationEntry);
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
    }
}

