/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DropDownInheritedWidget
extends Composite
implements SelectionListener {
    private Combo combo;
    private Button inheritedButton;
    private List<String> values;
    private List<Object> data;
    private RepositoryEditor editor;
    private List<SelectionListener> selectionListeners;
    private boolean selectionEventsEnabled;
    private final boolean isReadOnly;

    public DropDownInheritedWidget(Composite parent, int style, Boolean inherited, boolean readOnly, RepositoryEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.isReadOnly = readOnly;
        this.editor = parentEditor;
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.numColumns = inherited == null ? 1 : 2;
        this.setLayout((Layout)layout);
        this.selectionEventsEnabled = false;
        this.selectionListeners = new ArrayList<SelectionListener>();
        toolkit.adapt((Composite)this);
        this.combo = new Combo((Composite)this, style | 4 | 8);
        this.combo.setLayoutData((Object)new TableWrapData(256, 32));
        this.combo.setVisibleItemCount(50);
        this.combo.addSelectionListener((SelectionListener)this);
        if (inherited != null) {
            this.inheritedButton = toolkit.createButton((Composite)this, "inherit", 32);
            this.inheritedButton.setLayoutData((Object)new TableWrapData(2, 16));
            this.inheritedButton.addSelectionListener((SelectionListener)this);
            this.inheritedButton.setSelection(inherited.booleanValue());
            this.combo.setEnabled(!this.inheritedButton.getSelection());
        } else {
            this.inheritedButton = null;
        }
        this.values = new ArrayList<String>();
        this.data = new ArrayList<Object>();
        if (this.isReadOnly) {
            this.combo.setEnabled(false);
            if (this.inheritedButton != null) {
                this.inheritedButton.setEnabled(false);
            }
        }
        this.selectionEventsEnabled = true;
    }

    public int size() {
        return this.values.size();
    }

    public void addItem(String value, Object itemData) {
        this.selectionEventsEnabled = false;
        this.values.add(value);
        this.data.add(itemData);
        this.combo.add(value);
        this.selectionEventsEnabled = true;
    }

    public void setInherited(boolean inherited) {
        if (this.inheritedButton != null) {
            this.selectionEventsEnabled = false;
            this.inheritedButton.setSelection(inherited);
            this.combo.setEnabled(!inherited && !this.isReadOnly);
            this.selectionEventsEnabled = true;
        }
    }

    public boolean isInherited() {
        if (this.inheritedButton == null) {
            return false;
        }
        return this.inheritedButton.getSelection();
    }

    public void setIndex(int index) {
        this.selectionEventsEnabled = false;
        this.combo.select(index);
        this.selectionEventsEnabled = true;
    }

    public String getValue() {
        return this.values.get(this.combo.getSelectionIndex());
    }

    public Object getSelectedData() {
        return this.data.get(this.combo.getSelectionIndex());
    }

    public int getIndex() {
        return this.combo.getSelectionIndex();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void selectionEvent() {
        if (!this.selectionEventsEnabled) {
            return;
        }
        for (SelectionListener listener : this.selectionListeners) {
            Event e = new Event();
            e.widget = this;
            listener.widgetSelected(new SelectionEvent(e));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.inheritedButton != null) {
            this.combo.setEnabled(!this.inheritedButton.getSelection());
        }
        if (this.editor != null && this.selectionEventsEnabled) {
            this.editor.setDirty(true);
        }
        this.selectionEvent();
    }

    public void setEnabled(boolean enabled) {
        if (this.inheritedButton != null) {
            this.inheritedButton.setEnabled(enabled);
        }
        this.combo.setEnabled(enabled && (this.inheritedButton == null || !this.inheritedButton.getSelection()));
        super.setEnabled(enabled);
    }

    public void setInheritedTextValue(String value) {
        if (this.inheritedButton != null) {
            this.inheritedButton.setText(value);
        }
    }
}

