/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExecutionControlPropertiesWidget
extends Composite
implements SelectionListener {
    private Button inheritedButton;
    private RepositoryEditor editor;
    private static final String SUSPENSIBLE = "suspensible";
    private static final String RESETTABLE = "resettable";
    private static final String CLOSEABLE = "closeable";
    private List<SelectionListener> selectionListeners;
    private boolean selectionEventsEnabled;
    private Map<String, Button> buttons;
    private final boolean isReadOnly;

    public ExecutionControlPropertiesWidget(Composite parent, int style, ExecutionControlProperties ecp, Boolean inherited, boolean readOnly, RepositoryEditor parentEditor) {
        super(parent, style);
        this.isReadOnly = readOnly;
        this.editor = parentEditor;
        this.selectionEventsEnabled = false;
        this.selectionListeners = new ArrayList<SelectionListener>();
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        this.setLayout((Layout)new GridLayout(1, false));
        if (inherited != null) {
            this.inheritedButton = toolkit.createButton((Composite)this, "inherit", 32);
            this.inheritedButton.setLayoutData((Object)new GridData());
            this.inheritedButton.addSelectionListener((SelectionListener)this);
            this.inheritedButton.setSelection(inherited.booleanValue());
        } else {
            this.inheritedButton = null;
        }
        this.buttons = new HashMap<String, Button>();
        this.buttons.put(SUSPENSIBLE, toolkit.createButton((Composite)this, SUSPENSIBLE, 32));
        this.buttons.put(RESETTABLE, toolkit.createButton((Composite)this, RESETTABLE, 32));
        this.buttons.put(CLOSEABLE, toolkit.createButton((Composite)this, CLOSEABLE, 32));
        this.buttons.get(SUSPENSIBLE).setLayoutData((Object)new GridData());
        this.buttons.get(RESETTABLE).setLayoutData((Object)new GridData());
        this.buttons.get(CLOSEABLE).setLayoutData((Object)new GridData());
        this.buttons.get(SUSPENSIBLE).setSelection(ecp.isSuspensible());
        this.buttons.get(RESETTABLE).setSelection(ecp.isResettable());
        this.buttons.get(CLOSEABLE).setSelection(ecp.isClosable());
        this.buttons.get(SUSPENSIBLE).addSelectionListener((SelectionListener)this);
        this.buttons.get(RESETTABLE).addSelectionListener((SelectionListener)this);
        this.buttons.get(CLOSEABLE).addSelectionListener((SelectionListener)this);
        if (inherited != null) {
            this.setInherited(inherited);
        }
        if (this.isReadOnly) {
            this.buttons.get(SUSPENSIBLE).setEnabled(false);
            this.buttons.get(RESETTABLE).setEnabled(false);
            this.buttons.get(CLOSEABLE).setEnabled(false);
            if (this.inheritedButton != null) {
                this.inheritedButton.setEnabled(false);
            }
        }
        this.selectionEventsEnabled = true;
    }

    public void setInherited(boolean inherited) {
        if (this.inheritedButton != null) {
            this.selectionEventsEnabled = false;
            this.inheritedButton.setSelection(inherited);
            this.buttons.get(SUSPENSIBLE).setEnabled(!inherited && !this.isReadOnly);
            this.buttons.get(RESETTABLE).setEnabled(!inherited && !this.isReadOnly);
            this.buttons.get(CLOSEABLE).setEnabled(!inherited && !this.isReadOnly);
            this.selectionEventsEnabled = true;
        }
    }

    public boolean isInherited() {
        if (this.inheritedButton == null) {
            return false;
        }
        return this.inheritedButton.getSelection();
    }

    public ExecutionControlProperties getValue() {
        return new ExecutionControlProperties(this.buttons.get(SUSPENSIBLE).getSelection(), this.buttons.get(RESETTABLE).getSelection(), this.buttons.get(CLOSEABLE).getSelection());
    }

    public void setExecutionControlProperties(ExecutionControlProperties ecp) {
        this.selectionEventsEnabled = false;
        this.buttons.get(SUSPENSIBLE).setSelection(ecp.isSuspensible());
        this.buttons.get(RESETTABLE).setSelection(ecp.isResettable());
        this.buttons.get(CLOSEABLE).setSelection(ecp.isClosable());
        this.selectionEventsEnabled = true;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void selectionEvent() {
        if (!this.selectionEventsEnabled) {
            return;
        }
        for (SelectionListener listener : this.selectionListeners) {
            Event e = new Event();
            e.widget = this;
            listener.widgetSelected(new SelectionEvent(e));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.inheritedButton != null) {
            this.buttons.get(SUSPENSIBLE).setEnabled(!this.inheritedButton.getSelection());
            this.buttons.get(RESETTABLE).setEnabled(!this.inheritedButton.getSelection());
            this.buttons.get(CLOSEABLE).setEnabled(!this.inheritedButton.getSelection());
        }
        if (this.editor != null && this.selectionEventsEnabled) {
            this.editor.setDirty(true);
        }
        this.selectionEvent();
    }

    public void setEnabled(boolean enabled) {
        if (this.inheritedButton != null) {
            this.inheritedButton.setEnabled(enabled);
        }
        this.buttons.get(SUSPENSIBLE).setEnabled(enabled && (this.inheritedButton == null || !this.inheritedButton.getSelection()));
        this.buttons.get(RESETTABLE).setEnabled(enabled && (this.inheritedButton == null || !this.inheritedButton.getSelection()));
        this.buttons.get(CLOSEABLE).setEnabled(enabled && (this.inheritedButton == null || !this.inheritedButton.getSelection()));
        super.setEnabled(enabled);
    }
}

