/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterTemplateController;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.ParameterTemplateWizard;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.util.FontTools;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterTemplateWidget
extends Composite
implements ISelectionChangedListener,
SelectionListener,
IDoubleClickListener {
    private Shell parentShell;
    private Button btnAdd;
    private Button btnDelete;
    private Button btnEditShow;
    private static final String COL_TEMPLATENAME = "colTemplateName";
    private static final String COL_NAME = "colName";
    private static final String COL_DATATYPE = "colDataType";
    private static final String COL_TEMPLATEDESCRIPTION = "colTemplateDescription";
    private static final String COL_ACCESSTYPE = "colAccessType";
    private final ParameterTemplateController controller;
    private ListUIComponent list;
    private final boolean isReadOnly;
    private final RepositoryEditor editor;
    private static Font italicFont = null;

    public ParameterTemplateWidget(Composite parent, int style, ParameterTemplateController paramController, boolean readOnly, FormToolkit toolkit, RepositoryEditor editor) {
        super(parent, 0);
        this.controller = paramController;
        this.isReadOnly = readOnly;
        this.editor = editor;
        this.setLayout((Layout)new GridLayout(2, false));
        this.list = new ListUIComponent((Composite)this, style | 0x10000 | 0x800);
        ((Table)this.list.getColumnControl()).setLinesVisible(true);
        this.list.registerColumn(COL_TEMPLATENAME, "Template Name", 16384, new ColumnData(3.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)element;
                    return ((ParameterTemplate)entry.getValue()).getTemplateName() == null ? "" : ((ParameterTemplate)entry.getValue()).getTemplateName();
                }
                return "unknown element";
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterTemplateWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (element instanceof Map.Entry && ParameterTemplateWidget.this.isParameterTemplateInherited((String)(entry = (Map.Entry)element).getKey())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_TEMPLATEDESCRIPTION, "Template Description", 16384, new ColumnData(3.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return ((ParameterTemplate)entry.getValue()).getTemplateDescription() == null ? "" : ((ParameterTemplate)entry.getValue()).getTemplateDescription();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterTemplateWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (element instanceof Map.Entry && ParameterTemplateWidget.this.isParameterTemplateInherited((String)(entry = (Map.Entry)element).getKey())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_NAME, "Name", 16384, new ColumnData(3.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return ((ParameterTemplate)entry.getValue()).getName();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterTemplateWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (element instanceof Map.Entry && ParameterTemplateWidget.this.isParameterTemplateInherited((String)(entry = (Map.Entry)element).getKey())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_DATATYPE, "Data type", 16384, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                if (((ParameterTemplate)entry.getValue()).getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    return ((ParameterTemplate)entry.getValue()).getUDTName();
                }
                return ((ParameterTemplate)entry.getValue()).getDataType() == null ? "" : ((ParameterTemplate)entry.getValue()).getDataType().toString();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterTemplateWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (element instanceof Map.Entry && ParameterTemplateWidget.this.isParameterTemplateInherited((String)(entry = (Map.Entry)element).getKey())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_ACCESSTYPE, "Access type", 16384, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return ((ParameterTemplate)entry.getValue()).getAccessType() == null ? "" : ((ParameterTemplate)entry.getValue()).getAccessType().toString();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterTemplateWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (element instanceof Map.Entry && ParameterTemplateWidget.this.isParameterTemplateInherited((String)(entry = (Map.Entry)element).getKey())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.initColumns(new String[]{COL_TEMPLATENAME, COL_NAME, COL_DATATYPE, COL_ACCESSTYPE, COL_TEMPLATEDESCRIPTION}, null, null, true);
        this.list.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, this.isReadOnly ? 1 : 3));
        this.list.getColumnViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.getColumnViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.parentShell = parent.getShell();
        if (!this.isReadOnly) {
            this.btnAdd = toolkit.createButton((Composite)this, "Add", 8);
            this.btnAdd.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnAdd.addSelectionListener((SelectionListener)this);
            this.btnDelete = toolkit.createButton((Composite)this, "Delete", 8);
            this.btnDelete.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnDelete.addSelectionListener((SelectionListener)this);
            this.btnDelete.setEnabled(false);
            this.btnEditShow = toolkit.createButton((Composite)this, "Edit", 8);
            this.btnEditShow.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnEditShow.addSelectionListener((SelectionListener)this);
            this.btnEditShow.setEnabled(false);
        } else {
            this.btnEditShow = toolkit.createButton((Composite)this, "Show", 8);
            this.btnEditShow.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnEditShow.addSelectionListener((SelectionListener)this);
            this.btnEditShow.setEnabled(false);
        }
        this.showData();
    }

    private boolean isParameterTemplateInherited(String name) {
        return !this.controller.getParameterTemplates(this).getAllOwn().containsKey(name);
    }

    public void showData() {
        this.list.setInput(this.controller.getParameterTemplates(this).getAll().entrySet());
        this.list.getColumnViewer().refresh();
        this.updateButtons(null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.editShowParameterTemplate();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnAdd) {
            this.addParameterTemplate();
        } else if (e.widget == this.btnDelete) {
            this.deleteParameterTemplate();
        } else if (e.widget == this.btnEditShow) {
            this.editShowParameterTemplate();
        }
    }

    protected void addParameterTemplate() {
        Set<String> disallowedNames = this.controller.getParameterChangePolicy(this) == ParameterChangePolicy.ADD_PARAMETERS || this.controller.getParameterChangePolicy(this) == ParameterChangePolicy.ADD_VIRTUAL ? this.controller.getParameterTemplates(this).getAll().keySet() : this.controller.getParameterTemplates(this).getAllOwn().keySet();
        ParameterTemplateWizard wizard = new ParameterTemplateWizard(Activator.getService().getSessionToken(), disallowedNames);
        WizardDialog dialog = new WizardDialog(this.parentShell, (IWizard)wizard);
        dialog.setPageSize(this.getParent().getShell().getSize().x / 2, 300);
        if (dialog.open() == 0) {
            ParameterTemplate parameterTemplate = wizard.getParameterTemplate();
            if (this.controller.getParameterChangePolicy(this) == ParameterChangePolicy.ADD_VIRTUAL && !parameterTemplate.isVirtual().booleanValue()) {
                Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
                MessageBox msgBox = new MessageBox(shell, 33);
                msgBox.setMessage("Only virtual parameter templates may be added because the Parameter Change Policy is set to ADD_VIRTUAL.");
                msgBox.setText("Only virtual parameters may be added");
                msgBox.open();
                return;
            }
            InheritedCollection<String, ParameterTemplate> params = this.controller.getParameterTemplates(this);
            params.set((Object)parameterTemplate.getTemplateName(), (Object)parameterTemplate);
            this.controller.parameterTemplatesChanged(params);
            this.showData();
            if (this.editor != null) {
                this.editor.setDirty(true);
            }
        }
    }

    protected void deleteParameterTemplate() {
        IStructuredSelection sel = (IStructuredSelection)this.list.getColumnViewer().getSelection();
        Map.Entry e = (Map.Entry)sel.getFirstElement();
        if (this.isParameterTemplateInherited((String)e.getKey())) {
            return;
        }
        InheritedCollection<String, ParameterTemplate> params = this.controller.getParameterTemplates(this);
        params.removeOwnValue((Object)((String)e.getKey()));
        this.controller.parameterTemplatesChanged(params);
        this.showData();
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void editShowParameterTemplate() {
        IStructuredSelection sel = (IStructuredSelection)this.list.getColumnViewer().getSelection();
        Map.Entry e = (Map.Entry)sel.getFirstElement();
        String oldParameterTemplateName = ((ParameterTemplate)e.getValue()).getTemplateName();
        InheritedCollection<String, ParameterTemplate> collection = this.controller.getParameterTemplates(this);
        ParameterTemplate parameterTemplate = (ParameterTemplate)collection.get((Object)oldParameterTemplateName);
        boolean isInherited = collection.isInherited((Object)oldParameterTemplateName);
        if (this.controller.getParameterTemplates(this).isInherited((Object)oldParameterTemplateName)) {
            parameterTemplate = Activator.getService().getActivityModelFactory().createParameterTemplate(parameterTemplate, parameterTemplate.getTemplateName(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
        ParameterChangePolicy pcp = this.controller.getParameterChangePolicy(this);
        boolean openAsReadOnly = this.isReadOnly || pcp != ParameterChangePolicy.GENERIC && pcp != ParameterChangePolicy.CHANGE_PARAMETERS && pcp != ParameterChangePolicy.ADD_CHANGE_PARAMETERS && (pcp != ParameterChangePolicy.ADD_PARAMETERS || isInherited);
        ParameterTemplateWizard wizard = new ParameterTemplateWizard(Activator.getService().getSessionToken(), parameterTemplate, this.controller.getParameterTemplates(this).getAllOwn().keySet(), openAsReadOnly);
        WizardDialog dialog = new WizardDialog(this.parentShell, (IWizard)wizard);
        dialog.setPageSize(this.getParent().getShell().getSize().x / 2, 300);
        if (dialog.open() == 0) {
            if (this.isReadOnly) {
                return;
            }
            InheritedCollection<String, ParameterTemplate> params = this.controller.getParameterTemplates(this);
            params.removeOwnValue((Object)oldParameterTemplateName);
            params.set((Object)parameterTemplate.getTemplateName(), (Object)parameterTemplate);
            this.controller.parameterTemplatesChanged(params);
            this.showData();
            if (this.editor != null) {
                this.editor.setDirty(true);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o;
        if (event.getSelection() instanceof StructuredSelection && (o = ((StructuredSelection)event.getSelection()).getFirstElement()) instanceof Map.Entry) {
            ParameterTemplate template = (ParameterTemplate)((Map.Entry)o).getValue();
            this.updateButtons(template);
        }
    }

    private void updateButtons(ParameterTemplate selectedObject) {
        if (!this.getEnabled()) {
            this.btnAdd.setEnabled(false);
            this.btnEditShow.setEnabled(false);
            this.btnDelete.setEnabled(false);
            return;
        }
        ParameterChangePolicy pcp = this.controller.getParameterChangePolicy(this);
        if (pcp == ParameterChangePolicy.FIXED) {
            if (this.btnDelete != null) {
                this.btnDelete.setEnabled(false);
            }
            this.btnEditShow.setEnabled(selectedObject != null);
            this.btnEditShow.setText("Show");
            if (this.btnAdd != null) {
                this.btnAdd.setEnabled(false);
            }
        } else if (pcp == ParameterChangePolicy.GENERIC) {
            if (this.btnDelete != null) {
                this.btnDelete.setEnabled(selectedObject != null && !this.isParameterTemplateInherited(selectedObject.getTemplateName()));
            }
            this.btnEditShow.setEnabled(selectedObject != null);
            this.btnEditShow.setText("Edit");
            if (this.btnAdd != null) {
                this.btnAdd.setEnabled(!this.isReadOnly);
            }
        } else {
            if (this.btnAdd != null) {
                this.btnAdd.setEnabled((pcp == ParameterChangePolicy.ADD_CHANGE_PARAMETERS || pcp == ParameterChangePolicy.ADD_PARAMETERS || pcp == ParameterChangePolicy.ADD_VIRTUAL) && !this.isReadOnly);
            }
            if (this.btnDelete != null) {
                this.btnDelete.setEnabled(false);
            }
            this.btnEditShow.setEnabled(selectedObject != null);
            this.btnEditShow.setText("Show/Edit");
        }
        if (this.isReadOnly) {
            this.btnEditShow.setText("Show");
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.getEnabled()) {
            this.editShowParameterTemplate();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.updateButtons(null);
        } else if (this.list.getColumnViewer().getSelection() != null && this.list.getColumnViewer().getSelection() instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)this.list.getColumnViewer().getSelection();
            Map.Entry e = (Map.Entry)sel.getFirstElement();
            this.updateButtons((ParameterTemplate)e.getValue());
        } else {
            this.updateButtons(null);
        }
    }
}

