/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.controllers.ParameterTemplateController;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.DropDownInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.ParameterWizard;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.util.FontTools;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterWidget
extends Composite
implements ISelectionChangedListener,
SelectionListener,
IDoubleClickListener {
    private Shell parentShell;
    private Button btnAddParameter;
    private Button btnDeleteParameter;
    private Button btnEditShowParameter;
    private static final String COL_NAME = "colName";
    private static final String COL_DATATYPE = "colDataType";
    private static final String COL_DESCRIPTION = "colDescription";
    private static final String COL_ACCESSTYPE = "colAccessType";
    private final ParameterController controller;
    private ListUIComponent list;
    private final boolean isReadOnly;
    private final RepositoryEditor editor;
    private static Font italicFont = null;
    private final ParameterTemplateController templateController;
    private Button btnAddParameterFromTemplate = null;
    private final FormToolkit toolkit;

    public ParameterWidget(Composite parent, int style, ParameterController paramController, ParameterTemplateController templateController, boolean readOnly, FormToolkit toolkit, RepositoryEditor editor) {
        super(parent, 0);
        this.controller = paramController;
        this.templateController = templateController;
        this.isReadOnly = readOnly;
        this.toolkit = toolkit;
        this.editor = editor;
        this.setLayout((Layout)new GridLayout(2, false));
        this.list = new ListUIComponent((Composite)this, style | 0x10000 | 0x800);
        ((Table)this.list.getColumnControl()).setLinesVisible(true);
        this.list.registerColumn(COL_NAME, "Name", 16384, new ColumnData(3.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)((Pair)entry.getKey()).getFirst();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (ParameterWidget.this.isParameterInherited((String)((Pair)(entry = (Map.Entry)element).getKey()).getFirst(), (ActivityConstants.AccessType)((Pair)entry.getKey()).getSecond())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_DATATYPE, "Data type", 16384, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                if (((ActivityModelParameter)entry.getValue()).getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    return ((ActivityModelParameter)entry.getValue()).getUDTName();
                }
                return ((ActivityModelParameter)entry.getValue()).getDataType().toString();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (ParameterWidget.this.isParameterInherited((String)((Pair)(entry = (Map.Entry)element).getKey()).getFirst(), (ActivityConstants.AccessType)((Pair)entry.getKey()).getSecond())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_ACCESSTYPE, "Access type", 16384, new ColumnData(2.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return ((ActivityConstants.AccessType)((Pair)entry.getKey()).getSecond()).toString();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (ParameterWidget.this.isParameterInherited((String)((Pair)(entry = (Map.Entry)element).getKey()).getFirst(), (ActivityConstants.AccessType)((Pair)entry.getKey()).getSecond())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.registerColumn(COL_DESCRIPTION, "Description", 16384, new ColumnData(3.0f), (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return ((ActivityModelParameter)entry.getValue()).getDescription();
            }

            public Font getFont(Object element) {
                Map.Entry entry;
                if (italicFont == null) {
                    italicFont = FontTools.deriveFontStyle((Font)ParameterWidget.this.list.getColumnControl().getFont(), (int)2);
                }
                if (ParameterWidget.this.isParameterInherited((String)((Pair)(entry = (Map.Entry)element).getKey()).getFirst(), (ActivityConstants.AccessType)((Pair)entry.getKey()).getSecond())) {
                    return italicFont;
                }
                return super.getFont(element);
            }
        }, null);
        this.list.initColumns(new String[]{COL_NAME, COL_DATATYPE, COL_ACCESSTYPE, COL_DESCRIPTION}, null, null, true);
        int layoutRows = this.isReadOnly ? 1 : (this.templateController != null ? 4 : 3);
        this.list.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, layoutRows));
        this.list.getColumnViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.getColumnViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.parentShell = parent.getShell();
        if (!this.isReadOnly) {
            this.btnAddParameter = toolkit.createButton((Composite)this, "Add", 8);
            this.btnAddParameter.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnAddParameter.addSelectionListener((SelectionListener)this);
            if (this.templateController != null) {
                this.btnAddParameterFromTemplate = toolkit.createButton((Composite)this, "Add (template)", 8);
                this.btnAddParameterFromTemplate.setLayoutData((Object)new GridData(4, 1, false, false));
                this.btnAddParameterFromTemplate.addSelectionListener((SelectionListener)this);
            }
            this.btnDeleteParameter = toolkit.createButton((Composite)this, "Delete", 8);
            this.btnDeleteParameter.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnDeleteParameter.addSelectionListener((SelectionListener)this);
            this.btnDeleteParameter.setEnabled(false);
            this.btnEditShowParameter = toolkit.createButton((Composite)this, "Edit", 8);
            this.btnEditShowParameter.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnEditShowParameter.addSelectionListener((SelectionListener)this);
            this.btnEditShowParameter.setEnabled(false);
        } else {
            this.btnEditShowParameter = toolkit.createButton((Composite)this, "Show", 8);
            this.btnEditShowParameter.setLayoutData((Object)new GridData(4, 1, false, false));
            this.btnEditShowParameter.addSelectionListener((SelectionListener)this);
            this.btnEditShowParameter.setEnabled(false);
        }
        this.showData();
    }

    private boolean isParameterInherited(String name, ActivityConstants.AccessType accessType) {
        return !this.controller.getParameters(this, accessType).getAllOwn().containsKey(name);
    }

    public void showData() {
        this.list.setInput(this.getFlatParameters(null, null).entrySet());
        this.list.getColumnViewer().refresh();
        this.updateButtons(null, null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.editShowParameterItem();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnAddParameter) {
            this.addParameterItem(null);
        } else if (e.widget == this.btnDeleteParameter) {
            this.deleteParameterItem();
        } else if (e.widget == this.btnEditShowParameter) {
            this.editShowParameterItem();
        } else if (e.widget == this.btnAddParameterFromTemplate && e.widget != null) {
            if (this.templateController.getParameterTemplates(null).getAll().size() == 0) {
                MessageBox box = new MessageBox(this.getShell(), 1);
                box.setText("Error");
                box.setMessage("No templates available!");
                box.open();
                return;
            }
            TemplateSelectionDialog dialog = new TemplateSelectionDialog(this.getShell(), this.templateController);
            dialog.setBlockOnOpen(true);
            dialog.create();
            dialog.open();
            if (dialog.isOK()) {
                this.addParameterItem(dialog.getTemplate());
            }
        }
    }

    protected void addParameterItem(ParameterTemplate template) {
        ActivityConstants.AccessType accessType;
        int n;
        int n2;
        ActivityConstants.AccessType[] accessTypeArray;
        HashSet<Pair<String, ActivityConstants.AccessType>> disallowedParams = new HashSet<Pair<String, ActivityConstants.AccessType>>();
        if (this.controller.getParameterChangePolicy(this) == ParameterChangePolicy.ADD_PARAMETERS || this.controller.getParameterChangePolicy(this) == ParameterChangePolicy.ADD_VIRTUAL) {
            accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
            n2 = accessTypeArray.length;
            n = 0;
            while (n < n2) {
                accessType = accessTypeArray[n];
                for (String name : this.controller.getParameters(this, accessType).getAll().keySet()) {
                    disallowedParams.add((Pair<String, ActivityConstants.AccessType>)new Pair((Object)name, (Object)accessType));
                }
                ++n;
            }
        } else {
            accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
            n2 = accessTypeArray.length;
            n = 0;
            while (n < n2) {
                accessType = accessTypeArray[n];
                for (String name : this.controller.getParameters(this, accessType).getAllOwn().keySet()) {
                    disallowedParams.add((Pair<String, ActivityConstants.AccessType>)new Pair((Object)name, (Object)accessType));
                }
                ++n;
            }
        }
        ParameterWizard wizard = new ParameterWizard(Activator.getService().getSessionToken(), disallowedParams, template);
        WizardDialog dialog = new WizardDialog(this.parentShell, (IWizard)wizard);
        if (dialog.open() == 0) {
            ActivityModelParameter parameter = wizard.getParameter();
            if (this.controller.getParameterChangePolicy(this) == ParameterChangePolicy.ADD_VIRTUAL && !parameter.isVirtual()) {
                Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
                MessageBox msgBox = new MessageBox(shell, 33);
                msgBox.setMessage("Only virtual parameters may be added because the operations Parameter Changed Policy is set to ADD_VIRTUAL.");
                msgBox.setText("Only virtual parameters may be added");
                msgBox.open();
                return;
            }
            InheritedCollection<String, ActivityModelParameter> params = this.controller.getParameters(this, wizard.getAccessType());
            params.set((Object)parameter.getName(), (Object)parameter);
            this.controller.parametersChanged(params, wizard.getAccessType());
            this.showData();
            if (this.editor != null) {
                this.editor.setDirty(true);
            }
        }
    }

    protected void deleteParameterItem() {
        IStructuredSelection sel = (IStructuredSelection)this.list.getColumnViewer().getSelection();
        Map.Entry e = (Map.Entry)sel.getFirstElement();
        if (this.isParameterInherited((String)((Pair)e.getKey()).getFirst(), (ActivityConstants.AccessType)((Pair)e.getKey()).getSecond())) {
            return;
        }
        InheritedCollection<String, ActivityModelParameter> params = this.controller.getParameters(this, (ActivityConstants.AccessType)((Pair)e.getKey()).getSecond());
        params.removeOwnValue((Object)((String)((Pair)e.getKey()).getFirst()));
        this.controller.parametersChanged(params, (ActivityConstants.AccessType)((Pair)e.getKey()).getSecond());
        this.showData();
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void editShowParameterItem() {
        IStructuredSelection sel = (IStructuredSelection)this.list.getColumnViewer().getSelection();
        Map.Entry e = (Map.Entry)sel.getFirstElement();
        ActivityConstants.AccessType oldAccessType = (ActivityConstants.AccessType)((Pair)e.getKey()).getSecond();
        String oldParameterName = ((ActivityModelParameter)e.getValue()).getName();
        InheritedCollection<String, ActivityModelParameter> collection = this.controller.getParameters(this, oldAccessType);
        ActivityModelParameter parameter = (ActivityModelParameter)collection.get((Object)oldParameterName);
        boolean isInherited = collection.isInherited((Object)oldParameterName);
        HashSet<Pair<String, ActivityConstants.AccessType>> ownParams = new HashSet<Pair<String, ActivityConstants.AccessType>>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            for (String name : this.controller.getParameters(this, accessType).getAllOwn().keySet()) {
                if (name.equals(oldParameterName) && oldAccessType.equals((Object)oldAccessType)) continue;
                ownParams.add((Pair<String, ActivityConstants.AccessType>)new Pair((Object)name, (Object)accessType));
            }
            ++n2;
        }
        ParameterChangePolicy pcp = this.controller.getParameterChangePolicy(this);
        boolean openAsReadOnly = this.isReadOnly || pcp != ParameterChangePolicy.GENERIC && pcp != ParameterChangePolicy.CHANGE_PARAMETERS && pcp != ParameterChangePolicy.ADD_CHANGE_PARAMETERS && (pcp != ParameterChangePolicy.ADD_PARAMETERS || isInherited);
        ParameterWizard wizard = new ParameterWizard(Activator.getService().getSessionToken(), parameter, oldAccessType, ownParams, openAsReadOnly);
        WizardDialog dialog = new WizardDialog(this.parentShell, (IWizard)wizard);
        if (dialog.open() == 0) {
            InheritedCollection<String, ActivityModelParameter> params;
            if (this.isReadOnly) {
                return;
            }
            if (oldAccessType != wizard.getAccessType()) {
                params = this.controller.getParameters(this, oldAccessType);
                params.removeOwnValue((Object)oldParameterName);
                this.controller.parametersChanged(params, oldAccessType);
            }
            params = this.controller.getParameters(this, wizard.getAccessType());
            params.removeOwnValue((Object)oldParameterName);
            params.set((Object)parameter.getName(), (Object)parameter);
            this.controller.parametersChanged(params, wizard.getAccessType());
            this.showData();
            if (this.editor != null) {
                this.editor.setDirty(true);
            }
        }
    }

    private Map<Pair<String, ActivityConstants.AccessType>, ActivityModelParameter> getFlatParameters(ActivityModelParameter editParam, ActivityConstants.AccessType editAccessType) {
        HashMap<Pair<String, ActivityConstants.AccessType>, ActivityModelParameter> result = new HashMap<Pair<String, ActivityConstants.AccessType>, ActivityModelParameter>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            for (Map.Entry e : this.controller.getParameters(this, accessType).getAll().entrySet()) {
                if (accessType == editAccessType && e.getValue() == editParam) continue;
                result.put((Pair<String, ActivityConstants.AccessType>)new Pair((Object)((String)e.getKey()), (Object)accessType), (ActivityModelParameter)e.getValue());
            }
            ++n2;
        }
        return result;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o;
        if (event.getSelection() instanceof StructuredSelection && (o = ((StructuredSelection)event.getSelection()).getFirstElement()) instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            this.updateButtons((ActivityModelParameter)e.getValue(), (ActivityConstants.AccessType)((Pair)e.getKey()).getSecond());
        }
    }

    private void updateButtons(ActivityModelParameter selectedObject, ActivityConstants.AccessType accessType) {
        if (!this.getEnabled()) {
            this.btnDeleteParameter.setEnabled(false);
            this.btnAddParameter.setEnabled(false);
            this.btnAddParameterFromTemplate.setEnabled(false);
            this.btnEditShowParameter.setEnabled(false);
            return;
        }
        ParameterChangePolicy pcp = this.controller.getParameterChangePolicy(this);
        if (pcp == ParameterChangePolicy.FIXED) {
            if (this.btnDeleteParameter != null) {
                this.btnDeleteParameter.setEnabled(false);
            }
            this.btnEditShowParameter.setEnabled(selectedObject != null);
            this.btnEditShowParameter.setText("Show");
            if (this.btnAddParameter != null) {
                this.btnAddParameter.setEnabled(false);
                this.btnAddParameterFromTemplate.setEnabled(false);
            }
        } else if (pcp == ParameterChangePolicy.GENERIC) {
            if (this.btnDeleteParameter != null) {
                this.btnDeleteParameter.setEnabled(selectedObject != null && !this.isParameterInherited(selectedObject.getName(), accessType));
            }
            this.btnEditShowParameter.setEnabled(selectedObject != null);
            this.btnEditShowParameter.setText("Edit");
            if (this.btnAddParameter != null) {
                this.btnAddParameter.setEnabled(!this.isReadOnly);
                this.btnAddParameterFromTemplate.setEnabled(!this.isReadOnly);
            }
        } else {
            if (this.btnAddParameter != null) {
                this.btnAddParameter.setEnabled((pcp == ParameterChangePolicy.ADD_CHANGE_PARAMETERS || pcp == ParameterChangePolicy.ADD_PARAMETERS || pcp == ParameterChangePolicy.ADD_VIRTUAL) && !this.isReadOnly);
                this.btnAddParameterFromTemplate.setEnabled(this.btnAddParameter.getEnabled());
            }
            if (this.btnDeleteParameter != null) {
                this.btnDeleteParameter.setEnabled(false);
            }
            this.btnEditShowParameter.setEnabled(selectedObject != null);
            this.btnEditShowParameter.setText("Show/Edit");
        }
        if (this.isReadOnly) {
            this.btnEditShowParameter.setText("Show");
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.getEnabled()) {
            this.editShowParameterItem();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.updateButtons(null, null);
        } else if (this.list.getColumnViewer().getSelection() != null && this.list.getColumnViewer().getSelection() instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)this.list.getColumnViewer().getSelection();
            Map.Entry e = (Map.Entry)sel.getFirstElement();
            this.updateButtons((ActivityModelParameter)e.getValue(), (ActivityConstants.AccessType)((Pair)e.getKey()).getSecond());
        } else {
            this.updateButtons(null, null);
        }
    }

    protected class TemplateSelectionDialog
    extends TitleAreaDialog {
        private final ParameterTemplateController paramTemplatecontroller;
        private boolean ok;
        private ParameterTemplate template;
        private DropDownInheritedWidget dropDown;

        protected TemplateSelectionDialog(Shell parentShell, ParameterTemplateController controller) {
            super(parentShell);
            this.ok = false;
            this.template = null;
            this.paramTemplatecontroller = controller;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(1, false));
            ParameterWidget.this.toolkit.adapt(container);
            this.setTitle("Select template");
            this.setMessage("Select the template the new parameter should get built from");
            this.dropDown = new DropDownInheritedWidget(container, 0, null, false, null, ParameterWidget.this.toolkit);
            this.dropDown.setLayoutData(new GridData(4, 1, true, false));
            for (Map.Entry templateEntry : this.paramTemplatecontroller.getParameterTemplates(null).getAll().entrySet()) {
                this.dropDown.addItem(((ParameterTemplate)templateEntry.getValue()).getTemplateName(), templateEntry.getValue());
            }
            this.dropDown.setIndex(0);
            return container;
        }

        protected void okPressed() {
            this.template = (ParameterTemplate)this.dropDown.getSelectedData();
            this.ok = true;
            super.okPressed();
        }

        public boolean isOK() {
            return this.ok;
        }

        public ParameterTemplate getTemplate() {
            return this.template;
        }
    }
}

