/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TextInheritedWidget
extends Composite
implements ModifyListener,
SelectionListener {
    private Text text;
    private Button inheritedButton;
    private final RepositoryEditor editor;
    private List<ModifyListener> modifyListeners;
    private List<SelectionListener> selectionListeners;
    private boolean selectionEventsEnabled;
    private boolean modifyEventsEnabled;
    private final boolean isReadOnly;

    public TextInheritedWidget(Composite parent, int style, String defaultValue, Boolean inherited, boolean readOnly, RepositoryEditor parentEditor, FormToolkit toolkit) {
        super(parent, 0);
        this.isReadOnly = readOnly;
        this.editor = parentEditor;
        this.selectionEventsEnabled = false;
        this.modifyEventsEnabled = false;
        this.modifyListeners = new ArrayList<ModifyListener>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = inherited != null ? 2 : 1;
        layout.bottomMargin = 0;
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        this.setLayout((Layout)layout);
        toolkit.adapt((Composite)this);
        this.text = toolkit.createText((Composite)this, "", style | 0x800);
        this.text.setLayoutData((Object)new TableWrapData(256, 16));
        this.text.addModifyListener((ModifyListener)this);
        if (inherited != null) {
            this.inheritedButton = toolkit.createButton((Composite)this, "inherit", 32);
            this.inheritedButton.setLayoutData((Object)new TableWrapData(8, 16));
            this.inheritedButton.addSelectionListener((SelectionListener)this);
            this.inheritedButton.setSelection(inherited.booleanValue());
            this.setEditable(!this.inheritedButton.getSelection());
        } else {
            this.inheritedButton = null;
        }
        this.text.setText(defaultValue);
        if (this.isReadOnly) {
            this.setEditable(false);
            if (this.inheritedButton != null) {
                this.inheritedButton.setEnabled(false);
            }
        }
        this.selectionEventsEnabled = true;
        this.modifyEventsEnabled = true;
    }

    public void setLayoutData(Object layoutData) {
        super.setLayoutData(layoutData);
        int heightHint = -1;
        if (layoutData instanceof TableWrapData) {
            heightHint = ((TableWrapData)layoutData).heightHint;
        } else if (layoutData instanceof GridData) {
            heightHint = ((GridData)layoutData).heightHint;
        }
        if (heightHint != -1) {
            TableWrapData twd = new TableWrapData(256, 256);
            twd.heightHint = heightHint;
            this.text.setLayoutData((Object)twd);
        }
    }

    public void setInherited(boolean inherited) {
        if (this.inheritedButton != null) {
            this.selectionEventsEnabled = false;
            this.inheritedButton.setSelection(inherited);
            this.setEditable(!inherited && !this.isReadOnly);
            this.selectionEventsEnabled = true;
        }
    }

    public boolean isInherited() {
        if (this.inheritedButton == null) {
            return false;
        }
        return this.inheritedButton.getSelection();
    }

    public void setValue(String value) {
        this.modifyEventsEnabled = false;
        this.text.setText(value);
        this.modifyEventsEnabled = true;
    }

    public String getValue() {
        return this.text.getText();
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void selectionEvent() {
        if (!this.selectionEventsEnabled) {
            return;
        }
        for (SelectionListener listener : this.selectionListeners) {
            Event e = new Event();
            e.widget = this;
            listener.widgetSelected(new SelectionEvent(e));
        }
    }

    protected void modifyEvent() {
        if (!this.modifyEventsEnabled) {
            return;
        }
        for (ModifyListener listener : this.modifyListeners) {
            Event e = new Event();
            e.widget = this;
            listener.modifyText(new ModifyEvent(e));
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.text) {
            if (this.editor != null && this.modifyEventsEnabled) {
                this.editor.setDirty(true);
            }
            this.modifyEvent();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.setEditable(!this.inheritedButton.getSelection());
        if (this.editor != null && this.selectionEventsEnabled) {
            this.editor.setDirty(true);
        }
        this.selectionEvent();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.inheritedButton != null) {
            this.inheritedButton.setEnabled(enabled);
        }
        this.setEditable(enabled && (this.inheritedButton == null || !this.inheritedButton.getSelection()));
    }

    public void setInheritedTextValue(String value) {
        if (this.inheritedButton != null) {
            this.inheritedButton.setText(value);
        }
    }

    protected void setEditable(boolean isEditable) {
        if (isEditable) {
            this.text.setForeground(this.getDisplay().getSystemColor(21));
            this.text.setBackground(this.getDisplay().getSystemColor(1));
        }
        this.text.setEditable(isEditable);
        if (!isEditable) {
            this.text.setForeground(this.getDisplay().getSystemColor(16));
            this.text.setBackground(this.getDisplay().getSystemColor(19));
        }
    }
}

