/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.RepositoryEditor;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.UserAttributeWizard;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UserAttributesWidget
extends Composite
implements SelectionListener {
    protected Table tblAttributes = null;
    protected Button btnAddItem = null;
    protected Button btnDeleteItem = null;
    protected Button btnEditItem = null;
    protected RepositoryEditor editor;
    protected Map<String, String> userAttributes;
    protected boolean isReadonly;

    public UserAttributesWidget(Composite parent, int style, RepositoryEditor editor, Map<String, String> userAttributes, boolean readOnly, FormToolkit toolkit) {
        super(parent, 0);
        this.editor = editor;
        this.userAttributes = new HashMap<String, String>(userAttributes);
        this.editor = editor;
        this.isReadonly = readOnly;
        this.setLayout((Layout)new GridLayout(2, false));
        this.tblAttributes = toolkit.createTable((Composite)this, style | 4 | 0x10000 | 0x800);
        this.tblAttributes.setHeaderVisible(true);
        this.tblAttributes.setLinesVisible(true);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.tblAttributes.setLayout((Layout)columnLayout);
        TableColumn column1 = new TableColumn(this.tblAttributes, 0);
        column1.setText("key");
        TableColumn column2 = new TableColumn(this.tblAttributes, 0);
        column2.setText("value");
        columnLayout.setColumnData((Item)column1, new ColumnData(0.2f));
        columnLayout.setColumnData((Item)column2, new ColumnData(0.8f));
        GridData gd = new GridData(4, 1, true, false, 1, 3);
        gd.heightHint = 200;
        this.tblAttributes.setLayoutData((Object)gd);
        this.tblAttributes.addSelectionListener((SelectionListener)this);
        this.btnAddItem = toolkit.createButton((Composite)this, "Add", 8);
        this.btnAddItem.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnAddItem.addSelectionListener((SelectionListener)this);
        this.btnDeleteItem = toolkit.createButton((Composite)this, "Delete", 8);
        this.btnDeleteItem.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnDeleteItem.addSelectionListener((SelectionListener)this);
        this.btnEditItem = toolkit.createButton((Composite)this, "Edit", 8);
        this.btnEditItem.setLayoutData((Object)new GridData(4, 1, false, false));
        this.btnEditItem.addSelectionListener((SelectionListener)this);
        this.btnAddItem.setVisible(!this.isReadonly);
        this.btnEditItem.setVisible(!this.isReadonly);
        this.btnDeleteItem.setVisible(!this.isReadonly);
        this.showData(null);
    }

    public void setUserAttributes(Map<String, String> userAttributes) {
        this.userAttributes = new HashMap<String, String>(userAttributes);
        this.showData(null);
    }

    public Map<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    protected void showData(String attributeKey) {
        this.tblAttributes.removeAll();
        TableItem selectItem = null;
        for (String key : this.userAttributes.keySet()) {
            TableItem item = this.addConfigTableItem(key);
            if (!key.equals(attributeKey)) continue;
            selectItem = item;
        }
        if (selectItem != null) {
            this.tblAttributes.setSelection(selectItem);
        }
        this.updateButtons();
    }

    protected TableItem addConfigTableItem(String key) {
        TableItem item = new TableItem(this.tblAttributes, 0);
        item.setText(0, key);
        item.setText(1, this.userAttributes.get(key));
        item.setData("key", (Object)key);
        item.setData("value", (Object)this.userAttributes.get(key));
        return item;
    }

    protected void updateButtons() {
        if (!this.isEnabled()) {
            this.btnAddItem.setEnabled(false);
            this.btnDeleteItem.setEnabled(false);
            this.btnEditItem.setEnabled(false);
        } else {
            this.btnAddItem.setEnabled(true);
            int index = this.tblAttributes.getSelectionIndex();
            this.btnDeleteItem.setEnabled(index >= 0);
            this.btnEditItem.setEnabled(index >= 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.tblAttributes && !this.isReadonly) {
            this.editAttributeItem();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.tblAttributes) {
            this.updateButtons();
        } else if (e.widget == this.btnAddItem) {
            this.addAttributeItem();
        } else if (e.widget == this.btnDeleteItem) {
            this.deleteAttributeItem();
        } else if (e.widget == this.btnEditItem) {
            this.editAttributeItem();
        }
    }

    protected void addAttributeItem() {
        UserAttributeWizard wizard = new UserAttributeWizard();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        if (this.userAttributes.containsKey(wizard.getKey())) {
            MessageBox box = new MessageBox(this.getShell());
            box.setMessage("The key already exists");
            box.setText("The entry can't be added");
            box.open();
            return;
        }
        this.userAttributes.put(wizard.getKey(), wizard.getValue());
        this.showData(wizard.getKey());
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void deleteAttributeItem() {
        String selKey = (String)this.tblAttributes.getSelection()[0].getData("key");
        this.userAttributes.remove(selKey);
        this.showData(null);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    protected void editAttributeItem() {
        String selKey = (String)this.tblAttributes.getSelection()[0].getData("key");
        String selValue = (String)this.tblAttributes.getSelection()[0].getData("value");
        UserAttributeWizard wizard = new UserAttributeWizard(selKey, selValue);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        if (dialog.open() != 0) {
            return;
        }
        this.userAttributes.put(selKey, wizard.getValue());
        this.showData(selKey);
        if (this.editor != null) {
            this.editor.setDirty(true);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
    }
}

