/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle;

import de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle.BundleFormat;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLExport;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.FileTools;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BundleExport {
    public static void exportBundleRevision(SessionToken session, ActivityRepository ar, String ecName, long revision, File targetFile, IProgressMonitor monitor) throws IOException {
        BundleExport.exportBundle(session, new RevisionAdapter(session, ar, revision), ecName, targetFile, monitor);
    }

    public static void exportBundleBranch(SessionToken session, ActivityRepository ar, String ecName, long branch, File targetFile, IProgressMonitor monitor) throws IOException {
        BundleExport.exportBundle(session, new BranchAdapter(session, ar, branch), ecName, targetFile, monitor);
    }

    private static void exportBundle(SessionToken session, ARAdapter arAdapter, String ecName, File targetFile, IProgressMonitor monitor) throws IOException {
        IProgressMonitor monitorToUse = monitor == null ? new NullProgressMonitor() : monitor;
        ActivityModelXMLExport amExport = new ActivityModelXMLExport();
        ZipOutputStream zipOut = null;
        boolean successful = false;
        try {
            zipOut = new ZipOutputStream(new FileOutputStream(targetFile));
            HashSet<String> confSetNames = new HashSet<String>();
            HashSet<UUID> identifiers = new HashSet<UUID>();
            HashSet resources = new HashSet();
            HashSet<UUID> icons = new HashSet<UUID>();
            ZipEntry entry = new ZipEntry("version");
            zipOut.putNextEntry(entry);
            new DataOutputStream(zipOut).writeShort(2);
            StorageExecutableComponentDescription ecd = arAdapter.getECD(ecName);
            if (ecd.getState() == State.OUTDATED) {
                String msg = "The ECD '%s' cannot be exported because it is outdated.";
                msg = String.format(msg, ecName);
                throw new IllegalArgumentException(msg);
            }
            BundleExport.gatherIdentifierIDsFromParameterTemplates(identifiers, ecd.getParameterTemplates());
            if (ecd.getIconID() != null) {
                icons.add(ecd.getIconID());
            }
            entry = new ZipEntry(BundleFormat.getECDEntryName(ecName));
            zipOut.putNextEntry(entry);
            amExport.executableComponentDescriptionToStream(ecd, (OutputStream)zipOut);
            Collection<OperationReference> opRefs = arAdapter.getOps(ecName);
            for (OperationReference opRef : opRefs) {
                if (opRef.getState() == State.OUTDATED) continue;
                String opName = opRef.getName();
                StorageOperation op = arAdapter.getOp(ecName, opName);
                ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
                int n = accessTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityConstants.AccessType accessType = accessTypeArray[n2];
                    BundleExport.gatherIdentifierIDsFromParameters(identifiers, op.getParameters(accessType));
                    ++n2;
                }
                BundleExport.gatherIdentifierIDsFromParameterTemplates(identifiers, op.getParameterTemplates());
                if (op.getIconID() != null) {
                    icons.add(op.getIconID());
                }
                entry = new ZipEntry(BundleFormat.getOpEntryName(ecName, opName));
                zipOut.putNextEntry(entry);
                amExport.operationToStream(op, (OutputStream)zipOut);
                Collection<ATDReference> atdRefs = arAdapter.getATDs(ecName, opName);
                for (ATDReference atdRef : atdRefs) {
                    if (atdRef.getState() == State.OUTDATED) continue;
                    if (atdRef.getConfigurationSetName() != null) {
                        StorageConfigurationSet cs = arAdapter.getCS(atdRef.getConfigurationSetName());
                        if (cs.getState() == State.OUTDATED) continue;
                        confSetNames.add(atdRef.getConfigurationSetName());
                    }
                    String atdName = atdRef.getName();
                    StorageActivityTemplateDefinition atd = arAdapter.getATD(ecName, opName, atdName);
                    ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.activityRelatedValues();
                    int n3 = accessTypeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ActivityConstants.AccessType accessType = accessTypeArray2[n4];
                        BundleExport.gatherIdentifierIDsFromParameters(identifiers, atd.getParameters(accessType));
                        ++n4;
                    }
                    BundleExport.gatherIdentifierIDsFromParameterTemplates(identifiers, atd.getParameterTemplates());
                    if (atd.getIconID() != null) {
                        icons.add(atd.getIconID());
                    }
                    entry = new ZipEntry(BundleFormat.getATDEntryName(ecName, opName, atdName));
                    zipOut.putNextEntry(entry);
                    amExport.activityTemplateDefinitionToStream(atd, (OutputStream)zipOut);
                }
            }
            for (String csName : confSetNames) {
                StorageConfigurationSet cs = arAdapter.getCS(csName);
                BundleExport.gatherIdentifierIDsFromParameterTemplates(identifiers, cs.getParameterTemplates());
                Map allOpNames = cs.getOperationNames();
                for (String csEcdName : allOpNames.keySet()) {
                    BundleExport.gatherIdentifierIDsFromParameterTemplates(identifiers, cs.getParameterTemplates(csEcdName));
                    for (String csOpName : (Collection)allOpNames.get(csEcdName)) {
                        BundleExport.gatherIdentifierIDsFromParameterTemplates(identifiers, cs.getParameterTemplates(csEcdName, csOpName));
                    }
                }
                entry = new ZipEntry(BundleFormat.getCSEntryName(csName));
                zipOut.putNextEntry(entry);
                amExport.configurationSetToStream(cs, (OutputStream)zipOut);
            }
            for (UUID identfierID : identifiers) {
                if (identfierID.equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) continue;
                Identifier id = arAdapter.getIdentifier(identfierID);
                entry = new ZipEntry(BundleFormat.getIdentifierEntryName(identfierID));
                zipOut.putNextEntry(entry);
                amExport.identifierToStream(id, (OutputStream)zipOut);
            }
            for (UUID resourceID : resources) {
                ResourceDescriptor res = arAdapter.getResource(resourceID);
                entry = new ZipEntry(BundleFormat.getResEntryName(resourceID));
                zipOut.putNextEntry(entry);
                amExport.resourceDescriptorToStream(res, (OutputStream)zipOut);
                byte[] resData = arAdapter.getResourceData(resourceID);
                entry = new ZipEntry(BundleFormat.getResDataEntryName(resourceID));
                zipOut.putNextEntry(entry);
                zipOut.write(resData);
            }
            for (UUID iconID : icons) {
                IconDescriptor icon = arAdapter.getIcon(iconID);
                entry = new ZipEntry(BundleFormat.getIconEntryName(iconID));
                zipOut.putNextEntry(entry);
                amExport.iconDescriptorToStream(icon, (OutputStream)zipOut);
                IconDescriptor.Dimension[] dimensionArray = icon.getDimensions();
                int n = dimensionArray.length;
                int n5 = 0;
                while (n5 < n) {
                    IconDescriptor.Dimension dim = dimensionArray[n5];
                    byte[] iconData = arAdapter.getIconData(iconID, dim);
                    entry = new ZipEntry(BundleFormat.getIconDataEntryName(iconID, dim));
                    zipOut.putNextEntry(entry);
                    zipOut.write(iconData);
                    ++n5;
                }
            }
            zipOut.finish();
            zipOut.flush();
            zipOut = (ZipOutputStream)FileTools.close((Closeable)zipOut);
            successful = true;
        }
        catch (Throwable throwable) {
            if (!successful) {
                FileTools.closeQuietly(zipOut);
                targetFile.delete();
            }
            monitorToUse.done();
            throw throwable;
        }
        if (!successful) {
            FileTools.closeQuietly((Closeable)zipOut);
            targetFile.delete();
        }
        monitorToUse.done();
    }

    private static void gatherIdentifierIDsFromParameters(Set<UUID> identifierIDs, Map<String, StorageActivityModelParameter> params) {
        for (StorageActivityModelParameter param : params.values()) {
            if (param == null || param.isIdentifierIDInherited()) continue;
            identifierIDs.add(param.getIdentifierID());
        }
    }

    private static void gatherIdentifierIDsFromParameterTemplates(Set<UUID> identifierIDs, Map<String, StorageParameterTemplate> templates) {
        for (StorageParameterTemplate param : templates.values()) {
            if (param == null || param.isIdentifierIDInherited()) continue;
            identifierIDs.add(param.getIdentifierID());
        }
    }

    private static abstract class ARAdapter {
        protected SessionToken session;
        protected ActivityRepository ar;

        private ARAdapter(SessionToken session, ActivityRepository ar) {
            ArgChecks.checkForNull((Object)session, (String)"session");
            ArgChecks.checkForNull((Object)ar, (String)"ar");
            this.session = session;
            this.ar = ar;
        }

        abstract StorageExecutableComponentDescription getECD(String var1);

        abstract Collection<OperationReference> getOps(String var1);

        abstract StorageOperation getOp(String var1, String var2);

        abstract Collection<ATDReference> getATDs(String var1, String var2);

        abstract StorageActivityTemplateDefinition getATD(String var1, String var2, String var3);

        abstract StorageConfigurationSet getCS(String var1);

        abstract Identifier getIdentifier(UUID var1);

        abstract ResourceDescriptor getResource(UUID var1);

        abstract byte[] getResourceData(UUID var1);

        abstract IconDescriptor getIcon(UUID var1);

        abstract byte[] getIconData(UUID var1, IconDescriptor.Dimension var2);
    }

    private static class BranchAdapter
    extends ARAdapter {
        private long branch;

        private BranchAdapter(SessionToken session, ActivityRepository ar, long branch) {
            super(session, ar);
            this.branch = branch;
        }

        @Override
        public StorageExecutableComponentDescription getECD(String ecName) {
            return this.ar.getECDManager().getDevelopmentECD(this.session, ecName, this.branch).getStorageECD();
        }

        @Override
        public Collection<OperationReference> getOps(String ecName) {
            return this.ar.getOperationManager().getDevelopmentOperationReferencesOfECD(this.session, ecName, this.branch);
        }

        @Override
        public StorageOperation getOp(String ecName, String opName) {
            return this.ar.getOperationManager().getDevelopmentOperation(this.session, ecName, opName, this.branch).getStorageOperation();
        }

        @Override
        Collection<ATDReference> getATDs(String ecName, String opName) {
            return this.ar.getATDManager().getDevelopmentATDReferencesOfOperation(this.session, ecName, opName, this.branch);
        }

        @Override
        StorageActivityTemplateDefinition getATD(String ecName, String opName, String atdName) {
            return this.ar.getATDManager().getDevelopmentATD(this.session, ecName, opName, atdName, this.branch).getStorageATD();
        }

        @Override
        StorageConfigurationSet getCS(String csName) {
            return this.ar.getCSManager().getDevelopmentCS(this.session, csName, this.branch).getStorageCS();
        }

        @Override
        Identifier getIdentifier(UUID id) {
            return this.ar.getIdentifierManager().getDevelopmentIdentifier(this.session, id, this.branch);
        }

        @Override
        ResourceDescriptor getResource(UUID id) {
            return this.ar.getResourceManager().getDevelopmentResourceDescriptor(this.session, id, this.branch);
        }

        @Override
        byte[] getResourceData(UUID id) {
            return this.ar.getResourceManager().getDevelopmentResource(this.session, id, this.branch);
        }

        @Override
        IconDescriptor getIcon(UUID id) {
            return this.ar.getIconManager().getDevelopmentIconDescriptor(this.session, id, this.branch);
        }

        @Override
        byte[] getIconData(UUID id, IconDescriptor.Dimension dimension) {
            return this.ar.getIconManager().getDevelopmentIcon(this.session, id, dimension, this.branch);
        }
    }

    private static class RevisionAdapter
    extends ARAdapter {
        private long revision;

        private RevisionAdapter(SessionToken session, ActivityRepository ar, long revision) {
            super(session, ar);
            this.revision = revision;
        }

        @Override
        public StorageExecutableComponentDescription getECD(String ecName) {
            return this.ar.getECDManager().getECDRevision(this.session, ecName, this.revision).getStorageECD();
        }

        @Override
        public Collection<OperationReference> getOps(String ecName) {
            return this.ar.getOperationManager().getOperationReferencesRevisionOfECD(this.session, ecName, this.revision);
        }

        @Override
        public StorageOperation getOp(String ecName, String opName) {
            return this.ar.getOperationManager().getOperationRevision(this.session, ecName, opName, this.revision).getStorageOperation();
        }

        @Override
        Collection<ATDReference> getATDs(String ecName, String opName) {
            return this.ar.getATDManager().getATDReferencesRevisionOfOperation(this.session, ecName, opName, this.revision);
        }

        @Override
        StorageActivityTemplateDefinition getATD(String ecName, String opName, String atdName) {
            return this.ar.getATDManager().getATDRevision(this.session, ecName, opName, atdName, this.revision).getStorageATD();
        }

        @Override
        StorageConfigurationSet getCS(String csName) {
            return this.ar.getCSManager().getCSRevision(this.session, csName, this.revision).getStorageCS();
        }

        @Override
        Identifier getIdentifier(UUID id) {
            return this.ar.getIdentifierManager().getIdentifierRevision(this.session, id, this.revision);
        }

        @Override
        ResourceDescriptor getResource(UUID id) {
            return this.ar.getResourceManager().getResourceDescriptorRevision(this.session, id, this.revision);
        }

        @Override
        byte[] getResourceData(UUID id) {
            return this.ar.getResourceManager().getResourceRevision(this.session, id, this.revision);
        }

        @Override
        IconDescriptor getIcon(UUID id) {
            return this.ar.getIconManager().getIconDescriptorRevision(this.session, id, this.revision);
        }

        @Override
        byte[] getIconData(UUID id, IconDescriptor.Dimension dimension) {
            return this.ar.getIconManager().getIconRevision(this.session, id, dimension, this.revision);
        }
    }
}

