/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle;

import de.aristaflow.adept2.model.common.IconDescriptor;
import java.util.UUID;

public final class BundleFormat {
    public static final String ECB_FILEEXT = "acb";
    public static final String ECB_LONGNAME = "AristaFlow Executable Component Bundle";
    public static final String ECB_NAME = "AristaFlow EC Bundle";
    public static final String ECB_SHORTNAME = "EC Bundle";
    static final String ECB_VERSION_ENTRY = "version";

    static String getOpEntryPrefix(String ecName) {
        return String.valueOf(ECBEntity.OP.prefix()) + ecName + "/";
    }

    static String getATDEntryPrefix(String ecName, String opName) {
        return String.valueOf(ECBEntity.ATD.prefix()) + ecName + "/" + opName + "/";
    }

    static String getECDEntryName(String ecName) {
        return String.valueOf(ECBEntity.ECD.prefix()) + ecName;
    }

    static String getOpEntryName(String ecName, String opName) {
        return String.valueOf(BundleFormat.getOpEntryPrefix(ecName)) + opName;
    }

    static String getCSEntryName(String csName) {
        return String.valueOf(ECBEntity.CS.prefix()) + csName;
    }

    static String getATDEntryName(String ecName, String opName, String atdName) {
        return String.valueOf(BundleFormat.getATDEntryPrefix(ecName, opName)) + atdName;
    }

    static String getIdentifierEntryName(UUID identifierID) {
        return String.valueOf(ECBEntity.ID.prefix()) + identifierID.toString();
    }

    static String getResEntryName(UUID id) {
        return String.valueOf(ECBEntity.RES.prefix()) + id.toString();
    }

    static String getResDataEntryName(UUID id) {
        return String.valueOf(ECBEntity.RES.prefix()) + id.toString() + "$data";
    }

    static String getIconEntryName(UUID id) {
        return String.valueOf(ECBEntity.ICO.prefix()) + id.toString();
    }

    static String getIconDataEntryName(UUID id, IconDescriptor.Dimension dim) {
        return String.valueOf(ECBEntity.ICO.prefix()) + id.toString() + "$" + dim.width + "," + dim.height + "$data";
    }

    private BundleFormat() {
    }

    public static enum ECBEntity {
        ECD("ecd/"),
        OP("op/"),
        ATD("atd/"),
        CS("cs/"),
        ID("id/"),
        RES("res/"),
        ICO("ico/");

        private final String prefix;

        private ECBEntity(String prefix) {
            this.prefix = prefix;
        }

        public String prefix() {
            return this.prefix;
        }
    }
}

