/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle;

import de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle.BundleFormat;
import de.aristaflow.adept2.app.activityrepositoryeditor.tools.bundle.BundleFormatException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.activityrepository.ActivityTemplateDefinitionManager;
import de.aristaflow.adept2.core.activityrepository.ConfigurationSetManager;
import de.aristaflow.adept2.core.activityrepository.ExecutableComponentDescriptionManager;
import de.aristaflow.adept2.core.activityrepository.IconManager;
import de.aristaflow.adept2.core.activityrepository.IdentifierManager;
import de.aristaflow.adept2.core.activityrepository.OperationManager;
import de.aristaflow.adept2.core.activityrepository.ResourceManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ChangeableIconDescriptor;
import de.aristaflow.adept2.model.activitymodel.ChangeableResourceDescriptor;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLImport;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.model.globals.SystemIdentifier;
import de.aristaflow.adept2.util.UnknownEntityException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BundleImport {
    public static void importBundle(SessionToken session, ActivityRepository ar, ActivityModelFactory amf, File sourceFile, long targetBranch, IProgressMonitor monitor) throws BundleFormatException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ActivityModelXMLImport amImport = new ActivityModelXMLImport(amf);
        ExecutableComponentDescriptionManager ecdMan = ar.getECDManager();
        OperationManager opMan = ar.getOperationManager();
        ConfigurationSetManager csMan = ar.getCSManager();
        ActivityTemplateDefinitionManager atdMan = ar.getATDManager();
        IdentifierManager idMan = ar.getIdentifierManager();
        ResourceManager resMan = ar.getResourceManager();
        IconManager iconMan = ar.getIconManager();
        ZipFile bundle = null;
        boolean success = false;
        try {
            try {
                ZipEntry entry;
                bundle = new ZipFile(sourceFile);
                int detectedVersion = 2;
                ZipEntry versionEntry = bundle.getEntry("version");
                if (versionEntry != null) {
                    detectedVersion = new DataInputStream(bundle.getInputStream(versionEntry)).readShort();
                }
                if (detectedVersion != 2) {
                    String msg = "The expected %s format version was 2, the detected version was %d.";
                    msg = String.format(msg, "AristaFlow EC Bundle", detectedVersion);
                    throw new BundleFormatException(msg);
                }
                int entityCount = 0;
                Enumeration<? extends ZipEntry> enu = bundle.entries();
                block11: while (enu.hasMoreElements()) {
                    ZipEntry entry2 = enu.nextElement();
                    BundleFormat.ECBEntity[] eCBEntityArray = BundleFormat.ECBEntity.values();
                    int n = eCBEntityArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BundleFormat.ECBEntity entity = eCBEntityArray[n2];
                        if (entry2.getName().startsWith(entity.prefix())) {
                            ++entityCount;
                            continue block11;
                        }
                        ++n2;
                    }
                }
                String taskName = String.format("Importing %s from '%s'...", "AristaFlow EC Bundle", sourceFile.getAbsolutePath());
                monitor.beginTask(taskName, entityCount);
                Enumeration<? extends ZipEntry> enu2 = bundle.entries();
                while (enu2.hasMoreElements()) {
                    entry = enu2.nextElement();
                    if (entry.isDirectory()) continue;
                    if (entry.getName().startsWith(BundleFormat.ECBEntity.ECD.prefix())) {
                        monitor.subTask(String.format("importing ECD entry %s", entry.getName()));
                        InputStream in = bundle.getInputStream(entry);
                        StorageExecutableComponentDescription ecd = amImport.executableComponentDescriptionFromStream(in);
                        ecdMan.storeDevelopmentECD(session, ecd, targetBranch);
                        monitor.worked(1);
                        continue;
                    }
                    if (entry.getName().startsWith(BundleFormat.ECBEntity.ID.prefix())) {
                        monitor.subTask(String.format("importing Identifier entry %s", entry.getName()));
                        InputStream in = bundle.getInputStream(entry);
                        Identifier identifier = amImport.getIdentifier(in);
                        if (!SystemIdentifier.isSystemIdentifier((UUID)identifier.getID())) {
                            idMan.storeDevelopmentIdentifier(session, identifier, targetBranch);
                        }
                        monitor.worked(1);
                        continue;
                    }
                    if (entry.getName().startsWith(BundleFormat.ECBEntity.RES.prefix())) {
                        monitor.subTask(String.format("importing Resource entry %s", entry.getName()));
                        InputStream in = bundle.getInputStream(entry);
                        ChangeableResourceDescriptor resourceDescriptor = amImport.getResourceDescriptor(in);
                        resMan.storeDevelopmentResourceDescriptor(session, (ResourceDescriptor)resourceDescriptor, null, targetBranch);
                        monitor.worked(1);
                        continue;
                    }
                    if (!entry.getName().startsWith(BundleFormat.ECBEntity.ICO.prefix())) continue;
                    monitor.subTask(String.format("importing Icon entry %s", entry.getName()));
                    InputStream in = bundle.getInputStream(entry);
                    ChangeableIconDescriptor iconDescriptor = amImport.getIconDescriptor(in);
                    iconMan.storeDevelopmentIconDescriptor(session, (IconDescriptor)iconDescriptor, targetBranch);
                    monitor.worked(1);
                }
                enu2 = bundle.entries();
                while (enu2.hasMoreElements()) {
                    entry = enu2.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(BundleFormat.ECBEntity.OP.prefix())) continue;
                    monitor.subTask(String.format("importing Operation entry %s", entry.getName()));
                    InputStream in = bundle.getInputStream(entry);
                    StorageOperation op = amImport.getOperation(in);
                    opMan.storeDevelopmentOperation(session, op, targetBranch);
                    monitor.worked(1);
                }
                enu2 = bundle.entries();
                while (enu2.hasMoreElements()) {
                    entry = enu2.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(BundleFormat.ECBEntity.CS.prefix())) continue;
                    monitor.subTask(String.format("importing Configuration Set entry %s", entry.getName()));
                    InputStream in = bundle.getInputStream(entry);
                    StorageConfigurationSet cs = amImport.getConfigurationSet(in);
                    csMan.storeDevelopmentCS(session, cs, targetBranch);
                    monitor.worked(1);
                }
                enu2 = bundle.entries();
                while (enu2.hasMoreElements()) {
                    entry = enu2.nextElement();
                    if (entry.isDirectory() || !entry.getName().startsWith(BundleFormat.ECBEntity.ATD.prefix())) continue;
                    monitor.subTask(String.format("importing ATD entry %s", entry.getName()));
                    InputStream in = bundle.getInputStream(entry);
                    StorageActivityTemplateDefinition atd = amImport.getActivityTemplateDefinition(in);
                    try {
                        atdMan.getATDReference(session, atd.getID());
                    }
                    catch (UnknownEntityException unknownEntityException) {
                        atdMan.importDevelopmentATD(session, atd, targetBranch);
                    }
                    monitor.worked(1);
                }
                bundle.close();
                success = true;
            }
            catch (ZipException ex) {
                throw new BundleFormatException(ex);
            }
            catch (XMLFormatException ex) {
                throw new BundleFormatException(ex);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bundle != null) {
                    bundle.close();
                }
            }
            catch (IOException iOException) {}
            monitor.done();
            throw throwable;
        }
        try {
            if (bundle != null) {
                bundle.close();
            }
        }
        catch (IOException iOException) {}
        monitor.done();
    }
}

