/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationEntryWizard
extends Wizard {
    private ConfigurationDescription.ConfigurationEntry entry;
    private boolean isInherited;
    private boolean isNew;
    private GeneralPage generalPage;
    private ActivityModelFactory factory = null;
    List<String> namesInUse;

    public ConfigurationEntryWizard(List<String> namesInUse) {
        this.isNew = true;
        this.isInherited = false;
        this.entry = null;
        this.factory = Activator.getService().getActivityModelFactory();
        this.namesInUse = namesInUse;
    }

    public ConfigurationEntryWizard(ConfigurationDescription.ConfigurationEntry entry, boolean isInherited) {
        this.isNew = false;
        this.isInherited = isInherited;
        this.entry = entry;
        this.factory = Activator.getService().getActivityModelFactory();
        this.namesInUse = new ArrayList<String>();
    }

    public ConfigurationDescription.ConfigurationEntry getEntry() {
        return this.entry;
    }

    protected boolean validate() {
        if (this.namesInUse.contains(this.generalPage.getEntryName())) {
            this.generalPage.setErrorMessage("The choosen entry name is already in use.");
            return false;
        }
        char[] cArray = ActivityConstants.DISALLOWED_NAME_CHARACTERS;
        int n = ActivityConstants.DISALLOWED_NAME_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char disallowedChar = cArray[n2];
            if (this.generalPage.getEntryName().indexOf(disallowedChar) != -1) {
                this.generalPage.setErrorMessage(String.format("Character '%s' not allowed in name.", Character.valueOf(disallowedChar)));
                return false;
            }
            ++n2;
        }
        if (this.isInherited && !this.entry.isOptional() && this.generalPage.btnOptional.getSelection()) {
            this.generalPage.setErrorMessage("Entry is mandatory. It can't be optional anymore");
            return false;
        }
        this.generalPage.setErrorMessage(null);
        return true;
    }

    public void addPages() {
        this.generalPage = this.isNew ? new GeneralPage() : new GeneralPage(this.entry.getName(), this.entry.getDescription(), this.entry.getDataType(), this.entry.isOptional());
        this.addPage((IWizardPage)this.generalPage);
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        String title = "Configuration Entry wizard - ";
        title = this.isNew ? String.valueOf(title) + "new entry" : (this.isInherited ? String.valueOf(title) + "overwrite entry" : String.valueOf(title) + "edit entry");
        this.setWindowTitle(title);
    }

    public boolean canFinish() {
        return super.canFinish() && this.validate();
    }

    public boolean performFinish() {
        this.entry = this.factory.createConfigurationEntry(this.generalPage.getEntryName(), this.generalPage.getEntryDescription(), this.generalPage.getEntryDatatype(), this.generalPage.isEntryOptional(), new String[0], (PluginDataContainer)new DefaultPluginDataContainer(), new HashMap());
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        String entryName;
        String entryDescription;
        ProcessConstants.AdeptDataType entryDatatype;
        boolean isOptional;
        Text txtName;
        Text txtDescription;
        Table tblDatatype;
        Button btnOptional;

        protected GeneralPage() {
            this("new configuration entry", "", ProcessConstants.AdeptDataType.STRING, false);
        }

        protected GeneralPage(String name, String description, ProcessConstants.AdeptDataType datatype, boolean isOptional) {
            super("general");
            this.setTitle("General Information");
            this.setDescription("Enter the general information of the entry");
            this.entryName = name;
            this.entryDescription = description;
            this.entryDatatype = datatype;
            this.isOptional = isOptional;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String getEntryDescription() {
            return this.entryDescription;
        }

        public ProcessConstants.AdeptDataType getEntryDatatype() {
            return this.entryDatatype;
        }

        public boolean isEntryOptional() {
            return this.isOptional;
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtName = toolkit.createText(container, "", 4);
            this.txtName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtName.addModifyListener((ModifyListener)this);
            this.txtName.setEnabled(ConfigurationEntryWizard.this.isNew);
            label = toolkit.createLabel(container, "Description");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtDescription = toolkit.createText(container, "", 578);
            GridData gd = new GridData(4, 1, true, false);
            gd.heightHint = 60;
            this.txtDescription.setLayoutData((Object)gd);
            this.txtDescription.addModifyListener((ModifyListener)this);
            label = toolkit.createLabel(container, "Datatype");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.tblDatatype = toolkit.createTable(container, 65540);
            gd = new GridData(4, 1, true, false);
            gd.heightHint = 60;
            this.tblDatatype.setLayoutData((Object)gd);
            this.tblDatatype.addSelectionListener((SelectionListener)this);
            ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
            int n = adeptDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessConstants.AdeptDataType datatype = adeptDataTypeArray[n2];
                TableItem item = new TableItem(this.tblDatatype, 0);
                item.setText(datatype.name());
                item.setData("datatype", (Object)datatype);
                ++n2;
            }
            this.tblDatatype.setSelection(0);
            this.tblDatatype.setEnabled(!ConfigurationEntryWizard.this.isInherited);
            label = toolkit.createLabel(container, "");
            label.setLayoutData((Object)new GridData());
            label.setVisible(false);
            this.btnOptional = toolkit.createButton(container, "is optional", 32);
            this.btnOptional.setLayoutData((Object)new GridData(1, 1, false, false));
            this.btnOptional.setSelection(this.isOptional);
            this.btnOptional.addSelectionListener((SelectionListener)this);
            this.btnOptional.setEnabled(!ConfigurationEntryWizard.this.isInherited || this.isOptional);
            toolkit.paintBordersFor(container);
            this.showData();
            this.setControl((Control)container);
            if (this.txtName.isEnabled()) {
                this.txtName.selectAll();
            }
        }

        protected void showData() {
            this.txtName.setText(this.entryName);
            this.txtDescription.setText(this.entryDescription);
            this.tblDatatype.setSelection(this.entryDatatype.ordinal());
            this.btnOptional.setSelection(this.isOptional);
            this.updateButtons();
        }

        protected void updateButtons() {
            this.getWizard().getContainer().updateButtons();
        }

        protected boolean checkValid() {
            return !this.entryName.equals("");
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.txtName) {
                this.entryName = this.txtName.getText();
            } else if (e.widget == this.txtDescription) {
                this.entryDescription = this.txtDescription.getText();
            }
            this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.tblDatatype) {
                this.entryDatatype = (ProcessConstants.AdeptDataType)this.tblDatatype.getSelection()[0].getData("datatype");
            }
            if (e.widget == this.btnOptional) {
                this.isOptional = this.btnOptional.getSelection();
            }
            this.updateButtons();
        }
    }
}

