/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.AdeptValueWidget;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.util.HashSet;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConfigurationValueWizard
extends Wizard {
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedConfiguration configuration;
    protected String configurationEntryName;
    protected ValueType valueType;
    protected String inputParameterName;
    protected String processConfigName;
    protected boolean isSetFixed;
    protected GeneralPage generalPage;
    protected final boolean isNew;
    protected final boolean isActivityConfigAllowed;
    protected boolean isFixedAllowed;

    public ConfigurationValueWizard(InheritedConfiguration configuration, InheritedConfigurationDescription configurationDescription, boolean isFixedAllowed) throws IllegalArgumentException {
        this.configuration = configuration;
        this.configurationDescription = configurationDescription;
        this.configurationEntryName = "";
        this.valueType = ValueType.DIRECT_VALUE;
        this.inputParameterName = "";
        this.processConfigName = "";
        this.isSetFixed = false;
        this.generalPage = null;
        this.isNew = true;
        this.isActivityConfigAllowed = configuration instanceof InheritedActivityConfiguration;
        this.isFixedAllowed = isFixedAllowed;
        HashSet possibleEntries = new HashSet(configurationDescription.getEntries().keySet());
        possibleEntries.removeAll(configuration.getAllEntries());
        if (possibleEntries.size() == 0) {
            throw new IllegalArgumentException("No Configuration Description Entries left for adding a configuration value!");
        }
    }

    public ConfigurationValueWizard(String configurationEntry, InheritedConfiguration configuration, InheritedConfigurationDescription configurationDescription, boolean isFixedAllowed) {
        this.configuration = configuration;
        this.configurationDescription = configurationDescription;
        this.configurationEntryName = configurationEntry;
        this.inputParameterName = "";
        this.processConfigName = "";
        if (this.isFromInputParameter(configurationEntry)) {
            this.inputParameterName = ((InheritedActivityConfiguration)configuration).fromInputParameter(configurationEntry);
            this.processConfigName = "";
            this.valueType = ValueType.FROM_INPUT_PARAMETER;
        } else if (this.isFromProcessConfiguration(configurationEntry)) {
            this.inputParameterName = "";
            this.processConfigName = ((InheritedActivityConfiguration)configuration).fromProcessConfiguration(configurationEntry);
            this.valueType = ValueType.FROM_PROCESS_CONFIG;
        } else {
            this.valueType = ValueType.DIRECT_VALUE;
        }
        this.isSetFixed = this.isFixedForChildren(this.configurationEntryName);
        this.generalPage = null;
        this.isNew = false;
        this.isActivityConfigAllowed = configuration instanceof InheritedActivityConfiguration;
        this.isFixedAllowed = isFixedAllowed;
    }

    public InheritedConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getEntryName() {
        return this.configurationEntryName;
    }

    public void addPages() {
        this.generalPage = new GeneralPage();
        this.addPage((IWizardPage)this.generalPage);
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        String title = "Configuration Value wizard - ";
        title = this.isNew ? String.valueOf(title) + "new value" : (this.isInherited(this.configurationEntryName) ? String.valueOf(title) + "overwrite entry" : String.valueOf(title) + "edit entry");
        this.setWindowTitle(title);
    }

    public boolean canFinish() {
        if (this.generalPage.optionDirectValue.getSelection()) {
            return super.canFinish() && (this.configurationDescription.getEntry(this.getEntryName()).getDataType() != ProcessConstants.AdeptDataType.STRING || !this.generalPage.valueWidget.getStringValue().equals(""));
        }
        if (this.generalPage.optionInputParameter.getSelection()) {
            return super.canFinish() && !this.generalPage.txtInputParameter.getText().equals("");
        }
        if (this.generalPage.optionProcessConfig.getSelection()) {
            return super.canFinish() && !this.generalPage.txtProcessConfig.getText().equals("");
        }
        return false;
    }

    public boolean performFinish() {
        if (this.isSetFixed && this.isFixedAllowed) {
            this.configuration.setFixedForChildren(this.configurationEntryName);
        } else {
            this.configuration.removeFixedForChildren(this.configurationEntryName);
        }
        if (this.valueType == ValueType.DIRECT_VALUE) {
            AdeptValueWidget value = this.generalPage.valueWidget;
            switch (this.getDatatype(this.configurationEntryName)) {
                case BOOLEAN: {
                    this.configuration.setBoolean(this.configurationEntryName, value.getBoolVaue().booleanValue());
                    break;
                }
                case DATE: {
                    this.configuration.setDate(this.configurationEntryName, value.getDateValue());
                    break;
                }
                case FLOAT: {
                    this.configuration.setFloat(this.configurationEntryName, (double)value.getFloatValue().floatValue());
                    break;
                }
                case INTEGER: {
                    this.configuration.setInteger(this.configurationEntryName, (long)value.getIntValue().intValue());
                    break;
                }
                case STRING: {
                    this.configuration.setString(this.configurationEntryName, value.getStringValue());
                    break;
                }
                case URI: {
                    this.configuration.setURI(this.configurationEntryName, value.getURIValue());
                    break;
                }
                case USERDEFINED: {
                    this.configuration.setUDT(this.configurationEntryName, value.getUDTValue());
                }
            }
        } else if (this.valueType == ValueType.FROM_INPUT_PARAMETER) {
            ((InheritedActivityConfiguration)this.configuration).setFromInputParameter(this.configurationEntryName, this.inputParameterName);
        } else if (this.valueType == ValueType.FROM_PROCESS_CONFIG) {
            ((InheritedActivityConfiguration)this.configuration).setFromProcessConfiguration(this.configurationEntryName, this.processConfigName);
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected boolean isFixed(String configurationEntry) {
        return this.configuration.isFixed(configurationEntry) && this.isFixedAllowed;
    }

    protected boolean isFixedForChildren(String configurationEntry) {
        return this.configuration.isFixedForChildren(configurationEntry);
    }

    protected boolean isInherited(String configurationEntry) {
        return this.configuration.isInherited(configurationEntry);
    }

    protected boolean isFromInputParameter(String configurationEntry) {
        if (this.configuration instanceof InheritedActivityConfiguration) {
            return ((InheritedActivityConfiguration)this.configuration).fromInputParameter(configurationEntry) != null;
        }
        return false;
    }

    protected boolean isFromProcessConfiguration(String configurationEntry) {
        if (this.configuration instanceof InheritedActivityConfiguration) {
            return ((InheritedActivityConfiguration)this.configuration).fromProcessConfiguration(configurationEntry) != null;
        }
        return false;
    }

    protected ProcessConstants.AdeptDataType getDatatype(String configurationEntry) {
        return this.configurationDescription.getEntry(configurationEntry).getDataType();
    }

    private class GeneralPage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        Table tblEntryTable;
        Button btnFixed;
        AdeptValueWidget valueWidget;
        Button optionDirectValue;
        Button optionProcessConfig;
        Button optionInputParameter;
        Text txtProcessConfig;
        Text txtInputParameter;

        public GeneralPage() {
            super("general");
            this.setTitle("General Information");
            this.setDescription("Enter the general information for the configuration.");
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "possible entries");
            label.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.tblEntryTable = toolkit.createTable(container, 65540);
            GridData gd = new GridData(4, 1, true, false, 2, 1);
            gd.heightHint = 60;
            this.tblEntryTable.setLayoutData((Object)gd);
            this.tblEntryTable.addSelectionListener((SelectionListener)this);
            if (!ConfigurationValueWizard.this.isNew) {
                ConfigurationDescription.ConfigurationEntry entry = ConfigurationValueWizard.this.configurationDescription.getEntry(ConfigurationValueWizard.this.configurationEntryName);
                TableItem item = new TableItem(this.tblEntryTable, 0);
                item.setText(String.valueOf(ConfigurationValueWizard.this.configurationEntryName) + " : " + entry.getDataType().toString());
                item.setData("entry", (Object)entry);
                this.tblEntryTable.setEnabled(false);
            } else {
                HashSet possibleEntries = new HashSet(ConfigurationValueWizard.this.configurationDescription.getEntries().keySet());
                possibleEntries.removeAll(ConfigurationValueWizard.this.configuration.getAllEntries());
                for (String entryName : possibleEntries) {
                    ConfigurationDescription.ConfigurationEntry entry = ConfigurationValueWizard.this.configurationDescription.getEntry(entryName);
                    if (ConfigurationValueWizard.this.isFixed(entryName) || entry == null) continue;
                    TableItem item = new TableItem(this.tblEntryTable, 0);
                    item.setText(String.valueOf(entryName) + " : " + entry.getDataType().toString());
                    item.setData("entry", (Object)entry);
                }
                if (this.tblEntryTable.getItemCount() > 0) {
                    ConfigurationValueWizard.this.configurationEntryName = ((ConfigurationDescription.ConfigurationEntry)this.tblEntryTable.getItem(0).getData("entry")).getName();
                }
            }
            this.btnFixed = toolkit.createButton(container, "is fixed for children", 32);
            this.btnFixed.setEnabled(ConfigurationValueWizard.this.isFixedAllowed);
            this.btnFixed.setLayoutData((Object)new GridData(1, 1, false, false));
            this.btnFixed.addSelectionListener((SelectionListener)this);
            this.optionDirectValue = toolkit.createButton(container, "enter direct value", 16);
            this.optionDirectValue.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.optionDirectValue.addSelectionListener((SelectionListener)this);
            label = toolkit.createLabel(container, "Value");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.valueWidget = new AdeptValueWidget(container, 0, ConfigurationValueWizard.this.getDatatype(ConfigurationValueWizard.this.configurationEntryName), null, false, null, toolkit);
            this.valueWidget.setLayoutData(new GridData(4, 1, false, false));
            this.valueWidget.setBoolValue(ConfigurationValueWizard.this.configuration.getBoolean(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.setDateValue(ConfigurationValueWizard.this.configuration.getDate(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.setFloatValue(ConfigurationValueWizard.this.configuration.getFloat(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.setIntValue(ConfigurationValueWizard.this.configuration.getInteger(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.setStringValue(ConfigurationValueWizard.this.configuration.getString(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.setURIValue(ConfigurationValueWizard.this.configuration.getURI(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.setUDTValue(ConfigurationValueWizard.this.configuration.getUDT(ConfigurationValueWizard.this.configurationEntryName));
            this.valueWidget.addModifyListener(this);
            this.optionInputParameter = toolkit.createButton(container, "link value with input parameter", 16);
            this.optionInputParameter.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.optionInputParameter.addSelectionListener((SelectionListener)this);
            this.optionInputParameter.setEnabled(ConfigurationValueWizard.this.isActivityConfigAllowed);
            label = toolkit.createLabel(container, "Parameter name:");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtInputParameter = toolkit.createText(container, "");
            this.txtInputParameter.setLayoutData((Object)new GridData(4, 1, false, false));
            this.txtInputParameter.addModifyListener((ModifyListener)this);
            this.optionProcessConfig = toolkit.createButton(container, "link value with process configuration", 16);
            this.optionProcessConfig.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.optionProcessConfig.addSelectionListener((SelectionListener)this);
            this.optionProcessConfig.setEnabled(ConfigurationValueWizard.this.isActivityConfigAllowed);
            label = toolkit.createLabel(container, "Configuration entry name:");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtProcessConfig = toolkit.createText(container, "");
            this.txtProcessConfig.setLayoutData((Object)new GridData(4, 1, false, false));
            this.txtProcessConfig.addModifyListener((ModifyListener)this);
            toolkit.paintBordersFor(container);
            this.showData();
            this.setControl((Control)container);
        }

        protected void showData() {
            int i = 0;
            while (i < this.tblEntryTable.getItemCount()) {
                TableItem item = this.tblEntryTable.getItem(i);
                String entryName = ((ConfigurationDescription.ConfigurationEntry)item.getData("entry")).getName();
                if (entryName.equals(ConfigurationValueWizard.this.configurationEntryName) && !this.tblEntryTable.isSelected(i)) {
                    this.tblEntryTable.setSelection(item);
                    break;
                }
                ++i;
            }
            this.btnFixed.setSelection(ConfigurationValueWizard.this.isSetFixed);
            this.valueWidget.setDatatype(ConfigurationValueWizard.this.getDatatype(ConfigurationValueWizard.this.configurationEntryName));
            this.optionDirectValue.setSelection(ConfigurationValueWizard.this.valueType == ValueType.DIRECT_VALUE);
            this.optionInputParameter.setSelection(ConfigurationValueWizard.this.valueType == ValueType.FROM_INPUT_PARAMETER);
            this.optionProcessConfig.setSelection(ConfigurationValueWizard.this.valueType == ValueType.FROM_PROCESS_CONFIG);
            this.txtProcessConfig.setText(ConfigurationValueWizard.this.processConfigName);
            this.txtInputParameter.setText(ConfigurationValueWizard.this.inputParameterName);
            this.updateButtons();
        }

        protected void updateButtons() {
            this.getWizard().getContainer().updateButtons();
            boolean enable = this.tblEntryTable.getSelectionIndex() >= 0;
            this.btnFixed.setEnabled(ConfigurationValueWizard.this.isFixedAllowed);
            this.valueWidget.setEnabled(enable && ConfigurationValueWizard.this.valueType == ValueType.DIRECT_VALUE);
            this.txtInputParameter.setEnabled(enable && ConfigurationValueWizard.this.valueType == ValueType.FROM_INPUT_PARAMETER);
            this.txtProcessConfig.setEnabled(enable && ConfigurationValueWizard.this.valueType == ValueType.FROM_PROCESS_CONFIG);
        }

        protected boolean checkValid() {
            return this.tblEntryTable.getSelectionIndex() >= 0 && (ConfigurationValueWizard.this.valueType == ValueType.DIRECT_VALUE && this.valueWidget.isValid() || ConfigurationValueWizard.this.valueType == ValueType.FROM_INPUT_PARAMETER && !ConfigurationValueWizard.this.inputParameterName.equals("") || ConfigurationValueWizard.this.valueType == ValueType.FROM_PROCESS_CONFIG && !ConfigurationValueWizard.this.processConfigName.equals(""));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.tblEntryTable) {
                ConfigurationDescription.ConfigurationEntry entry = (ConfigurationDescription.ConfigurationEntry)this.tblEntryTable.getSelection()[0].getData("entry");
                ConfigurationValueWizard.this.configurationEntryName = entry.getName();
                this.valueWidget.setDatatype(entry.getDataType());
            } else if (e.widget == this.btnFixed) {
                ConfigurationValueWizard.this.isSetFixed = this.btnFixed.getSelection();
            } else if (e.widget == this.optionDirectValue) {
                ConfigurationValueWizard.this.valueType = ValueType.DIRECT_VALUE;
            } else if (e.widget == this.optionInputParameter) {
                ConfigurationValueWizard.this.valueType = ValueType.FROM_INPUT_PARAMETER;
            } else if (e.widget == this.optionProcessConfig) {
                ConfigurationValueWizard.this.valueType = ValueType.FROM_PROCESS_CONFIG;
            }
            this.updateButtons();
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.txtInputParameter) {
                ConfigurationValueWizard.this.inputParameterName = this.txtInputParameter.getText();
            } else if (e.widget == this.txtProcessConfig) {
                ConfigurationValueWizard.this.processConfigName = this.txtProcessConfig.getText();
            }
            this.updateButtons();
        }
    }

    protected static enum ValueType {
        DIRECT_VALUE,
        FROM_INPUT_PARAMETER,
        FROM_PROCESS_CONFIG;

    }
}

