/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExecutableComponentDescriptionWizard
extends Wizard {
    ExecutableComponentDescription ecd = null;
    ActivityModelFactory factory = Activator.getService().getActivityModelFactory();
    GeneralPage generalPage = null;

    public ExecutableComponentDescription getExecutableComponentDescription() {
        return this.ecd;
    }

    public void addPages() {
        this.generalPage = new GeneralPage();
        this.addPage((IWizardPage)this.generalPage);
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        this.setWindowTitle("Create new Executable Component Description");
    }

    public boolean performFinish() {
        ExecutionControlProperties ecp = new ExecutionControlProperties(false, false, false);
        this.ecd = this.factory.createExecutableComponentDescription(this.generalPage.txtName.getText(), "", 0L, State.IN_PRODUCTION, "", new ArrayList(), false, null, "NullContext", ecp, null, "", null, null, null, null);
        return true;
    }

    public boolean canFinish() {
        return this.generalPage.canFlipToNextPage();
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener {
        Text txtName;
        private Collection<String> presentECNames;

        protected GeneralPage() {
            super("general");
            this.setTitle("General Information");
            this.setDescription("Enter the name for the executable component description.");
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public void createControl(Composite parent) {
            SessionToken session = Activator.getService().getSessionToken();
            ActivityRepository repository = Activator.getService().getActivityRepository();
            Collection ecdRefs = repository.getECDManager().getDevelopmentECDReferences(session, ARMHelper.getBranch().longValue());
            this.presentECNames = new HashSet<String>();
            for (ECDReference ecdRef : ecdRefs) {
                this.presentECNames.add(ecdRef.getName());
            }
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtName = toolkit.createText(container, "New ECD", 4);
            this.txtName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtName.addModifyListener((ModifyListener)this);
            this.checkValid();
            toolkit.paintBordersFor(container);
            this.setControl((Control)container);
            this.txtName.setFocus();
            this.txtName.selectAll();
        }

        protected void updateButtons() {
            this.getWizard().getContainer().updateButtons();
        }

        protected boolean checkValid() {
            boolean valid = true;
            if (this.presentECNames.contains(this.txtName.getText())) {
                this.setErrorMessage("An ECD with the given name already exists!");
                valid = false;
            } else if (this.txtName.getText().length() == 0) {
                this.setErrorMessage("Please enter a name for the new ECD");
                valid = false;
            } else if (this.txtName.getText().equals("TEST") || this.txtName.getText().equals("TestExecEnv")) {
                this.setErrorMessage("This name is reserved.");
                valid = false;
            } else {
                char[] cArray = ActivityConstants.DISALLOWED_NAME_CHARACTERS;
                int n = ActivityConstants.DISALLOWED_NAME_CHARACTERS.length;
                int n2 = 0;
                while (n2 < n) {
                    char disallowedChar = cArray[n2];
                    if (this.txtName.getText().indexOf(disallowedChar) != -1) {
                        this.setErrorMessage(String.format("Character '%s' not allowed in name.", Character.valueOf(disallowedChar)));
                        valid = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public void modifyText(ModifyEvent e) {
            this.updateButtons();
            this.checkValid();
        }
    }
}

