/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.State;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IdentifierWizard
extends Wizard {
    Identifier identifier = null;
    ActivityModelFactory factory = Activator.getService().getActivityModelFactory();
    GeneralPage generalPage = null;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void addPages() {
        this.generalPage = new GeneralPage();
        this.addPage((IWizardPage)this.generalPage);
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        this.setWindowTitle("Create new Identifier");
    }

    public boolean performFinish() {
        this.identifier = this.factory.createIdentifier(UUID.randomUUID(), this.generalPage.txtName.getText(), "", 0L, State.IN_DEVELOPMENT, null, null);
        return true;
    }

    public boolean canFinish() {
        return this.generalPage.canFlipToNextPage();
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener {
        Text txtName;
        private Collection<String> presentIdentifierNames;

        protected GeneralPage() {
            super("general");
            this.setTitle("General Information");
            this.setDescription("Enter the name for the identifier.");
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public void createControl(Composite parent) {
            SessionToken session = Activator.getService().getSessionToken();
            ActivityRepository repository = Activator.getService().getActivityRepository();
            Collection ids = repository.getIdentifierManager().getDevelopmentIdentifiers(session, ARMHelper.getBranch().longValue());
            this.presentIdentifierNames = new HashSet<String>();
            for (Identifier id : ids) {
                this.presentIdentifierNames.add(id.getName());
            }
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtName = toolkit.createText(container, "new identifier", 4);
            this.txtName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtName.addModifyListener((ModifyListener)this);
            this.checkValid();
            toolkit.paintBordersFor(container);
            this.setControl((Control)container);
        }

        protected void updateButtons() {
            this.getWizard().getContainer().updateButtons();
        }

        protected boolean checkValid() {
            boolean valid = true;
            if (this.presentIdentifierNames.contains(this.txtName.getText())) {
                this.setErrorMessage("An Identifier with the given name already exists!");
                valid = false;
            } else if (this.txtName.getText().length() == 0) {
                this.setErrorMessage("Please enter a name for the new Identifer");
                valid = false;
            } else {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public void modifyText(ModifyEvent e) {
            this.updateButtons();
            this.checkValid();
        }
    }
}

