/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OperationWizard
extends Wizard {
    Operation operation = null;
    ExecutableComponentDescription parentECD;
    ActivityModelFactory factory;
    GeneralPage generalPage;

    public OperationWizard(ExecutableComponentDescription parentECD) {
        this.parentECD = parentECD;
        this.factory = Activator.getService().getActivityModelFactory();
        this.generalPage = null;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void addPages() {
        this.generalPage = new GeneralPage();
        this.addPage((IWizardPage)this.generalPage);
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        this.setWindowTitle("Create new Operation");
    }

    public boolean performFinish() {
        this.operation = this.factory.createOperation(this.parentECD, this.generalPage.txtName.getText(), "", null, 0L, State.IN_DEVELOPMENT, null, null, null, null, null, null, false, false, null, null, null, null, null, ParameterChangePolicy.FIXED, null, null, null, "", null, null);
        return true;
    }

    public boolean canFinish() {
        return this.generalPage.canFlipToNextPage();
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener {
        Text txtName;
        private Collection<String> presentOperationNames;

        protected GeneralPage() {
            super("general");
            this.setTitle("General Information");
            this.setDescription("Enter the name for the operation.");
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public void createControl(Composite parent) {
            SessionToken session = Activator.getService().getSessionToken();
            ActivityRepository repository = Activator.getService().getActivityRepository();
            Collection opRefs = repository.getOperationManager().getDevelopmentOperationReferencesOfECD(session, OperationWizard.this.parentECD.getName(), ARMHelper.getBranch().longValue());
            this.presentOperationNames = new HashSet<String>();
            for (OperationReference opRef : opRefs) {
                this.presentOperationNames.add(opRef.getName());
            }
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtName = toolkit.createText(container, "New Operation", 4);
            this.txtName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtName.addModifyListener((ModifyListener)this);
            this.checkValid();
            toolkit.paintBordersFor(container);
            this.setControl((Control)container);
            this.txtName.setFocus();
            this.txtName.selectAll();
        }

        protected void updateButtons() {
            this.getWizard().getContainer().updateButtons();
        }

        protected boolean checkValid() {
            boolean valid = true;
            if (this.presentOperationNames.contains(this.txtName.getText())) {
                this.setErrorMessage("An Operation with the given name already exists!");
                valid = false;
            } else if (this.txtName.getText().length() == 0) {
                this.setErrorMessage("Please enter a name for the new Operation");
                valid = false;
            } else {
                char[] cArray = ActivityConstants.DISALLOWED_NAME_CHARACTERS;
                int n = ActivityConstants.DISALLOWED_NAME_CHARACTERS.length;
                int n2 = 0;
                while (n2 < n) {
                    char disallowedChar = cArray[n2];
                    if (this.txtName.getText().indexOf(disallowedChar) != -1) {
                        this.setErrorMessage(String.format("Character '%s' not allowed in name.", Character.valueOf(disallowedChar)));
                        valid = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public void modifyText(ModifyEvent e) {
            this.updateButtons();
            this.checkValid();
        }
    }
}

