/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.AdeptValueWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.BooleanInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationDescriptionSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationDescriptionWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.DropDownInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.TextInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.UserAttributeSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.AddIdentifierDialogue;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.IdentifierManager;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.dialogues.SelectIdentifierDialogue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterTemplateWizard
extends Wizard {
    protected final ParameterTemplate parameterTemplate;
    protected final Set<String> otherParameters;
    protected boolean edit;
    protected final SessionToken session;
    private final boolean isReadOnly;
    private FormToolkit toolkit;

    public ParameterTemplateWizard(SessionToken session, Set<String> otherParameter) {
        this(session, EditorHelper.activityModelFactory.createParameterTemplate("New template name", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), otherParameter, false);
        this.edit = false;
    }

    public ParameterTemplateWizard(SessionToken session, ParameterTemplate parameterTemplate, Set<String> otherParameter, boolean readOnly) {
        this.session = session;
        this.isReadOnly = readOnly;
        this.parameterTemplate = parameterTemplate;
        this.otherParameters = otherParameter;
        this.toolkit = new FormToolkit(Display.getCurrent());
        this.edit = true;
    }

    public ParameterTemplate getParameterTemplate() {
        return this.parameterTemplate;
    }

    public void addPages() {
        this.addPage((IWizardPage)new GeneralPage(this.parameterTemplate));
        this.addPage((IWizardPage)new DataTypePage(this.parameterTemplate, this.edit));
        this.addPage((IWizardPage)new ConfigurationPage(this.parameterTemplate));
        this.addPage((IWizardPage)new UserAttributePage(this.parameterTemplate));
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        this.setWindowTitle("Parameter Template Wizard");
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            page.getNextPage();
            ++n2;
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    private void setInheritedDontCareText(TextInheritedWidget widget, String value, boolean inherited) {
        if (value == null) {
            widget.setInheritedTextValue("don't care");
            widget.setValue("");
            widget.setInherited(true);
            widget.setEnabled(true);
        } else if (inherited) {
            widget.setInheritedTextValue("inherit");
            widget.setValue(value);
            widget.setInherited(true);
            widget.setEnabled(false);
        } else {
            widget.setInheritedTextValue("don't care");
            widget.setValue(value);
            widget.setInherited(false);
            widget.setEnabled(true);
        }
    }

    class ConfigurationPage
    extends WizardPage
    implements ConfigurationDescriptionWidget.ConfigurationDescriptionChangedListener,
    IExpansionListener {
        ParameterTemplate parameterTemplate;
        BooleanInheritedWidget btnOptional;
        BooleanInheritedWidget btnVirtual;
        BooleanInheritedWidget btnFailure;
        ConfigurationSection sectionConfiguration;
        ConfigurationDescriptionSection sectionConfigurationDescription;
        private boolean initialized;

        public ConfigurationPage(ParameterTemplate parameterTemplate) {
            super("configuration");
            this.initialized = false;
            this.setTitle("Configuration");
            this.setDescription("Enter the configuration information for the parameter template.");
            this.parameterTemplate = parameterTemplate;
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Optional");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.btnOptional = new BooleanInheritedWidget(container, 0, false, false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            this.btnOptional.setLayoutData(new GridData(1, 2, false, false));
            this.btnOptional.setInheritedTextValue("don't care");
            label = toolkit.createLabel(container, "Virtual");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.btnVirtual = new BooleanInheritedWidget(container, 0, false, false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            this.btnVirtual.setLayoutData(new GridData(1, 2, false, false));
            this.btnVirtual.setInheritedTextValue("don't care");
            label = toolkit.createLabel(container, "Failure");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.btnFailure = new BooleanInheritedWidget(container, 0, false, false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            this.btnFailure.setLayoutData(new GridData(1, 2, false, false));
            this.btnFailure.setInheritedTextValue("don't care");
            InheritedConfigurationDescription confDesc = this.parameterTemplate.getConfigurationDescription();
            this.sectionConfigurationDescription = new ConfigurationDescriptionSection(container, 0, "Parameter configuration description", "Edit the configuration description of the parameter here", confDesc, null, ParameterTemplateWizard.this.isReadOnly, true, toolkit);
            this.sectionConfigurationDescription.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this.sectionConfigurationDescription.addChangeListener(this);
            this.sectionConfigurationDescription.addExpansionListener(this);
            this.sectionConfiguration = new ConfigurationSection(container, 0, "Parameter configuration", "Edit the configuration of the parameter here", confDesc, this.parameterTemplate.getConfiguration(), null, ParameterTemplateWizard.this.isReadOnly, true, true, toolkit);
            this.sectionConfiguration.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this.sectionConfiguration.addExpansionListener(this);
            toolkit.paintBordersFor(container);
            this.showData();
            if (ParameterTemplateWizard.this.isReadOnly) {
                this.btnVirtual.setEnabled(false);
                this.btnOptional.setEnabled(false);
                this.btnFailure.setEnabled(false);
            }
            this.setControl((Control)container);
            this.initialized = true;
        }

        public IWizardPage getNextPage() {
            if (this.initialized) {
                if (this.btnOptional.isInherited()) {
                    this.parameterTemplate.removeOwnOptional();
                } else {
                    this.parameterTemplate.setOptional(this.btnOptional.getValue());
                }
                if (this.btnVirtual.isInherited()) {
                    this.parameterTemplate.removeOwnVirtual();
                } else {
                    this.parameterTemplate.setVirtual(this.btnVirtual.getValue());
                }
                if (this.btnFailure.isInherited()) {
                    this.parameterTemplate.removeOwnFailure();
                } else {
                    this.parameterTemplate.setFailure(this.btnFailure.getValue());
                }
                this.parameterTemplate.setConfigurationDescription(this.sectionConfigurationDescription.getConfigurationDescription());
                this.parameterTemplate.setConfiguration(this.sectionConfiguration.getConfiguration());
            }
            return super.getNextPage();
        }

        public void showData() {
            if (this.parameterTemplate.isOptional() == null) {
                this.btnOptional.setInheritedTextValue("don't care");
                this.btnOptional.setInherited(true);
                this.btnOptional.setEnabled(true);
            } else if (this.parameterTemplate.isOptionalInherited()) {
                this.btnOptional.setInheritedTextValue("inherit");
                this.btnOptional.setInherited(true);
                this.btnOptional.setValue(this.parameterTemplate.isOptional());
                this.btnOptional.setEnabled(false);
            } else {
                this.btnOptional.setInheritedTextValue("don't care");
                this.btnOptional.setInherited(false);
                this.btnOptional.setValue(this.parameterTemplate.isOptional());
                this.btnOptional.setEnabled(true);
            }
            if (this.parameterTemplate.isVirtual() == null) {
                this.btnVirtual.setInheritedTextValue("don't care");
                this.btnVirtual.setInherited(true);
                this.btnVirtual.setEnabled(true);
            } else if (this.parameterTemplate.isVirtualInherited()) {
                this.btnVirtual.setInheritedTextValue("inherit");
                this.btnVirtual.setInherited(true);
                this.btnVirtual.setValue(this.parameterTemplate.isVirtual());
                this.btnVirtual.setEnabled(false);
            } else {
                this.btnVirtual.setInheritedTextValue("don't care");
                this.btnVirtual.setInherited(false);
                this.btnVirtual.setValue(this.parameterTemplate.isVirtual());
                this.btnVirtual.setEnabled(true);
            }
            if (this.parameterTemplate.isFailure() == null) {
                this.btnFailure.setInheritedTextValue("don't care");
                this.btnFailure.setInherited(true);
                this.btnFailure.setEnabled(true);
            } else if (this.parameterTemplate.isFailureInherited()) {
                this.btnFailure.setInheritedTextValue("inherit");
                this.btnFailure.setInherited(true);
                this.btnFailure.setValue(this.parameterTemplate.isFailure());
                this.btnFailure.setEnabled(false);
            } else {
                this.btnFailure.setInheritedTextValue("don't care");
                this.btnFailure.setInherited(false);
                this.btnFailure.setValue(this.parameterTemplate.isFailure());
                this.btnFailure.setEnabled(true);
            }
        }

        @Override
        public void configurationDescriptionChanged(ConfigurationDescriptionWidget widget) {
            this.sectionConfiguration.setConfigurationDescription(this.sectionConfigurationDescription.getConfigurationDescription());
        }

        public void expansionStateChanged(ExpansionEvent e) {
            if (this.getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getContainer()).updateSize();
            }
        }

        public void expansionStateChanging(ExpansionEvent e) {
        }
    }

    class DataTypePage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        ParameterTemplate parameterTemplate;
        Button checkDataTypeDontCare;
        DropDownInheritedWidget cmbDataType;
        TextInheritedWidget txtUDTName;
        TextInheritedWidget txtIdentifier;
        AdeptValueWidget txtDefaultValue;
        Button btnSelectIdentifier;
        boolean initialzed;
        boolean edit;

        public DataTypePage(ParameterTemplate parameterTemplate, boolean edit) {
            super("datatype");
            this.initialzed = false;
            this.edit = edit;
            this.setTitle("Data Type Information");
            this.setDescription("Select the data type and the identifier of the parameter.");
            this.parameterTemplate = parameterTemplate;
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public IWizardPage getNextPage() {
            if (this.initialzed) {
                if (this.checkDataTypeDontCare.getSelection()) {
                    this.parameterTemplate.removeOwnDataType();
                } else {
                    String udtName = null;
                    if ((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED && (udtName = this.txtUDTName.getValue()).length() == 0) {
                        udtName = null;
                    }
                    this.parameterTemplate.setDataType((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData(), udtName);
                }
                if (this.txtDefaultValue.isInherited() || !this.txtDefaultValue.isEnabled()) {
                    this.parameterTemplate.removeOwnDefaultValue();
                } else {
                    this.parameterTemplate.setDefaultValue(this.txtDefaultValue.getValue());
                }
                if (this.txtIdentifier.isInherited()) {
                    this.parameterTemplate.removeOwnIdentifierID();
                }
            }
            return super.getNextPage();
        }

        public void createControl(Composite parent) {
            Composite container = ParameterTemplateWizard.this.toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = ParameterTemplateWizard.this.toolkit.createLabel(container, "Data Type");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.checkDataTypeDontCare = ParameterTemplateWizard.this.toolkit.createButton(container, "don't care", 32);
            this.checkDataTypeDontCare.addSelectionListener((SelectionListener)this);
            this.checkDataTypeDontCare.setLayoutData((Object)new GridData(4, 1, true, false));
            ParameterTemplateWizard.this.toolkit.createLabel(container, "");
            this.cmbDataType = new DropDownInheritedWidget(container, 0, null, ParameterTemplateWizard.this.isReadOnly, null, ParameterTemplateWizard.this.toolkit);
            this.cmbDataType.setLayoutData(new GridData(4, 1, true, false));
            ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
            int n = adeptDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessConstants.AdeptDataType type = adeptDataTypeArray[n2];
                this.cmbDataType.addItem(type.toString(), type);
                ++n2;
            }
            this.cmbDataType.addSelectionListener(this);
            this.cmbDataType.setIndex(ProcessConstants.AdeptDataType.STRING.ordinal());
            ParameterTemplateWizard.this.toolkit.createLabel(container, "");
            Composite udtContainer = ParameterTemplateWizard.this.toolkit.createComposite(container);
            udtContainer.setLayoutData((Object)new GridData(4, 4, true, false));
            udtContainer.setLayout((Layout)new GridLayout(2, false));
            label = ParameterTemplateWizard.this.toolkit.createLabel(udtContainer, "User defined Data Type");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.txtUDTName = new TextInheritedWidget(udtContainer, 0, "", null, ParameterTemplateWizard.this.isReadOnly, null, ParameterTemplateWizard.this.toolkit);
            this.txtUDTName.setLayoutData(new GridData(4, 1, true, false));
            this.txtUDTName.addModifyListener(this);
            this.txtUDTName.setEnabled(this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED);
            label = ParameterTemplateWizard.this.toolkit.createLabel(container, "Default value");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.txtDefaultValue = new AdeptValueWidget(container, 0, ProcessConstants.AdeptDataType.STRING, false, ParameterTemplateWizard.this.isReadOnly, null, ParameterTemplateWizard.this.toolkit);
            this.txtDefaultValue.setLayoutData(new GridData(4, 1, true, false));
            this.txtDefaultValue.addModifyListener(this);
            this.txtDefaultValue.setInheritedTextValue("don't care");
            label = ParameterTemplateWizard.this.toolkit.createLabel(container, "Identifier");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            Composite idContainer = ParameterTemplateWizard.this.toolkit.createComposite(container);
            idContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            idContainer.setLayout((Layout)new GridLayout(2, false));
            this.txtIdentifier = new TextInheritedWidget(idContainer, 8, "", false, ParameterTemplateWizard.this.isReadOnly, null, ParameterTemplateWizard.this.toolkit);
            this.txtIdentifier.setLayoutData(new GridData(4, 1, true, false));
            this.txtIdentifier.addSelectionListener(this);
            this.txtIdentifier.setInheritedTextValue("don't care");
            this.btnSelectIdentifier = ParameterTemplateWizard.this.toolkit.createButton(idContainer, "&Select", 8);
            this.btnSelectIdentifier.setLayoutData((Object)new GridData(1, 1, false, false));
            this.btnSelectIdentifier.addSelectionListener((SelectionListener)this);
            ParameterTemplateWizard.this.toolkit.paintBordersFor(container);
            this.showData();
            if (ParameterTemplateWizard.this.isReadOnly) {
                this.cmbDataType.setEnabled(false);
                this.txtUDTName.setEnabled(false);
                this.txtIdentifier.setEnabled(false);
                this.btnSelectIdentifier.setEnabled(false);
                this.txtDefaultValue.setEnabled(false);
                this.checkDataTypeDontCare.setEnabled(false);
            }
            this.setControl((Control)container);
            this.initialzed = true;
        }

        public void showData() {
            if (this.parameterTemplate.getDataType() == null) {
                this.checkDataTypeDontCare.setSelection(true);
                this.checkDataTypeDontCare.setText("don't care");
                this.checkDataTypeDontCare.setEnabled(true);
                this.cmbDataType.setEnabled(false);
                this.txtUDTName.setEnabled(false);
            } else if (this.parameterTemplate.isDataTypeInherited()) {
                this.checkDataTypeDontCare.setSelection(true);
                this.checkDataTypeDontCare.setText("inhert");
                this.cmbDataType.setIndex(this.parameterTemplate.getDataType().ordinal());
                this.txtUDTName.setValue(this.parameterTemplate.getDataType().equals((Object)ProcessConstants.AdeptDataType.USERDEFINED) ? this.parameterTemplate.getUDTName() : "");
                this.checkDataTypeDontCare.setEnabled(false);
                this.cmbDataType.setEnabled(false);
                this.txtUDTName.setEnabled(false);
            } else {
                this.checkDataTypeDontCare.setSelection(false);
                int index = 0;
                while (ProcessConstants.AdeptDataType.values()[index] != this.parameterTemplate.getDataType()) {
                    ++index;
                }
                this.cmbDataType.setIndex(index);
                this.txtUDTName.setValue(this.parameterTemplate.getUDTName() == null ? "" : this.parameterTemplate.getUDTName());
                this.checkDataTypeDontCare.setEnabled(true);
                this.txtUDTName.setEnabled(this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED);
                this.cmbDataType.setEnabled(true);
            }
            if (this.parameterTemplate.getDataType() == null) {
                this.txtDefaultValue.setDatatype(ProcessConstants.AdeptDataType.STRING);
                this.txtDefaultValue.setValue("");
                this.txtDefaultValue.setInherited(true);
                this.txtDefaultValue.setInheritedTextValue("don't care");
                this.txtDefaultValue.setEnabled(false);
            } else if (this.parameterTemplate.getDefaultValue() == null) {
                this.txtDefaultValue.setDatatype(this.parameterTemplate.getDataType());
                this.txtDefaultValue.setInherited(true);
                this.txtDefaultValue.setInheritedTextValue("don't care");
                this.txtDefaultValue.setEnabled(true);
            } else if (this.parameterTemplate.isDefaultValueInherited()) {
                this.txtDefaultValue.setDatatype(this.parameterTemplate.getDataType());
                this.txtDefaultValue.setValue(this.parameterTemplate.getDefaultValue());
                this.txtDefaultValue.setInherited(true);
                this.txtDefaultValue.setInheritedTextValue("inherit");
                this.txtDefaultValue.setEnabled(false);
            } else {
                this.txtDefaultValue.setDatatype(this.parameterTemplate.getDataType());
                this.txtDefaultValue.setValue(this.parameterTemplate.getDefaultValue());
                this.txtDefaultValue.setInherited(false);
                this.txtDefaultValue.setInheritedTextValue("don't care");
                this.txtDefaultValue.setEnabled(true);
            }
            if (this.parameterTemplate.getIdentifierID() == null) {
                this.txtIdentifier.setInheritedTextValue("don't care");
                this.txtIdentifier.setInherited(true);
                this.txtIdentifier.setValue("<none>");
                this.txtIdentifier.setEnabled(true);
            } else {
                String identifierName = "<none>";
                if (!this.parameterTemplate.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) {
                    IdentifierManager idMan = EditorHelper.activityRepository.getIdentifierManager();
                    Identifier identifier = ARMHelper.getBranch() == null ? idMan.getIdentifierRevision(ParameterTemplateWizard.this.session, this.parameterTemplate.getIdentifierID(), ARMHelper.getRevision().longValue()) : idMan.getDevelopmentIdentifier(ParameterTemplateWizard.this.session, this.parameterTemplate.getIdentifierID(), ARMHelper.getBranch().longValue());
                    identifierName = identifier.getName();
                }
                if (this.parameterTemplate.isIdentifierIDInherited()) {
                    this.txtIdentifier.setInheritedTextValue("inherit");
                    this.txtIdentifier.setInherited(true);
                    this.txtIdentifier.setValue(identifierName);
                    this.txtIdentifier.setEnabled(false);
                } else {
                    this.txtIdentifier.setInheritedTextValue("don't care");
                    this.txtIdentifier.setInherited(false);
                    this.txtIdentifier.setValue(identifierName);
                    this.txtIdentifier.setEnabled(true);
                }
            }
            this.btnSelectIdentifier.setEnabled(!this.txtIdentifier.isInherited());
            this.validate();
        }

        public void modifyText(ModifyEvent e) {
            this.validate();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.cmbDataType || e.widget == this.checkDataTypeDontCare) {
                this.txtUDTName.setEnabled(this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED && !this.checkDataTypeDontCare.getSelection());
                if (!this.checkDataTypeDontCare.getSelection()) {
                    this.txtDefaultValue.setDatatype((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData());
                } else {
                    this.txtDefaultValue.setEnabled(this.parameterTemplate.getDataType() != null);
                    if (this.txtDefaultValue.isEnabled()) {
                        this.txtDefaultValue.setDatatype(this.parameterTemplate.getDataType());
                    }
                }
                this.txtDefaultValue.setEnabled(!this.checkDataTypeDontCare.getSelection());
                this.cmbDataType.setEnabled(!this.checkDataTypeDontCare.getSelection());
                this.validate();
            } else if (e.widget == this.btnSelectIdentifier && !ParameterTemplateWizard.this.isReadOnly) {
                SessionToken session = Activator.getService().getSessionToken();
                Collection identifiers = EditorHelper.activityRepository.getIdentifierManager().getDevelopmentIdentifiers(session, ARMHelper.getBranch().longValue());
                SelectIdentifierDialogue dia = new SelectIdentifierDialogue(session, this.getShell(), Activator.getPluginID(), identifiers, Activator.getService().getFilterFactory(), this.parameterTemplate.getIdentifierID(), true, new SelectIdentifierDialogue.CreateNewIdentifierHandler(){

                    public Identifier createNewIdentifier() throws Exception {
                        String defaultNameIdentifier = "New Identifier";
                        if (DataTypePage.this.parameterTemplate.getName() != null) {
                            defaultNameIdentifier = DataTypePage.this.parameterTemplate.getName();
                        }
                        Identifier newIdentifier = null;
                        AddIdentifierDialogue dia = new AddIdentifierDialogue(DataTypePage.this.getShell(), EditorHelper.activityModelFactory, defaultNameIdentifier);
                        if (dia.open() != 0) {
                            return null;
                        }
                        newIdentifier = dia.getNewIdentifier();
                        SessionToken session = Activator.getService().getSessionToken();
                        IdentifierManager identifierManager = EditorHelper.activityRepository.getIdentifierManager();
                        identifierManager.storeDevelopmentIdentifier(session, newIdentifier, ARMHelper.getBranch().longValue());
                        return newIdentifier;
                    }
                });
                if (dia.open() == 0) {
                    Identifier identifier = dia.getIdentifier();
                    if (identifier != null) {
                        this.parameterTemplate.setIdentifierID(identifier.getID());
                        this.txtIdentifier.setValue(identifier.getName());
                    } else {
                        this.parameterTemplate.setIdentifierID(ProcessConstants.UNIVERSAL_IDENTIFIER_ID);
                        this.txtIdentifier.setValue("<none>");
                    }
                }
            }
            this.btnSelectIdentifier.setEnabled(!this.txtIdentifier.isInherited());
            this.validate();
        }

        public boolean validate() {
            boolean valid = this.checkValid();
            this.getWizard().getContainer().updateButtons();
            return valid;
        }

        public boolean checkValid() {
            if (!this.initialzed) {
                return false;
            }
            boolean valid = true;
            if (this.txtIdentifier.getValue().length() == 0) {
                this.setErrorMessage("Please select an Identifier.");
                valid = false;
            } else if (this.cmbDataType.getSelectedData() != ProcessConstants.AdeptDataType.USERDEFINED && !this.txtDefaultValue.isInherited() && !(valid = this.txtDefaultValue.isValid())) {
                this.setErrorMessage("The default value is not valid for the selected data type!");
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        protected ParameterTemplate parameterTemplate;
        Text txtTemplateName;
        TextInheritedWidget txtDescription;
        TextInheritedWidget txtTemplateDescription;
        TextInheritedWidget txtName;
        DropDownInheritedWidget accessTypes;
        private boolean initialized;

        protected GeneralPage(ParameterTemplate parameterTemplate) {
            super("general");
            this.initialized = false;
            this.setTitle("General Information");
            this.setDescription("Enter the general information for the parameter template.");
            this.parameterTemplate = parameterTemplate;
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public IWizardPage getNextPage() {
            if (this.initialized) {
                this.parameterTemplate.setTemplateName(this.txtTemplateName.getText());
                if (this.txtDescription.isInherited()) {
                    this.parameterTemplate.removeOwnDescription();
                } else {
                    this.parameterTemplate.setDescription(this.txtDescription.getValue());
                }
                if (this.txtTemplateDescription.isInherited()) {
                    this.parameterTemplate.removeOwnTemplateDescription();
                } else {
                    this.parameterTemplate.setTemplateDescription(this.txtTemplateDescription.getValue());
                }
                if (this.txtName.isInherited()) {
                    this.parameterTemplate.removeOwnName();
                } else {
                    this.parameterTemplate.setName(this.txtName.getValue());
                }
                if (this.accessTypes.isInherited()) {
                    this.parameterTemplate.removeOwnAccessType();
                } else {
                    this.parameterTemplate.setAccessType((ActivityConstants.AccessType)this.accessTypes.getSelectedData());
                }
                if (!ParameterTemplateWizard.this.isReadOnly && this.parameterTemplate.getIdentifierID() != null && this.parameterTemplate.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) {
                    IdentifierManager idMan = EditorHelper.activityRepository.getIdentifierManager();
                    Collection identifiers = idMan.getDevelopmentIdentifiers(ParameterTemplateWizard.this.session, ARMHelper.getBranch().longValue());
                    for (Identifier identifier : identifiers) {
                        if (!identifier.getName().toLowerCase().equals(this.txtTemplateName.getText().toLowerCase())) continue;
                        this.parameterTemplate.setIdentifierID(identifier.getID());
                        try {
                            ((DataTypePage)super.getNextPage()).showData();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                }
            }
            return super.getNextPage();
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Template name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtTemplateName = toolkit.createText(container, "", 4);
            this.txtTemplateName.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtTemplateName.addModifyListener((ModifyListener)this);
            this.txtTemplateName.setEnabled(!ParameterTemplateWizard.this.edit);
            label = toolkit.createLabel(container, "Template description");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtTemplateDescription = new TextInheritedWidget(container, 578, "", false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            GridData gd = new GridData(4, 1, true, false);
            gd.heightHint = 60;
            this.txtTemplateDescription.setLayoutData(gd);
            label = toolkit.createLabel(container, "Name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtName = new TextInheritedWidget(container, 4, "", false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            this.txtName.setLayoutData(new GridData(4, 1, true, false));
            label = toolkit.createLabel(container, "Description");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtDescription = new TextInheritedWidget(container, 578, "", false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            gd = new GridData(4, 1, true, false);
            gd.heightHint = 60;
            this.txtDescription.setLayoutData(gd);
            this.txtDescription.addModifyListener(this);
            label = toolkit.createLabel(container, "Directions");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.accessTypes = new DropDownInheritedWidget(container, 0, false, ParameterTemplateWizard.this.isReadOnly, null, toolkit);
            this.accessTypes.addItem("Input", ActivityConstants.AccessType.READ);
            this.accessTypes.addItem("Output", ActivityConstants.AccessType.WRITE);
            this.accessTypes.setIndex(0);
            this.accessTypes.addSelectionListener(this);
            toolkit.paintBordersFor(container);
            this.showData();
            if (ParameterTemplateWizard.this.isReadOnly) {
                this.txtTemplateName.setEnabled(false);
                this.txtDescription.setEnabled(false);
                this.txtTemplateDescription.setEnabled(false);
                this.txtName.setEnabled(false);
                this.accessTypes.setEnabled(false);
            }
            this.setControl((Control)container);
            this.initialized = true;
        }

        protected void showData() {
            this.txtTemplateName.setText(this.parameterTemplate.getTemplateName());
            this.txtTemplateName.selectAll();
            ParameterTemplateWizard.this.setInheritedDontCareText(this.txtDescription, this.parameterTemplate.getDescription(), this.parameterTemplate.isDescriptionInherited());
            ParameterTemplateWizard.this.setInheritedDontCareText(this.txtTemplateDescription, this.parameterTemplate.getTemplateDescription(), this.parameterTemplate.isTemplateDescriptionInherited());
            ParameterTemplateWizard.this.setInheritedDontCareText(this.txtName, this.parameterTemplate.getName(), this.parameterTemplate.isNameInherited());
            if (this.parameterTemplate.getAccessType() == null) {
                this.accessTypes.setInheritedTextValue("don't care");
                this.accessTypes.setIndex(1);
                this.accessTypes.setInherited(true);
                this.accessTypes.setEnabled(true);
            } else if (this.parameterTemplate.isAccessTypeInherited()) {
                this.accessTypes.setInheritedTextValue("inherit");
                this.accessTypes.setIndex(this.parameterTemplate.getAccessType() == ActivityConstants.AccessType.WRITE ? 1 : 0);
                this.accessTypes.setInherited(true);
                this.accessTypes.setEnabled(false);
            } else {
                this.accessTypes.setInheritedTextValue("don't care");
                this.accessTypes.setIndex(this.parameterTemplate.getAccessType() == ActivityConstants.AccessType.WRITE ? 1 : 0);
                this.accessTypes.setInherited(false);
                this.accessTypes.setEnabled(true);
            }
            this.validate();
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.txtTemplateName || e.widget == this.txtDescription) {
                this.validate();
            }
        }

        public boolean validate() {
            boolean valid = this.checkValid();
            this.getWizard().getContainer().updateButtons();
            return valid;
        }

        public boolean checkValid() {
            boolean valid = true;
            if (this.txtTemplateName.getText().length() == 0) {
                this.setErrorMessage("The name of the parameter cannot be empty.");
                valid = false;
            }
            if (ParameterTemplateWizard.this.otherParameters.contains(this.txtTemplateName.getText()) && !ParameterTemplateWizard.this.edit) {
                this.setErrorMessage("The given name and access type already exists");
                valid = false;
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.validate();
        }

        public void widgetSelected(SelectionEvent e) {
            this.validate();
        }
    }

    class UserAttributePage
    extends WizardPage {
        ParameterTemplate parameterTemplate;
        UserAttributeSection uaSection;
        private boolean initialized;

        public UserAttributePage(ParameterTemplate parameterTemplate) {
            super("userattribes");
            this.initialized = false;
            this.setTitle("User Attributes");
            this.setDescription("Edit the user defined attributes for this parameter.");
            this.parameterTemplate = parameterTemplate;
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(1, false);
            container.setLayout((Layout)layout);
            this.uaSection = new UserAttributeSection(container, 64, "User attributes", "Specify the user attributes here", this.parameterTemplate.getUserAttributes(), null, ParameterTemplateWizard.this.isReadOnly, true, toolkit);
            this.uaSection.setLayoutData(new GridData(4, 4, true, true));
            toolkit.paintBordersFor(container);
            this.setControl((Control)container);
            this.showData();
            this.initialized = true;
        }

        public void showData() {
            this.uaSection.setUserAttributes(this.parameterTemplate.getUserAttributes());
        }

        public IWizardPage getNextPage() {
            if (this.initialized) {
                new HashMap();
                for (Map.Entry<String, String> guiEntry : this.uaSection.getUserAttributes().entrySet()) {
                    if (this.parameterTemplate.getUserAttributes().containsKey(guiEntry.getKey()) && ((String)this.parameterTemplate.getUserAttributes().get(guiEntry.getKey())).equals(guiEntry.getValue())) continue;
                    this.parameterTemplate.setUserAttributeValue(guiEntry.getKey(), guiEntry.getValue());
                }
                HashMap tmp = new HashMap(this.parameterTemplate.getUserAttributes());
                for (Map.Entry paramEntry : tmp.entrySet()) {
                    if (this.uaSection.getUserAttributes().containsKey(paramEntry.getKey())) continue;
                    this.parameterTemplate.removeUserAttributeValue((String)paramEntry.getKey());
                }
            }
            return super.getNextPage();
        }
    }
}

