/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import de.aristaflow.adept2.app.activityrepositoryeditor.ARMHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.Activator;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.EditorHelper;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.AdeptValueWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.BooleanInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationDescriptionSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationDescriptionWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.ConfigurationSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.DropDownInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.TextInheritedWidget;
import de.aristaflow.adept2.app.activityrepositoryeditor.editors.widgets.UserAttributeSection;
import de.aristaflow.adept2.app.activityrepositoryeditor.wizards.AddIdentifierDialogue;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.IdentifierManager;
import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.dialogues.SelectIdentifierDialogue;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterWizard
extends Wizard {
    protected ActivityConstants.AccessType accessType;
    protected final ActivityModelParameter parameter;
    protected final Set<Pair<String, ActivityConstants.AccessType>> otherParameters;
    protected final SessionToken session;
    private final boolean isReadOnly;

    public ParameterWizard(SessionToken session, Set<Pair<String, ActivityConstants.AccessType>> otherParameter, ParameterTemplate template) {
        this(session, template == null ? EditorHelper.activityModelFactory.createParameter("New parameter", "", "", ProcessConstants.AdeptDataType.STRING, null, ProcessConstants.UNIVERSAL_IDENTIFIER_ID, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null, null, null) : EditorHelper.activityModelFactory.createParameter(template.getName() != null ? template.getName() : "New parameter", template.getDescription() != null ? template.getDescription() : "", template.getDescription() != null ? template.getDescription() : "", template.getDataType() != null ? template.getDataType() : ProcessConstants.AdeptDataType.STRING, template.getUDTName() != null ? template.getUDTName() : (template.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED ? "" : null), template.getIdentifierID() != null ? template.getIdentifierID() : ProcessConstants.UNIVERSAL_IDENTIFIER_ID, Boolean.valueOf(template.isOptional() != null ? template.isOptional() : false), Boolean.valueOf(template.isVirtual() != null ? template.isVirtual() : false), Boolean.valueOf(template.isFailure() != null ? template.isFailure() : false), template.getDefaultValue() != null ? template.getDefaultValue() : "", template.getConfigurationDescription(), EditorHelper.activityModelFactory.createInheritedActivityConfiguration(null, template.getConfiguration()), (PluginDataContainer)new DefaultPluginDataContainer((PluginDataContainer)template, template.getUserAttributes()), template.getUserAttributes()), template == null || template.getAccessType() == null ? ActivityConstants.AccessType.READ : template.getAccessType(), otherParameter, false);
    }

    public ParameterWizard(SessionToken session, ActivityModelParameter parameter, ActivityConstants.AccessType accessType, Set<Pair<String, ActivityConstants.AccessType>> otherParameter, boolean readOnly) {
        this.session = session;
        this.isReadOnly = readOnly;
        this.parameter = parameter;
        this.accessType = accessType;
        this.otherParameters = otherParameter;
    }

    public ActivityModelParameter getParameter() {
        return this.parameter;
    }

    public ActivityConstants.AccessType getAccessType() {
        return this.accessType;
    }

    public void addPages() {
        this.addPage((IWizardPage)new GeneralPage(this.parameter));
        this.addPage((IWizardPage)new DataTypePage(this.parameter));
        this.addPage((IWizardPage)new ConfigurationPage(this.parameter));
        this.addPage((IWizardPage)new UserAttributePage(this.parameter));
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        this.setWindowTitle("Parameter Wizard");
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            page.getNextPage();
            ++n2;
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    class ConfigurationPage
    extends WizardPage
    implements ConfigurationDescriptionWidget.ConfigurationDescriptionChangedListener,
    IExpansionListener {
        ActivityModelParameter parameter;
        BooleanInheritedWidget btnOptional;
        BooleanInheritedWidget btnVirtual;
        BooleanInheritedWidget btnFailure;
        ConfigurationSection sectionConfiguration;
        ConfigurationDescriptionSection sectionConfigurationDescription;
        private boolean initialized;

        public ConfigurationPage(ActivityModelParameter parameter) {
            super("configuration");
            this.initialized = false;
            this.setTitle("Configuration");
            this.setDescription("Enter the configuration information for the parameter.");
            this.parameter = parameter;
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Optional");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.btnOptional = new BooleanInheritedWidget(container, 0, false, false, ParameterWizard.this.isReadOnly, null, toolkit);
            this.btnOptional.setLayoutData(new GridData(1, 1, false, false));
            label = toolkit.createLabel(container, "Virtual");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.btnVirtual = new BooleanInheritedWidget(container, 0, false, null, ParameterWizard.this.isReadOnly, null, toolkit);
            this.btnVirtual.setLayoutData(new GridData(1, 1, false, false));
            label = toolkit.createLabel(container, "Failure");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.btnFailure = new BooleanInheritedWidget(container, 0, false, null, ParameterWizard.this.isReadOnly, null, toolkit);
            this.btnFailure.setLayoutData(new GridData(1, 1, false, false));
            InheritedConfigurationDescription confDesc = this.parameter.getConfigurationDescription();
            this.sectionConfigurationDescription = new ConfigurationDescriptionSection(container, 0, "Parameter configuration description", "Edit the configuration description of the parameter here", confDesc, null, ParameterWizard.this.isReadOnly, true, toolkit);
            this.sectionConfigurationDescription.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this.sectionConfigurationDescription.addChangeListener(this);
            this.sectionConfigurationDescription.addExpansionListener(this);
            this.sectionConfiguration = new ConfigurationSection(container, 0, "Parameter configuration", "Edit the configuration of the parameter here", confDesc, (InheritedConfiguration)this.parameter.getConfiguration(), null, ParameterWizard.this.isReadOnly, true, true, toolkit);
            this.sectionConfiguration.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this.sectionConfiguration.addExpansionListener(this);
            toolkit.paintBordersFor(container);
            this.showData();
            if (ParameterWizard.this.isReadOnly) {
                this.btnVirtual.setEnabled(false);
                this.btnOptional.setEnabled(false);
                this.btnFailure.setEnabled(false);
            }
            this.setControl((Control)container);
            this.initialized = true;
        }

        public IWizardPage getNextPage() {
            if (this.initialized) {
                if (this.btnOptional.isInherited()) {
                    this.parameter.removeOwnOptional();
                } else {
                    this.parameter.setOptional(this.btnOptional.getValue());
                }
                this.parameter.setVirtual(this.btnVirtual.getValue());
                this.parameter.setFailure(this.btnFailure.getValue());
                this.parameter.setConfigurationDescription(this.sectionConfigurationDescription.getConfigurationDescription());
                this.parameter.setConfiguration((InheritedActivityConfiguration)this.sectionConfiguration.getConfiguration());
            }
            return super.getNextPage();
        }

        public void showData() {
            this.btnOptional.setValue(this.parameter.isOptional());
            this.btnOptional.setInherited(this.parameter.isOptionalInherited());
            this.btnVirtual.setValue(this.parameter.isVirtual());
            this.btnFailure.setValue(this.parameter.isFailure());
        }

        @Override
        public void configurationDescriptionChanged(ConfigurationDescriptionWidget widget) {
            this.sectionConfiguration.setConfigurationDescription(widget.getConfigurationDescription());
        }

        public void expansionStateChanged(ExpansionEvent e) {
            if (this.getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getContainer()).updateSize();
            }
        }

        public void expansionStateChanging(ExpansionEvent e) {
        }
    }

    class DataTypePage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        ActivityModelParameter parameter;
        DropDownInheritedWidget cmbDataType;
        TextInheritedWidget txtUDTName;
        TextInheritedWidget txtIdentifier;
        AdeptValueWidget txtDefaultValue;
        Button btnSelectIdentifier;
        boolean initialzed;

        public DataTypePage(ActivityModelParameter parameter) {
            super("datatype");
            this.initialzed = false;
            this.setTitle("Data Type Information");
            this.setDescription("Select the data type and the identifier of the parameter.");
            this.parameter = parameter;
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public IWizardPage getNextPage() {
            if (this.initialzed) {
                if ((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    this.parameter.setDataType((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData(), this.txtUDTName.getValue());
                } else {
                    this.parameter.setDataType((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData(), null);
                }
                if (this.txtDefaultValue.isInherited()) {
                    this.parameter.removeOwnDefaultValue();
                } else {
                    this.parameter.setDefaultValue(this.txtDefaultValue.getValue());
                }
            }
            return super.getNextPage();
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Data Type");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.cmbDataType = new DropDownInheritedWidget(container, 0, null, ParameterWizard.this.isReadOnly, null, toolkit);
            this.cmbDataType.setLayoutData(new GridData(4, 1, true, false));
            ProcessConstants.AdeptDataType[] adeptDataTypeArray = ProcessConstants.AdeptDataType.values();
            int n = adeptDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessConstants.AdeptDataType type = adeptDataTypeArray[n2];
                this.cmbDataType.addItem(type.toString(), type);
                ++n2;
            }
            this.cmbDataType.addSelectionListener(this);
            this.cmbDataType.setIndex(ProcessConstants.AdeptDataType.STRING.ordinal());
            toolkit.createLabel(container, "");
            Composite udtContainer = toolkit.createComposite(container);
            udtContainer.setLayoutData((Object)new GridData(4, 4, true, false));
            udtContainer.setLayout((Layout)new GridLayout(2, false));
            label = toolkit.createLabel(udtContainer, "User defined Data Type");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.txtUDTName = new TextInheritedWidget(udtContainer, 0, "", null, ParameterWizard.this.isReadOnly, null, toolkit);
            this.txtUDTName.setLayoutData(new GridData(4, 1, true, false));
            this.txtUDTName.addModifyListener(this);
            this.txtUDTName.setEnabled(this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED);
            label = toolkit.createLabel(container, "Default value");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            this.txtDefaultValue = new AdeptValueWidget(container, 0, ProcessConstants.AdeptDataType.STRING, false, ParameterWizard.this.isReadOnly, null, toolkit);
            this.txtDefaultValue.setLayoutData(new GridData(4, 1, true, false));
            this.txtDefaultValue.addModifyListener(this);
            label = toolkit.createLabel(container, "Identifier");
            label.setLayoutData((Object)new GridData(1, 2, false, false));
            Composite idContainer = toolkit.createComposite(container);
            idContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            idContainer.setLayout((Layout)new GridLayout(2, false));
            this.txtIdentifier = new TextInheritedWidget(idContainer, 8, "", false, ParameterWizard.this.isReadOnly, null, toolkit);
            this.txtIdentifier.setLayoutData(new GridData(4, 1, true, false));
            this.txtIdentifier.addSelectionListener(this);
            this.btnSelectIdentifier = toolkit.createButton(idContainer, "&Select", 8);
            this.btnSelectIdentifier.setLayoutData((Object)new GridData(1, 1, false, false));
            this.btnSelectIdentifier.addSelectionListener((SelectionListener)this);
            toolkit.paintBordersFor(container);
            toolkit.paintBordersFor(container);
            this.showData();
            if (ParameterWizard.this.isReadOnly) {
                this.cmbDataType.setEnabled(false);
                this.txtUDTName.setEnabled(false);
                this.txtIdentifier.setEnabled(false);
                this.btnSelectIdentifier.setEnabled(false);
                this.txtDefaultValue.setEnabled(false);
            }
            this.setControl((Control)container);
            this.initialzed = true;
        }

        public void showData() {
            this.cmbDataType.setIndex(this.parameter.getDataType().ordinal());
            String udtName = this.parameter.getUDTName();
            if (udtName == null) {
                this.txtUDTName.setValue("");
            } else {
                this.txtUDTName.setValue(udtName);
            }
            this.txtUDTName.setEnabled((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED);
            String value = this.parameter.getDefaultValue();
            Long intValue = ConfigurationTools.parseInteger((String)value);
            Double floatValue = ConfigurationTools.parseFloat((String)value);
            Boolean boolValue = ConfigurationTools.parseBoolean((String)value);
            this.txtDefaultValue.setIntValue(intValue != null ? intValue : Long.valueOf(0L));
            this.txtDefaultValue.setFloatValue(floatValue != null ? floatValue : Double.valueOf(0.0));
            this.txtDefaultValue.setBoolValue(boolValue != null ? boolValue : Boolean.TRUE);
            this.txtDefaultValue.setUDTValue(ConfigurationTools.parseUDT((String)value));
            this.txtDefaultValue.setDateValue(ConfigurationTools.parseDate((String)value));
            this.txtDefaultValue.setURIValue(ConfigurationTools.parseURI((String)value));
            this.txtDefaultValue.setDatatype(this.parameter.getDataType());
            this.txtDefaultValue.setStringValue(value);
            this.txtDefaultValue.setInherited(this.parameter.isDefaultValueInherited());
            if (this.parameter.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) {
                this.txtIdentifier.setValue("<none>");
            } else {
                IdentifierManager idMan = EditorHelper.activityRepository.getIdentifierManager();
                Identifier identifier = ARMHelper.getBranch() == null ? idMan.getIdentifierRevision(ParameterWizard.this.session, this.parameter.getIdentifierID(), ARMHelper.getRevision().longValue()) : idMan.getDevelopmentIdentifier(ParameterWizard.this.session, this.parameter.getIdentifierID(), ARMHelper.getBranch().longValue());
                this.txtIdentifier.setValue(identifier.getName());
            }
            this.validate();
        }

        public void modifyText(ModifyEvent e) {
            this.validate();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.cmbDataType) {
                this.txtUDTName.setEnabled((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED);
                this.txtDefaultValue.setDatatype((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData());
                this.validate();
            } else if (e.widget == this.btnSelectIdentifier && !ParameterWizard.this.isReadOnly) {
                SessionToken session = Activator.getService().getSessionToken();
                Collection identifiers = EditorHelper.activityRepository.getIdentifierManager().getDevelopmentIdentifiers(session, ARMHelper.getBranch().longValue());
                SelectIdentifierDialogue dia = new SelectIdentifierDialogue(session, this.getShell(), Activator.getPluginID(), identifiers, Activator.getService().getFilterFactory(), this.parameter.getIdentifierID(), true, new SelectIdentifierDialogue.CreateNewIdentifierHandler(){

                    public Identifier createNewIdentifier() throws Exception {
                        Identifier newIdentifier = null;
                        AddIdentifierDialogue dia = new AddIdentifierDialogue(DataTypePage.this.getShell(), EditorHelper.activityModelFactory, DataTypePage.this.parameter.getName());
                        if (dia.open() != 0) {
                            return null;
                        }
                        newIdentifier = dia.getNewIdentifier();
                        SessionToken session = Activator.getService().getSessionToken();
                        IdentifierManager identifierManager = EditorHelper.activityRepository.getIdentifierManager();
                        identifierManager.storeDevelopmentIdentifier(session, newIdentifier, ARMHelper.getBranch().longValue());
                        return newIdentifier;
                    }
                });
                if (dia.open() == 0) {
                    Identifier identifier = dia.getIdentifier();
                    if (identifier != null) {
                        this.parameter.setIdentifierID(identifier.getID());
                        this.txtIdentifier.setValue(identifier.getName());
                    } else {
                        this.parameter.setIdentifierID(ProcessConstants.UNIVERSAL_IDENTIFIER_ID);
                        this.txtIdentifier.setValue("<none>");
                    }
                }
            }
        }

        public boolean validate() {
            boolean valid = this.checkValid();
            this.getWizard().getContainer().updateButtons();
            return valid;
        }

        public boolean checkValid() {
            if (!this.initialzed) {
                return false;
            }
            boolean valid = true;
            if ((ProcessConstants.AdeptDataType)this.cmbDataType.getSelectedData() == ProcessConstants.AdeptDataType.USERDEFINED && this.txtUDTName.getValue().length() == 0) {
                this.setErrorMessage("You need to enter a User defined Data Type name.");
                valid = false;
            } else if (this.txtIdentifier.getValue().length() == 0) {
                this.setErrorMessage("Please select an Identifier.");
                valid = false;
            } else if (this.cmbDataType.getSelectedData() != ProcessConstants.AdeptDataType.USERDEFINED && !this.txtDefaultValue.isInherited() && !(valid = this.txtDefaultValue.isValid())) {
                this.setErrorMessage("The default value is not valid for the selected data type!");
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener,
    SelectionListener {
        protected ActivityModelParameter modelParameter;
        Text txtTemplateName;
        TextInheritedWidget txtDescription;
        TextInheritedWidget txtDeveloperDescription;
        TextInheritedWidget txtName;
        DropDownInheritedWidget accessTypes;
        private boolean initialized;
        private FormToolkit toolkit;

        protected GeneralPage(ActivityModelParameter parameter) {
            super("general");
            this.initialized = false;
            this.setTitle("General Information");
            this.setDescription("Enter the general information for the parameter.");
            this.modelParameter = parameter;
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public IWizardPage getNextPage() {
            if (this.initialized) {
                this.modelParameter.setName(this.txtName.getValue());
                if (this.txtDescription.isInherited()) {
                    this.modelParameter.removeOwnDescription();
                } else {
                    this.modelParameter.setDescription(this.txtDescription.getValue());
                }
                if (this.txtDeveloperDescription.isInherited()) {
                    this.modelParameter.removeOwnDeveloperDescription();
                } else {
                    this.modelParameter.setDeveloperDescription(this.txtDeveloperDescription.getValue());
                }
                ParameterWizard.this.accessType = (ActivityConstants.AccessType)this.accessTypes.getSelectedData();
                if (!ParameterWizard.this.isReadOnly && this.modelParameter.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) {
                    IdentifierManager idMan = EditorHelper.activityRepository.getIdentifierManager();
                    Collection identifiers = idMan.getDevelopmentIdentifiers(ParameterWizard.this.session, ARMHelper.getBranch().longValue());
                    for (Identifier identifier : identifiers) {
                        if (!identifier.getName().toLowerCase().equals(this.txtName.getValue().toLowerCase())) continue;
                        this.modelParameter.setIdentifierID(identifier.getID());
                        try {
                            ((DataTypePage)super.getNextPage()).showData();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                }
            }
            return super.getNextPage();
        }

        public void createControl(Composite parent) {
            this.toolkit = new FormToolkit(parent.getDisplay());
            this.toolkit.adapt(parent);
            Composite container = this.toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = this.toolkit.createLabel(container, "Name");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtName = new TextInheritedWidget(container, 0, "", null, ParameterWizard.this.isReadOnly, null, this.toolkit);
            this.txtName.setLayoutData(new GridData(4, 1, true, false));
            this.txtName.addModifyListener(this);
            label = this.toolkit.createLabel(container, "Description");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtDescription = new TextInheritedWidget(container, 578, "", false, ParameterWizard.this.isReadOnly, null, this.toolkit);
            GridData gd = new GridData(4, 1, true, false);
            gd.heightHint = 60;
            this.txtDescription.setLayoutData(gd);
            label = this.toolkit.createLabel(container, "Developer Description");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtDeveloperDescription = new TextInheritedWidget(container, 578, "", false, ParameterWizard.this.isReadOnly, null, this.toolkit);
            gd = new GridData(4, 1, true, false);
            gd.heightHint = 60;
            this.txtDeveloperDescription.setLayoutData(gd);
            label = this.toolkit.createLabel(container, "Directions");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.accessTypes = new DropDownInheritedWidget(container, 0, null, ParameterWizard.this.isReadOnly, null, this.toolkit);
            this.accessTypes.addItem("Input", ActivityConstants.AccessType.READ);
            this.accessTypes.addItem("Output", ActivityConstants.AccessType.WRITE);
            this.accessTypes.setIndex(0);
            this.accessTypes.addSelectionListener(this);
            this.toolkit.paintBordersFor(container);
            this.showData();
            if (ParameterWizard.this.isReadOnly) {
                this.txtName.setEnabled(false);
                this.txtDescription.setEnabled(false);
                this.txtDeveloperDescription.setEnabled(false);
                this.accessTypes.setEnabled(false);
            }
            this.setControl((Control)container);
            this.initialized = true;
        }

        protected void showData() {
            this.txtName.setValue(this.modelParameter.getName());
            this.txtDescription.setValue(this.modelParameter.getDescription());
            this.txtDescription.setInherited(this.modelParameter.isDescriptionInherited());
            this.txtDeveloperDescription.setValue(this.modelParameter.getDeveloperDescription());
            this.txtDeveloperDescription.setInherited(this.modelParameter.isDeveloperDescriptionInherited());
            switch (ParameterWizard.this.accessType) {
                case WRITE: {
                    this.accessTypes.setIndex(1);
                    break;
                }
                case READ: {
                    this.accessTypes.setIndex(0);
                    break;
                }
                case SYSTEM_READ: 
                case SYSTEM_WRITE: {
                    throw new AssertionError((Object)("Wrong access type for the AR: " + ParameterWizard.this.accessType));
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            this.validate();
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.txtName) {
                this.validate();
            }
        }

        public boolean validate() {
            boolean valid = this.checkValid();
            this.getWizard().getContainer().updateButtons();
            return valid;
        }

        public boolean checkValid() {
            boolean valid = true;
            if (this.txtName.getValue().length() == 0) {
                this.setErrorMessage("The name of the parameter cannot be empty.");
                valid = false;
            }
            for (Pair<String, ActivityConstants.AccessType> existing : ParameterWizard.this.otherParameters) {
                ActivityConstants.AccessType type = (ActivityConstants.AccessType)this.accessTypes.getSelectedData();
                if (!type.equals(existing.getSecond()) || !this.txtName.getValue().equals(existing.getFirst())) continue;
                this.setErrorMessage("The given name and access type already exists");
                valid = false;
                break;
            }
            if (valid) {
                this.setErrorMessage(null);
            }
            return valid;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.validate();
        }

        public void widgetSelected(SelectionEvent e) {
            this.validate();
        }
    }

    class UserAttributePage
    extends WizardPage {
        ActivityModelParameter parameter;
        UserAttributeSection uaSection;
        private boolean initialized;

        public UserAttributePage(ActivityModelParameter parameter) {
            super("userattribes");
            this.initialized = false;
            this.setTitle("User Attributes");
            this.setDescription("Edit the user defined attributes for this parameter.");
            this.parameter = parameter;
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(1, false);
            container.setLayout((Layout)layout);
            this.uaSection = new UserAttributeSection(container, 64, "User attributes", "Specify the user attributes here", this.parameter.getUserAttributes(), null, ParameterWizard.this.isReadOnly, true, toolkit);
            this.uaSection.setLayoutData(new GridData(4, 4, true, true));
            toolkit.paintBordersFor(container);
            this.showData();
            this.setControl((Control)container);
            this.initialized = true;
        }

        public void showData() {
            this.uaSection.setUserAttributes(this.parameter.getUserAttributes());
        }

        public IWizardPage getNextPage() {
            if (this.initialized) {
                new HashMap();
                for (Map.Entry<String, String> guiEntry : this.uaSection.getUserAttributes().entrySet()) {
                    if (this.parameter.getUserAttributes().containsKey(guiEntry.getKey()) && ((String)this.parameter.getUserAttributes().get(guiEntry.getKey())).equals(guiEntry.getValue())) continue;
                    this.parameter.setUserAttributeValue(guiEntry.getKey(), guiEntry.getValue());
                }
                HashMap tmp = new HashMap(this.parameter.getUserAttributes());
                for (Map.Entry paramEntry : tmp.entrySet()) {
                    if (this.uaSection.getUserAttributes().containsKey(paramEntry.getKey())) continue;
                    this.parameter.removeUserAttributeValue((String)paramEntry.getKey());
                }
            }
            return super.getNextPage();
        }
    }
}

