/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.app.activityrepositoryeditor.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UserAttributeWizard
extends Wizard {
    String key;
    String value;
    boolean isNew;
    GeneralPage generalPage;

    public UserAttributeWizard() {
        this.key = "";
        this.value = "";
        this.isNew = true;
    }

    public UserAttributeWizard(String key, String value) {
        this.key = key;
        this.value = value;
        this.isNew = false;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void addPages() {
        this.generalPage = new GeneralPage();
        this.addPage((IWizardPage)this.generalPage);
    }

    public void createPageControls(Composite pageContainer) {
        FormToolkit toolkit = new FormToolkit(pageContainer.getDisplay());
        Color bgColor = toolkit.getColors().getBackground();
        pageContainer.getParent().setBackground(bgColor);
        String title = "User Attribute wizard - ";
        title = this.isNew ? String.valueOf(title) + "new entry" : String.valueOf(title) + "edit entry";
        this.setWindowTitle(title);
    }

    public boolean performFinish() {
        return true;
    }

    class GeneralPage
    extends WizardPage
    implements ModifyListener {
        Text txtKey;
        Text txtValue;

        protected GeneralPage() {
            super("general");
            this.setTitle("General Information");
            this.setDescription("Enter the key and the value for the user attribute.");
        }

        public boolean canFlipToNextPage() {
            return this.checkValid();
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.checkValid();
        }

        public void createControl(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            toolkit.adapt(parent);
            Composite container = toolkit.createComposite(parent);
            GridLayout layout = new GridLayout(2, false);
            container.setLayout((Layout)layout);
            Label label = toolkit.createLabel(container, "Key");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtKey = toolkit.createText(container, "", 4);
            this.txtKey.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtKey.addModifyListener((ModifyListener)this);
            this.txtKey.setEditable(UserAttributeWizard.this.isNew);
            label = toolkit.createLabel(container, "Value");
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            this.txtValue = toolkit.createText(container, "", 4);
            this.txtValue.setLayoutData((Object)new GridData(4, 1, true, false));
            this.txtValue.addModifyListener((ModifyListener)this);
            toolkit.paintBordersFor(container);
            this.showData();
            this.setControl((Control)container);
        }

        protected void showData() {
            this.txtKey.setText(UserAttributeWizard.this.key);
            this.txtValue.setText(UserAttributeWizard.this.value);
            this.updateButtons();
        }

        protected void updateButtons() {
            this.getWizard().getContainer().updateButtons();
        }

        protected boolean checkValid() {
            return !UserAttributeWizard.this.key.equals("");
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this.txtKey) {
                UserAttributeWizard.this.key = this.txtKey.getText();
            } else if (e.widget == this.txtValue) {
                UserAttributeWizard.this.value = this.txtValue.getText();
            }
            this.updateButtons();
        }
    }
}

