/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.graphml;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Observation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.io.GraphMLWriter;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;

public class GraphMLExport {
    private TimeModelOperations timeModelTools;
    private static final Dimension GRAPH_DIMENSION = new Dimension(800, 800);

    public GraphMLExport(TimeModelOperations timeModelOperations) {
        this.timeModelTools = timeModelOperations;
    }

    public Graph<LabeledTimePoint, LabeledEdge> getGraphForTCN(TCN<LabeledTimePoint, LabeledEdge> tcn) {
        GraphTransformation transformation = new GraphTransformation(tcn);
        return transformation.getGraph();
    }

    public InputStream getInputStreamForTCN(TCN<LabeledTimePoint, LabeledEdge> tcn) throws IOException, IllegalArgumentException {
        GraphTransformation transformation = new GraphTransformation(tcn);
        return transformation.getInputStream();
    }

    private class GraphTransformation {
        private final TCN<LabeledTimePoint, LabeledEdge> tcn;
        private Map<LabeledTimePoint, Integer> nodes;

        GraphTransformation(TCN<LabeledTimePoint, LabeledEdge> tcn) {
            this.tcn = tcn;
            this.nodes = new HashMap<LabeledTimePoint, Integer>();
        }

        protected Graph<LabeledTimePoint, LabeledEdge> getGraph() {
            DirectedSparseGraph g = new DirectedSparseGraph();
            int i = 0;
            for (LabeledTimePoint node : this.tcn.getTimePoints()) {
                g.addVertex((Object)node);
                this.nodes.put(node, i++);
            }
            for (LabeledEdge edge : this.tcn.getEdges()) {
                g.addEdge((Object)edge, (Object)((LabeledTimePoint)edge.getSourceNode()), (Object)((LabeledTimePoint)edge.getTargetNode()), EdgeType.DIRECTED);
            }
            return g;
        }

        protected InputStream getInputStream() throws IOException, IllegalArgumentException {
            Graph<LabeledTimePoint, LabeledEdge> graph = this.getGraph();
            final FRLayout layout = new FRLayout(graph, GRAPH_DIMENSION);
            layout.initialize();
            while (!layout.done()) {
                layout.step();
            }
            GraphMLWriter graphWriter = new GraphMLWriter();
            graphWriter.addGraphData("Name", "Graph File Name", "", (Transformer)new Transformer<Hypergraph<LabeledTimePoint, LabeledEdge>, String>(){

                public String transform(Hypergraph<LabeledTimePoint, LabeledEdge> graph) {
                    return GraphTransformation.this.tcn.getClass().getSimpleName();
                }
            });
            graphWriter.setVertexIDs((Transformer)new Transformer<LabeledTimePoint, String>(){

                public String transform(LabeledTimePoint node) {
                    int id = (Integer)GraphTransformation.this.nodes.get(node);
                    String nodeID = "" + GraphTransformation.this.nodeIDToChar(id);
                    if (node instanceof DefaultObservationTimePoint) {
                        nodeID = String.valueOf(nodeID) + "?";
                    }
                    return nodeID;
                }
            });
            graphWriter.addVertexData("Obs", "Proposition Observed. Format: [a-zA-Z]", "", (Transformer)new Transformer<LabeledTimePoint, String>(){

                public String transform(LabeledTimePoint arg0) {
                    if (arg0 instanceof DefaultObservationTimePoint) {
                        DefaultObservationTimePoint node = (DefaultObservationTimePoint)arg0;
                        if (node.getObservation().getOptions() > 2) {
                            throw new IllegalArgumentException("This file format only supports at most two options for observations!");
                        }
                        String observation = GraphTransformation.this.convertObservation(node.getObservation());
                        if (!$assertionsDisabled && observation.length() != 1) {
                            throw new AssertionError();
                        }
                        return observation;
                    }
                    return null;
                }
            });
            graphWriter.addVertexData("Label", "Label. Format: [\u00ac[a-zA-Z]|[a-zA-Z]]+|\u22a1", "", (Transformer)new Transformer<LabeledTimePoint, String>(){

                public String transform(LabeledTimePoint node) {
                    Label label = node.getLabel();
                    if (label.isEmptyLabel()) {
                        return "\u22a1";
                    }
                    return GraphTransformation.this.convertLabel(label);
                }
            });
            graphWriter.addVertexData("y", "The y coordinate for the visualitation. A positive value.", "", (Transformer)new Transformer<LabeledTimePoint, String>(){

                public String transform(LabeledTimePoint node) {
                    PluginData pluginData = node.getPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting");
                    if (pluginData != null) {
                        String yCoord = pluginData.getPluginDataEntry("y");
                        return yCoord;
                    }
                    return "" + (int)layout.getY((Object)node);
                }
            });
            graphWriter.addVertexData("x", "The x coordinate for the visualitation. A positive value.", "", (Transformer)new Transformer<LabeledTimePoint, String>(){

                public String transform(LabeledTimePoint node) {
                    PluginData pluginData = node.getPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting");
                    if (pluginData != null) {
                        String xCoord = pluginData.getPluginDataEntry("x");
                        return xCoord;
                    }
                    return "" + (int)layout.getX((Object)node);
                }
            });
            graphWriter.addEdgeData("Value", "Value. Format: an integer.", "", (Transformer)new Transformer<LabeledEdge, String>(){

                public String transform(LabeledEdge edge) {
                    LabeledValue value;
                    if (edge.isContingent()) {
                        if (!$assertionsDisabled && ((LabeledValueSet)edge.getValue()).getLabeledValues().size() != 1) {
                            throw new AssertionError();
                        }
                        ContingentLabeledValue value2 = (ContingentLabeledValue)((LabeledValueSet)edge.getValue()).getLabeledValues().iterator().next();
                        return "" + -value2.getContingentValue().toSeconds();
                    }
                    if (((LabeledValueSet)edge.getValue()).getLabeledValues().size() == 1 && (value = (LabeledValue)((LabeledValueSet)edge.getValue()).getLabeledValues().iterator().next()).getLabel().isEmptyLabel()) {
                        return "" + value.getValue().toSeconds();
                    }
                    return null;
                }
            });
            graphWriter.addEdgeData("Type", "Type: Possible values: normal|contingent|constraint.", "", (Transformer)new Transformer<LabeledEdge, String>(){

                public String transform(LabeledEdge edge) {
                    if (edge.isContingent()) {
                        return "contingent";
                    }
                    if (edge.isControlEdge()) {
                        return "normal";
                    }
                    return "constraint";
                }
            });
            graphWriter.addEdgeData("LabeledValues", "Labeled Values. Format: {[[\\(label,integer\\) ]+}|{}", "", (Transformer)new Transformer<LabeledEdge, String>(){

                public String transform(LabeledEdge edge) {
                    LabeledValue value;
                    if (((LabeledValueSet)edge.getValue()).getLabeledValues().size() == 1 && (value = (LabeledValue)((LabeledValueSet)edge.getValue()).getLabeledValues().iterator().next()).getLabel().isEmptyLabel()) {
                        return "{}";
                    }
                    if (edge.isContingent()) {
                        return "{}";
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append("{");
                    for (LabeledValue value2 : ((LabeledValueSet)edge.getValue()).getLabeledValues()) {
                        builder.append("(");
                        builder.append(GraphTransformation.this.convertLabel(value2.getLabel()));
                        builder.append(", ");
                        builder.append("" + value2.getValue().toSeconds());
                        builder.append(")");
                        builder.append(" ");
                    }
                    builder.append("}");
                    return builder.toString();
                }
            });
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, Charset.forName("utf8"));
            graphWriter.save(graph, (Writer)writer);
            ByteArrayInputStream stream = new ByteArrayInputStream(outputStream.toByteArray());
            return stream;
        }

        String convertLabel(Label observationLabel) {
            if (observationLabel.isEmptyLabel()) {
                return "\u22a1";
            }
            StringBuilder builder = new StringBuilder();
            Proposition proposition = (Proposition)observationLabel;
            for (ObservationBinding observation : proposition.getObservations()) {
                String string = this.convertObservationBinding(observation);
                builder.append(string);
            }
            return builder.toString();
        }

        String convertObservationBinding(ObservationBinding observation) {
            StringBuilder observationString = new StringBuilder();
            int observationID = this.nodes.get(observation.getVariable().getDecisionTimePoint());
            char observationLetter = this.nodeIDToChar(observationID);
            if (observation.getValue() == 1) {
                observationString.append("\u00ac");
            }
            observationString.append(observationLetter);
            return observationString.toString();
        }

        String convertObservation(Observation observation) {
            int observationID = this.nodes.get(observation.getDecisionTimePoint());
            char observationLetter = this.nodeIDToChar(observationID);
            return String.valueOf(observationLetter);
        }

        char nodeIDToChar(int nodeID) {
            char letter = (char)(65 + nodeID);
            return letter;
        }
    }
}

