/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.timemodel.tcn.graphml;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.tcn.IterationChain;
import de.aristaflow.adept2.model.timemodel.tcn.Label;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.NodeInstance;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.DefaultCSTNU;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultContingentLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledNode;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValue;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultLabeledValueSet;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.DefaultObservationTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Observation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.ObservationBinding;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.Proposition;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.Tuple;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMLReader2;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections15.Transformer;

public class GraphMLImport {
    private static final long FALSE_EDGE_CODE = 1L;
    private static final long TRUE_EDGE_CODE = 0L;
    private static final String LABEL_REGEXP = "\u00ac?\\p{Alpha}";
    Pattern labelSetPattern = Pattern.compile("\\(\\s*((\u00ac?\\p{Alpha})+|\u22a1)\\s*,\\s*(-?\\d+)\\s*\\)", 64);
    Pattern contingentLabelSetPattern = Pattern.compile("\\(\\s*((\u00ac?\\p{Alpha})+|\u22a1)\\s*,\\s*(\\w+)\\s*,\\s*(-?\\d+)\\s*\\)", 64);
    Pattern propositionPattern = Pattern.compile("\u00ac?\\p{Alpha}");
    private TimeModelOperations timeModelOperations;
    private TCNReader lastReader;
    private Logger logger = LoggerTools.getLogger((Object)this);

    public GraphMLImport(TimeModelOperations timeModelOperations) {
        this.timeModelOperations = timeModelOperations;
    }

    public TCN<LabeledTimePoint, LabeledEdge> getTCNFromStream(InputStream inputStream) {
        InputStreamReader fileReader = new InputStreamReader(inputStream, Charset.forName("utf8"));
        TCNReader reader = new TCNReader(fileReader);
        return reader.readTCN();
    }

    public TCN<LabeledTimePoint, LabeledEdge> getTCNFromStream(InputStream inputStream, boolean reuseReader) {
        InputStreamReader fileReader = new InputStreamReader(inputStream, Charset.forName("utf8"));
        if (!reuseReader || this.lastReader == null) {
            this.lastReader = new TCNReader(fileReader);
        } else if (reuseReader) {
            this.lastReader.init(fileReader);
        } else {
            throw new IllegalArgumentException();
        }
        return this.lastReader.readTCN();
    }

    protected class TCNReader {
        private Map<String, LabeledTimePoint> nodes = new HashMap<String, LabeledTimePoint>();
        private Map<String, DefaultObservationTimePoint> observationNodes = new HashMap<String, DefaultObservationTimePoint>();
        private final NodeInstance defaultNodeInstance;
        private Reader reader;

        public TCNReader(Reader fileReader) {
            this.init(fileReader);
            this.defaultNodeInstance = new NodeInstance(0, new IterationChain(0), 0);
        }

        public void init(Reader fileReader) {
            this.reader = fileReader;
        }

        protected TCN<LabeledTimePoint, LabeledEdge> readTCN() {
            Graph readGraph;
            Transformer<GraphMetadata, Graph<NodeMetadata, EdgeMetadata>> graphTransformer = new Transformer<GraphMetadata, Graph<NodeMetadata, EdgeMetadata>>(){

                public Graph<NodeMetadata, EdgeMetadata> transform(GraphMetadata arg0) {
                    return new DirectedSparseGraph();
                }
            };
            Transformer<NodeMetadata, NodeMetadata> vertexTransformer = new Transformer<NodeMetadata, NodeMetadata>(){

                public NodeMetadata transform(NodeMetadata arg0) {
                    return arg0;
                }
            };
            Transformer<EdgeMetadata, EdgeMetadata> edgeTransformer = new Transformer<EdgeMetadata, EdgeMetadata>(){

                public EdgeMetadata transform(EdgeMetadata arg0) {
                    return arg0;
                }
            };
            Transformer<HyperEdgeMetadata, EdgeMetadata> hyperEdgeTransformer = new Transformer<HyperEdgeMetadata, EdgeMetadata>(){

                public EdgeMetadata transform(HyperEdgeMetadata arg0) {
                    throw new RuntimeException("HyperEdges are not supported");
                }
            };
            GraphMLReader2 graphReader = new GraphMLReader2(this.reader, (Transformer)graphTransformer, (Transformer)vertexTransformer, (Transformer)edgeTransformer, (Transformer)hyperEdgeTransformer);
            try {
                readGraph = (Graph)graphReader.readGraph();
                graphReader.close();
            }
            catch (GraphIOException e) {
                throw new IllegalArgumentException("Input is not a valid graph!", e);
            }
            Collection<LabeledEdge> edges = new ArrayList<LabeledEdge>();
            ArrayDeque<NodeMetadata> queue = new ArrayDeque<NodeMetadata>(readGraph.getVertices());
            int maxIteration = queue.size() * queue.size();
            while (!queue.isEmpty() && maxIteration-- > 0) {
                NodeMetadata nodeMetadata = (NodeMetadata)queue.poll();
                LabeledTimePoint labeledNode = this.transform(nodeMetadata);
                if (labeledNode != null) continue;
                queue.offer(nodeMetadata);
            }
            if (maxIteration <= 0) {
                throw new IllegalArgumentException("Graph cannot be parsed as there seem to by cyclic dependencies between observation nodes");
            }
            for (EdgeMetadata edgeMetadata : readGraph.getEdges()) {
                LabeledEdge labeledEdge = this.transform(edgeMetadata);
                if (labeledEdge == null || labeledEdge.getSourceNode() == labeledEdge.getTargetNode()) continue;
                edges.add(labeledEdge);
            }
            HashSet<Observation> labels = new HashSet<Observation>();
            for (LabeledTimePoint node : this.nodes.values()) {
                if (!(node instanceof DefaultObservationTimePoint)) continue;
                labels.add(((DefaultObservationTimePoint)node).getObservation());
            }
            edges = this.processContingentDurationConstraints(edges);
            DefaultCSTNU cstnu = new DefaultCSTNU(this.nodes.values(), edges, labels);
            return cstnu;
        }

        protected Collection<LabeledEdge> processContingentDurationConstraints(Collection<LabeledEdge> edges) {
            HashMap<Tuple, Object> edgeMap = new HashMap<Tuple, Object>();
            for (LabeledEdge edge : edges) {
                edgeMap.put(new Tuple((Object)((LabeledTimePoint)edge.getSourceNode()), (Object)((LabeledTimePoint)edge.getTargetNode())), edge);
            }
            for (LabeledEdge edge : edges) {
                LabeledEdge opEdge;
                ContingentLabeledValue value;
                if (!edge.isContingentDuration() || !(value = this.getContingentLabeledValue(edge)).getValue().equals(DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE) || (opEdge = (LabeledEdge)edgeMap.get(new Tuple((Object)((LabeledTimePoint)edge.getTargetNode()), (Object)((LabeledTimePoint)edge.getSourceNode())))) == null || !opEdge.isContingentDuration()) continue;
                ContingentLabeledValue otherValue = this.getContingentLabeledValue(opEdge);
                DefaultContingentLabeledValue newValue = new DefaultContingentLabeledValue(value.getLabel(), value.getCase(), otherValue.getContingentValue().neg(), value.getTrigger(), value.getContingentValue());
                edgeMap.put(new Tuple((Object)((LabeledTimePoint)edge.getSourceNode()), (Object)((LabeledTimePoint)edge.getTargetNode())), new DefaultLabeledEdge((LabeledTimePoint)edge.getSourceNode(), (LabeledTimePoint)edge.getTargetNode(), (LabeledValueSet)new DefaultLabeledValueSet(new LabeledValue[]{newValue}), edge.isControlEdge(), edge.isImplicit(), edge.getFlowDirection()));
            }
            return edgeMap.values();
        }

        private ContingentLabeledValue getContingentLabeledValue(LabeledEdge edge) {
            Collection labeledValues = ((LabeledValueSet)edge.getValue()).getLabeledValues();
            assert (labeledValues.size() == 1);
            LabeledValue labeledValue = (LabeledValue)labeledValues.iterator().next();
            assert (labeledValue instanceof ContingentLabeledValue);
            return (ContingentLabeledValue)labeledValue;
        }

        public LabeledTimePoint transform(NodeMetadata metadata) {
            LabeledTimePoint previousNode;
            DefaultLabeledNode node;
            Proposition labels;
            String nodeID = metadata.getId();
            String obs = metadata.getProperty("Obs");
            String lbl = metadata.getProperty("Label");
            String xCoord = metadata.getProperty("x");
            String yCoord = metadata.getProperty("y");
            if (lbl == null || lbl.length() == 0 || lbl.equals("\u22a1")) {
                labels = Proposition.EMPTY_PROPOSITION;
            } else {
                Proposition prop = this.parseLabel(lbl);
                if (prop == null) {
                    return null;
                }
                labels = prop;
            }
            if (obs != null && obs.length() > 0) {
                long[] lArray = new long[2];
                lArray[1] = 1L;
                long[] edgeCodes = lArray;
                int[] nArray = new int[2];
                nArray[1] = 1;
                int[] observationIDs = nArray;
                node = new DefaultObservationTimePoint(this.defaultNodeInstance, nodeID, (Label)labels, edgeCodes, observationIDs);
                this.observationNodes.put(obs.trim(), (DefaultObservationTimePoint)node);
            } else {
                node = new DefaultLabeledNode(this.defaultNodeInstance, nodeID, (Label)labels);
            }
            if (xCoord != null && xCoord.length() > 0 && yCoord != null && yCoord.length() > 0) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                int x = (int)Double.parseDouble(xCoord);
                int y = (int)Double.parseDouble(yCoord);
                attributes.put("x", Integer.toString(x));
                attributes.put("y", Integer.toString(y));
                ((DefaultPluginDataContainer)node).addSupportedPlugin("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", "de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", (PluginData)new DefaultPluginData("de.uniulm.dbis.aristaflow.time.ui.cstnueditor.common.CSTNULayouting", attributes));
            }
            if ((previousNode = this.nodes.get(this.getInternalNodeID(nodeID))) != null) {
                if (!previousNode.equals(node)) {
                    throw new IllegalStateException("Found duplicate node which is note same! Are you re-using TCN Reader on non-fitting CSTNUs?");
                }
                node = previousNode;
            } else {
                this.nodes.put(this.getInternalNodeID(nodeID), (LabeledTimePoint)node);
            }
            return node;
        }

        public LabeledEdge transform(EdgeMetadata metadata) {
            List<LabeledValue> labeledValues;
            LabeledTimePoint sourceNode = this.nodes.get(this.getInternalNodeID(metadata.getSource()));
            LabeledTimePoint targetNode = this.nodes.get(this.getInternalNodeID(metadata.getTarget()));
            TCNEdge.FlowDirection flowDirection = TCNEdge.FlowDirection.UNKOWN;
            String type = metadata.getProperty("Type");
            boolean contingentDuration = type != null && type.trim().equals("contingent");
            boolean controledge = type == null || type.trim().equals("normal");
            boolean implicit = type != null && type.trim().equals("derived");
            ArrayList<Object> values = new ArrayList<Object>();
            String simpleValue = metadata.getProperty("Value");
            String complexValue = metadata.getProperty("LabeledValues");
            String contingentValues = metadata.getProperty("UpperCaseLabeledValues");
            if (contingentDuration) {
                LabeledTimePoint temp = sourceNode;
                sourceNode = targetNode;
                targetNode = temp;
            }
            if (complexValue != null && complexValue.length() > 0 && !complexValue.trim().equals("{}") && !contingentDuration) {
                labeledValues = this.parseLabeledValues(complexValue);
                assert (!contingentDuration || labeledValues.size() == 1 && labeledValues.get(0).getLabel().isEmptyLabel()) : "Trouble with " + complexValue;
                assert (labeledValues != null);
                if (!contingentDuration) {
                    values.addAll(labeledValues);
                }
            }
            if (contingentValues != null && contingentValues.length() > 0 && !contingentValues.trim().equals("{}") && !contingentDuration) {
                labeledValues = this.parseContingentLabeledValues(contingentValues);
                assert (labeledValues != null) : "Trouble parsing " + contingentValues;
                values.addAll(labeledValues);
            }
            if (simpleValue != null && simpleValue.length() > 0) {
                DefaultLabeledValue labeledValue;
                long seconds = Long.parseLong(simpleValue);
                TimeDistance timeDistance = GraphMLImport.this.timeModelOperations.secondsToTimeDistance(seconds);
                Label label = sourceNode.getLabel().merge(targetNode.getLabel());
                if (contingentDuration) {
                    ContingentLabeledValue.ConstraintCase constraintCase = timeDistance.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) < 0 ? ContingentLabeledValue.ConstraintCase.LOWERCASE : ContingentLabeledValue.ConstraintCase.UPPERCASE;
                    LabeledTimePoint trigger = constraintCase.equals((Object)ContingentLabeledValue.ConstraintCase.LOWERCASE) ? targetNode : sourceNode;
                    labeledValue = new DefaultContingentLabeledValue(label, constraintCase, DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE, trigger, timeDistance.neg());
                    flowDirection = constraintCase.equals((Object)ContingentLabeledValue.ConstraintCase.LOWERCASE) ? TCNEdge.FlowDirection.FORWARD : TCNEdge.FlowDirection.BACKWARD;
                } else {
                    flowDirection = timeDistance.compareTo(DefaultTimeDistance.ZERO_TIME_DISTANCE) > 0 ? TCNEdge.FlowDirection.FORWARD : TCNEdge.FlowDirection.UNKOWN;
                    labeledValue = new DefaultLabeledValue(label, timeDistance);
                }
                values.add(labeledValue);
            }
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                LabeledValue labeledValue = (LabeledValue)iterator.next();
                if (!labeledValue.getLabel().satisfiable(sourceNode.getLabel()) || !labeledValue.getLabel().satisfiable(targetNode.getLabel())) {
                    GraphMLImport.this.logger.severe(String.format("Ignoring illegal value '%s' because edge label is not satisfiable in combination with respective nodes labels '%s:%s'-'%s:%s'!", labeledValue, sourceNode, sourceNode.getLabel(), targetNode, targetNode.getLabel()));
                    iterator.remove();
                    continue;
                }
                if (labeledValue.getLabel().subsumes(sourceNode.getLabel()) && labeledValue.getLabel().subsumes(targetNode.getLabel())) continue;
                GraphMLImport.this.logger.warning(String.format("Ignoring illegal value '%s' because label does not subsume respective nodes labels '%s:%s'-'%s:%s'!", labeledValue, sourceNode, sourceNode.getLabel(), targetNode, targetNode.getLabel()));
                iterator.remove();
            }
            if (values.isEmpty()) {
                return null;
            }
            HashMap compressedValues = new HashMap();
            for (LabeledValue labeledValue : values) {
                DefaultLabeledValueSet.addOrReplaceIfNecessary(compressedValues, (LabeledValue)labeledValue);
            }
            DefaultLabeledValueSet defaultLabeledValueSet = new DefaultLabeledValueSet(compressedValues.values());
            return new DefaultLabeledEdge(sourceNode, targetNode, (LabeledValueSet)defaultLabeledValueSet, controledge, implicit, flowDirection);
        }

        protected Proposition parseLabel(String lbl) {
            ArrayList<ObservationBinding> observations = new ArrayList<ObservationBinding>();
            Matcher labelMatcher = GraphMLImport.this.propositionPattern.matcher(lbl);
            while (labelMatcher.find()) {
                String observationID;
                String letter = labelMatcher.group(0);
                boolean negative = false;
                if (letter.length() == 2) {
                    observationID = "" + letter.charAt(1);
                    negative = true;
                } else {
                    observationID = "" + letter.charAt(0);
                    negative = false;
                }
                DefaultObservationTimePoint observationNode = this.observationNodes.get(observationID);
                if (observationNode == null) {
                    return null;
                }
                ObservationBinding observation = (ObservationBinding)observationNode.getEdgeCodeMapping().get(negative ? 1L : 0L);
                observations.add(observation);
            }
            if (observations.isEmpty()) {
                return Proposition.EMPTY_PROPOSITION;
            }
            return new Proposition(observations);
        }

        protected String getInternalNodeID(String nodeID) {
            String n = nodeID;
            if (n.endsWith("?")) {
                n = n.substring(0, n.length() - 1);
            }
            return n.toUpperCase();
        }

        protected List<LabeledValue> parseLabeledValues(String complexValue) {
            Matcher labelSetMatcher = GraphMLImport.this.labelSetPattern.matcher(complexValue);
            ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
            while (labelSetMatcher.find()) {
                String label = labelSetMatcher.group(1);
                Proposition proposition = this.parseLabel(label);
                String valueString = labelSetMatcher.group(3);
                long seconds = Long.parseLong(valueString);
                TimeDistance timeDistance = GraphMLImport.this.timeModelOperations.secondsToTimeDistance(seconds);
                DefaultLabeledValue labeledValue = new DefaultLabeledValue((Label)proposition, timeDistance);
                values.add((LabeledValue)labeledValue);
            }
            if (values.isEmpty()) {
                return null;
            }
            return values;
        }

        protected List<LabeledValue> parseContingentLabeledValues(String complexValue) {
            Matcher labelSetMatcher = GraphMLImport.this.contingentLabelSetPattern.matcher(complexValue);
            ArrayList<LabeledValue> values = new ArrayList<LabeledValue>();
            while (labelSetMatcher.find()) {
                String label = labelSetMatcher.group(1);
                Proposition proposition = this.parseLabel(label);
                String letter = labelSetMatcher.group(3);
                LabeledTimePoint triggerNode = this.nodes.get(this.getInternalNodeID(letter));
                String valueString = labelSetMatcher.group(4);
                long seconds = Long.parseLong(valueString);
                TimeDistance timeDistance = GraphMLImport.this.timeModelOperations.secondsToTimeDistance(seconds);
                DefaultContingentLabeledValue labeledValue = new DefaultContingentLabeledValue((Label)proposition, ContingentLabeledValue.ConstraintCase.UPPERCASE, DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE, triggerNode, timeDistance);
                values.add((LabeledValue)labeledValue);
            }
            if (values.isEmpty()) {
                return null;
            }
            return values;
        }
    }
}

