/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview;

import de.aristaflow.adept2.ui.loggerview.Timer;
import de.aristaflow.adept2.ui.loggerview.views.LoggerView;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerViewHandler
extends Handler {
    private static final int updateInterval = 200;
    private LoggerView view;
    private static final int QUEUE_SIZE = 500;
    private Timer timer;
    private List<LogRecord> recordQueue = new ArrayList<LogRecord>(50);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerViewHandler() {
        LogManager manager = LogManager.getLogManager();
        manager.getLogger("").setLevel(Level.INFO);
        this.setLevel(Level.ALL);
        this.setFilter(null);
        List<LogRecord> list = this.recordQueue;
        synchronized (list) {
            this.timer = new Timer(200L, this);
            Logger rootLogger = Logger.getLogger("");
            rootLogger.addHandler(this);
        }
    }

    public void timerFired() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        record.getSourceClassName();
        List<LogRecord> list = this.recordQueue;
        synchronized (list) {
            this.timer.restartTimer();
            this.recordQueue.add(record);
        }
        if (this.recordQueue.size() > 50) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        List<LogRecord> list = this.recordQueue;
        synchronized (list) {
            if (this.view != null) {
                this.view.publish(this.recordQueue.toArray(new LogRecord[this.recordQueue.size()]));
                this.timer.stopTimer();
                this.recordQueue.clear();
            }
            int index = 0;
            while (this.recordQueue.size() >= 500) {
                Level level = this.recordQueue.get(index).getLevel();
                if (level.equals(Level.WARNING) || level.equals(Level.SEVERE)) {
                    if (index >= this.recordQueue.size() - 1) {
                        this.recordQueue.remove(0);
                        --index;
                        continue;
                    }
                    ++index;
                    continue;
                }
                this.recordQueue.remove(index);
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        Logger.getLogger("").removeHandler(this);
        this.flush();
        this.timer.stopTimer();
        this.timer.interrupt();
        this.timer = null;
        this.recordQueue.clear();
        this.recordQueue = null;
    }

    public void setLoggerView(LoggerView view) {
        this.view = view;
        this.flush();
    }

    public static String formatLogRecord(LogRecord logRecord) {
        StringBuilder writer = new StringBuilder();
        writer.append("Log Message Details:\n");
        writer.append("Date: ");
        Date date = new Date(logRecord.getMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SS");
        writer.append(formatter.format(date));
        writer.append("\nSeverity: ");
        writer.append(logRecord.getLevel().toString());
        writer.append("\nLogger Name: ");
        writer.append(logRecord.getLoggerName());
        writer.append("\nSource: ");
        writer.append(logRecord.getSourceClassName());
        writer.append("#");
        writer.append(logRecord.getSourceMethodName());
        writer.append("\n\nMessage:\n");
        writer.append(logRecord.getMessage());
        writer.append("\n\n\nStack Trace:\n");
        Throwable stack = logRecord.getThrown();
        if (stack != null) {
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            stack.printStackTrace(pwriter);
            pwriter.flush();
            pwriter.close();
            writer.append(swriter.toString());
        } else {
            writer.append("No exception was thrown.");
        }
        writer.append("\n\nParameters:\n");
        Object[] parameters = logRecord.getParameters();
        if (parameters != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                writer.append(i + 1);
                writer.append(": ");
                writer.append(parameters[i]);
                writer.append("\n");
                ++i;
            }
        } else {
            writer.append("No Parameters given!");
        }
        return writer.toString();
    }
}

