/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview;

import de.aristaflow.adept2.ui.loggerview.LoggerViewHandler;

public class Timer
extends Thread {
    private final LoggerViewHandler listener;
    private final long updateInterval;
    final Object lock = new Object();
    private long nextEvent = 0L;
    protected boolean running = false;

    public Timer(long updateInterval, LoggerViewHandler listener) {
        super("LoggerViewTimer");
        this.updateInterval = updateInterval;
        this.listener = listener;
        this.running = false;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Timer.interrupted()) {
            boolean eventExpired = false;
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.running && !this.isInterrupted()) {
                        this.lock.wait();
                    }
                    if (Timer.interrupted()) {
                        break;
                    }
                    long currentTimeMillis = System.currentTimeMillis();
                    boolean bl = eventExpired = this.nextEvent < currentTimeMillis;
                    if (eventExpired) {
                        this.running = false;
                    } else {
                        this.lock.wait(this.nextEvent - currentTimeMillis);
                    }
                }
                if (!eventExpired) continue;
                this.listener.timerFired();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        Object object = this.lock;
        synchronized (object) {
            this.nextEvent = System.currentTimeMillis() + this.updateInterval;
            this.running = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
    }

    public void restartTimer() {
        this.stopTimer();
        this.startTimer();
    }
}

