/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview.views;

import de.aristaflow.adept2.ui.loggerview.Activator;
import de.aristaflow.adept2.ui.loggerview.LoggerViewHandler;
import de.aristaflow.adept2.ui.loggerview.views.LoggerViewFilter;
import de.aristaflow.adept2.ui.loggerview.views.LoggerViewFilterDialog;
import de.aristaflow.adept2.ui.loggerview.views.LoggerViewLabelProvider;
import de.aristaflow.adept2.ui.loggerview.views.MessageDetailsDialogAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class LoggerView
extends ViewPart
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener,
IPropertyChangeListener {
    public static final String ID = "de.aristaflow.adept2.ui.loggerview.views.LoggerView";
    public static final String ROOT_LOGGER = "";
    protected TableViewer viewer;
    private Table table;
    private Label infoLine;
    static final String[] column_names = new String[]{"Message", "Logger", "Time", "Level"};
    static final int[] column_size = new int[]{400, 200, 100, 50};
    protected int[] column_order = new int[column_names.length];
    protected int sort_column;
    boolean scrollLock;
    protected Comparator<LogRecord> currentComparator;
    private Clipboard clipboard;
    protected LoggerViewHandler handler;
    static int maxEntryCount = 2000;
    protected final List<LogRecord> logContent = new ArrayList<LogRecord>(maxEntryCount);
    private Action filtersAction;
    Action clearAction;
    Action copyAction;
    Action preferences;
    private Action scrollLockAction;
    protected MessageDetailsDialogAction messageDetailsAction;
    protected int totalCount = 0;
    protected int severeCount = 0;
    protected int warningCount = 0;
    protected int infoCount = 0;
    List<ViewerFilter> filters;
    private IMemento memento;
    private Comparator<?>[] comparators;
    private static final String P_WIDTH = "width_";
    private static final String P_ORDER = "sortColumn";
    private static final String P_FILTER = "filters";

    public LoggerView() {
        this.handler = Activator.getDefault().getHandler();
        this.filters = new ArrayList<ViewerFilter>();
    }

    public void dispose() {
        super.dispose();
        this.handler.setLoggerView(null);
        this.clipboard.dispose();
        this.clipboard = null;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.loadPrefSettings();
        this.restoreState();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createInfoLine(composite);
        this.createTable(composite);
        this.initializeViewer();
        this.updateFilters();
        this.clipboard = new Clipboard(this.table.getDisplay());
        this.makeActions();
        this.contributeToActionBars();
        this.updateInfoLine();
        this.memento = null;
        this.handler.setLoggerView(this);
    }

    private void initializeViewer() {
        this.viewer.setContentProvider((IContentProvider)new LoggerViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LoggerViewLabelProvider());
        this.viewer.setInput(this.logContent);
        this.initializeViewerSorter();
    }

    private void initializeViewerSorter() {
        if (this.comparators == null) {
            this.createComparators();
        }
        this.currentComparator = this.comparators[this.sort_column];
        ViewerSorter sorter = this.getViewerSorter(this.currentComparator);
        this.viewer.setSorter(sorter);
        this.table.setSortColumn(this.table.getColumn(this.sort_column));
        this.table.setSortDirection(this.column_order[this.sort_column] == 1 ? 128 : 1024);
    }

    private void createInfoLine(Composite composite) {
        this.infoLine = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = 15;
        this.infoLine.setLayoutData((Object)gridData);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.handleSelectionChanged(event.getSelection());
        if (this.messageDetailsAction.isEnabled()) {
            this.messageDetailsAction.resetSelection();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.messageDetailsAction.setComparator(this.currentComparator);
        this.messageDetailsAction.run();
    }

    protected void handleSelectionChanged(ISelection selection) {
        this.messageDetailsAction.setEnabled(!selection.isEmpty());
        this.copyAction.setEnabled(!selection.isEmpty());
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 770);
        String[] stringArray = column_names;
        int n = column_names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            TableColumn tc = new TableColumn(this.table, 16384);
            tc.setText(name);
            tc.setWidth(this.memento.getInteger(P_WIDTH + name).intValue());
            tc.addSelectionListener((SelectionListener)this);
            ++n2;
        }
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(this.table);
        this.viewer.setColumnProperties(column_names);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (!(e.getSource() instanceof TableColumn)) {
            return;
        }
        int index = this.getColumnIndex((TableColumn)e.getSource());
        if (this.sort_column == index) {
            int n = this.sort_column;
            this.column_order[n] = this.column_order[n] * -1;
        } else {
            this.sort_column = index;
        }
        this.initializeViewerSorter();
        this.messageDetailsAction.setComparator(this.currentComparator);
    }

    private int getColumnIndex(TableColumn column) {
        int i = 0;
        while (i < column_names.length) {
            if (column_names[i].equals(column.getText())) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Cannot find column index. Programming error.");
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.filtersAction);
        manager.add((IAction)this.scrollLockAction);
        manager.add((IAction)this.preferences);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filtersAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.filtersAction = new Action("Configure filters", Activator.getImageDescriptor("icons/filter_ps.gif")){

            public void run() {
                LoggerView.this.showFilterDialog(LoggerView.this.getSite().getShell());
            }
        };
        this.filtersAction.setToolTipText("Filters...");
        this.clearAction = new Action("Clear log", Activator.getImageDescriptor("icons/delete_edit.gif")){

            public void run() {
                LoggerView.this.clear();
            }
        };
        this.clearAction.setToolTipText("Removes all entries in the log");
        this.copyAction = new Action("Copy", Activator.getImageDescriptor("icons/event_copy.gif")){

            public void run() {
                if (LoggerView.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                LogRecord entry = (LogRecord)((IStructuredSelection)LoggerView.this.viewer.getSelection()).getFirstElement();
                LoggerView.this.copyToClipboard(entry);
            }
        };
        this.copyAction.setToolTipText("Copy to Clipboard");
        this.copyAction.setEnabled(false);
        this.preferences = new Action("Preferences"){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)LoggerView.this.getSite().getShell(), (String)"de.aristaflow.adept2.ui.loggerview.preferences.LoggerViewPreferencesPage", null, null);
                dialog.open();
            }
        };
        this.preferences.setToolTipText("Set the Preferences");
        this.messageDetailsAction = new MessageDetailsDialogAction(this.getSite().getShell(), (ISelectionProvider)this.viewer, this.currentComparator);
        this.messageDetailsAction.setImageDescriptor(Activator.getImageDescriptor("icons/properties.gif"));
        this.messageDetailsAction.setEnabled(false);
        this.scrollLockAction = new Action("Scroll Lock"){

            public void run() {
                LoggerView.this.scrollLock = this.isChecked();
                Activator.getDefault().getPluginPreferences().setValue("scrollLock", this.isChecked());
            }
        };
        this.scrollLockAction.setChecked(this.scrollLock);
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)LoggerView.this.copyAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)LoggerView.this.clearAction);
                manager.add((IContributionItem)new Separator());
                LoggerView.this.messageDetailsAction.setComparator(LoggerView.this.currentComparator);
                manager.add((IAction)LoggerView.this.messageDetailsAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        };
        MenuManager popupMenuManager = new MenuManager("de.aristaflow.adept2.ui.loggerview.views.LoggerView#PopupMenu");
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(popupMenuManager, this.getSite().getSelectionProvider());
        Menu menu = popupMenuManager.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    protected void copyToClipboard(LogRecord entry) {
        String textVersion = LoggerViewHandler.formatLogRecord(entry);
        if (textVersion.trim().length() > 0) {
            this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void createComparators() {
        this.comparators = new Comparator[column_names.length];
        this.comparators[0] = new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord r2, LogRecord r1) {
                return LoggerView.this.column_order[0] * r1.getMessage().compareTo(r2.getMessage());
            }
        };
        this.comparators[1] = new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord r2, LogRecord r1) {
                return LoggerView.this.column_order[1] * r1.getLoggerName().compareTo(r2.getLoggerName());
            }
        };
        this.comparators[2] = new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord r2, LogRecord r1) {
                return LoggerView.this.column_order[2] * Long.signum(r1.getMillis() - r2.getMillis());
            }
        };
        this.comparators[3] = new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord r2, LogRecord r1) {
                return LoggerView.this.column_order[3] * (r1.getLevel().intValue() - r2.getLevel().intValue());
            }
        };
    }

    protected ViewerSorter getViewerSorter(final Comparator<LogRecord> comparator) {
        if (comparator == null) {
            return null;
        }
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                return comparator.compare((LogRecord)o1, (LogRecord)o2);
            }
        };
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void publish(final LogRecord[] records) {
        if (records == null || records.length == 0) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LoggerView.this.viewer.getControl().isDisposed()) {
                    return;
                }
                LoggerView.this.viewer.add((Object[])records);
                LogRecord[] logRecordArray = records;
                int n = records.length;
                int n2 = 0;
                while (n2 < n) {
                    LogRecord record = logRecordArray[n2];
                    LoggerView.this.logContent.add(record);
                    if (record.getLevel().equals(Level.SEVERE)) {
                        ++LoggerView.this.severeCount;
                    } else if (record.getLevel().equals(Level.WARNING)) {
                        ++LoggerView.this.warningCount;
                    } else if (record.getLevel().equals(Level.INFO)) {
                        ++LoggerView.this.infoCount;
                    }
                    ++n2;
                }
                LoggerView.this.totalCount += records.length;
                if (LoggerView.this.logContent.size() > maxEntryCount && maxEntryCount > 0) {
                    HashSet<LogRecord> recordsToBeRemoved = new HashSet<LogRecord>();
                    int i = 0;
                    while (LoggerView.this.logContent.size() > maxEntryCount) {
                        Level level = LoggerView.this.logContent.get(i).getLevel();
                        if (level.equals(Level.WARNING) || level.equals(Level.SEVERE)) {
                            if (i >= LoggerView.this.logContent.size() - 1) {
                                LogRecord rec = LoggerView.this.logContent.remove(0);
                                --i;
                                recordsToBeRemoved.add(rec);
                                if (rec.getLevel().equals(Level.SEVERE)) {
                                    --LoggerView.this.severeCount;
                                    continue;
                                }
                                if (!rec.getLevel().equals(Level.WARNING)) continue;
                                --LoggerView.this.warningCount;
                                continue;
                            }
                            ++i;
                            continue;
                        }
                        recordsToBeRemoved.add(LoggerView.this.logContent.remove(i));
                        if (level.equals(Level.INFO)) {
                            --LoggerView.this.infoCount;
                        }
                        if (i < LoggerView.this.logContent.size() - 1) continue;
                        --i;
                    }
                    LoggerView.this.viewer.remove(recordsToBeRemoved.toArray());
                }
                if (LoggerView.this.sort_column == 2 && !LoggerView.this.scrollLock) {
                    LoggerView.this.viewer.reveal((Object)records[records.length - 1]);
                }
                LoggerView.this.updateInfoLine();
                LoggerView.this.messageDetailsAction.resetDialogButtons();
                LoggerView.this.messageDetailsAction.resetSelection();
            }
        });
    }

    protected void updateInfoLine() {
        this.infoLine.setText(String.format("%d severe, %d warnings, %d info, (Filter matched %d of %d items) (%d items logged totally)", this.severeCount, this.warningCount, this.infoCount, this.viewer.getTable().getItemCount(), this.logContent.size(), this.totalCount));
    }

    protected void clear() {
        this.logContent.clear();
        this.viewer.refresh();
        this.severeCount = 0;
        this.warningCount = 0;
        this.infoCount = 0;
        this.updateInfoLine();
        this.messageDetailsAction.resetDialogButtons();
        this.messageDetailsAction.resetSelection();
    }

    private void updateFilters() {
        if (this.viewer != null) {
            this.viewer.resetFilters();
            for (ViewerFilter f : this.filters) {
                this.viewer.addFilter(f);
            }
        }
    }

    public void showFilterDialog(Shell shell) {
        try {
            LoggerViewFilterDialog dialog = new LoggerViewFilterDialog(shell);
            dialog.setFilter(this.filters);
            if (dialog.open() == 0) {
                this.filters = dialog.getFilters();
                this.updateFilters();
                this.updateInfoLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPrefSettings() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        maxEntryCount = preferenceStore.getBoolean("entryLimitEnabled") ? preferenceStore.getInt("entryLimit") : -1;
        this.scrollLock = preferenceStore.getBoolean("scrollLock");
        if (this.scrollLockAction != null) {
            this.scrollLockAction.setChecked(this.scrollLock);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("entryLimitEnabled") || event.getProperty().equals("entryLimit") || event.getProperty().equals("scrollLock")) {
            this.loadPrefSettings();
        }
    }

    public void saveState(IMemento state) {
        if (state == null) {
            return;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"LOGGERVIEW");
        this.saveLayout((IMemento)memento);
        this.saveViewerSorting((IMemento)memento);
        this.saveFilterSettings((IMemento)memento);
        state.putMemento((IMemento)memento);
    }

    private void restoreState() {
        this.memento = this.initializeMemento(this.memento);
        this.restoreViewerSorting(this.memento);
        this.restoreFilters(this.memento);
    }

    private void saveLayout(IMemento memento) {
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            memento.putInteger(P_WIDTH + column.getText(), column.getWidth());
            ++n2;
        }
    }

    private IMemento initializeMemento(IMemento config) {
        IMemento memento = config;
        if (memento == null) {
            memento = XMLMemento.createWriteRoot((String)"LOGGERVIEW");
        }
        int i = 0;
        while (i < column_names.length) {
            Integer order;
            Integer width = memento.getInteger(P_WIDTH + column_names[i]);
            if (width == null || width <= 0) {
                memento.putInteger(P_WIDTH + column_names[i], column_size[i]);
            }
            if ((order = memento.getInteger(P_ORDER + column_names[i])) == null || order != 1 && order != -1) {
                memento.putInteger(P_ORDER + column_names[i], 1);
            }
            ++i;
        }
        Integer orderType = memento.getInteger(P_ORDER);
        if (orderType == null) {
            memento.putInteger(P_ORDER, 2);
        }
        return memento;
    }

    private void restoreViewerSorting(IMemento memento) {
        this.sort_column = memento.getInteger(P_ORDER);
        int i = 0;
        while (i < column_names.length) {
            this.column_order[i] = memento.getInteger(P_ORDER + column_names[i]);
            ++i;
        }
    }

    private void saveViewerSorting(IMemento memento) {
        memento.putInteger(P_ORDER, this.sort_column);
        int i = 0;
        while (i < column_names.length) {
            memento.putInteger(P_ORDER + column_names[i], this.column_order[i]);
            ++i;
        }
    }

    private void restoreFilters(IMemento memento) {
        IMemento[] filterMementos = memento.getChildren(P_FILTER);
        if (filterMementos != null && filterMementos.length > 0) {
            IMemento[] iMementoArray = filterMementos;
            int n = filterMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mm = iMementoArray[n2];
                LoggerViewFilter filter = LoggerViewFilter.readFilter(mm);
                if (filter != null) {
                    this.filters.add(filter);
                }
                ++n2;
            }
        }
        if (this.filters.size() == 0) {
            ViewerFilter filter = this.createDefaultFilter();
            this.filters.add(filter);
        }
    }

    protected ViewerFilter createDefaultFilter() {
        return new LoggerViewFilter("DEFAULT");
    }

    private void saveFilterSettings(IMemento memento) {
        for (ViewerFilter f : this.filters) {
            IMemento filterMemento = memento.createChild(P_FILTER);
            ((LoggerViewFilter)f).saveState(filterMemento);
        }
    }

    class LoggerViewContentProvider
    implements IStructuredContentProvider {
        LoggerViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return LoggerView.this.logContent.toArray();
        }

        public int getElementCount() {
            return LoggerView.this.logContent.size();
        }
    }
}

