/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;

public class LoggerViewFilter
extends ViewerFilter
implements IPersistable {
    private static final String P_NAME = "name";
    private static final String P_ACTIVE = "active";
    private static final String P_INCLUSIVE = "containsPositive";
    private static final String P_SUBSTRING = "contains";
    private static final String P_LEVEL = "level";
    private static final String P_DISABLED_LOGGERS = "disabledLoggers";
    private static final String P_LOGGER_DELIMITER = ";";
    private String name;
    private Level level = Level.ALL;
    private boolean active = true;
    private boolean inclusive = true;
    private String substringMatch = "";
    private Set<String> disabledLoggers = new HashSet<String>();

    public LoggerViewFilter(String name) {
        this.name = name;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.active) {
            return true;
        }
        if (element instanceof LogRecord) {
            LogRecord record = (LogRecord)element;
            if (record.getLevel().intValue() < this.level.intValue()) {
                return false;
            }
            if (this.substringMatch != null && !this.substringMatch.equals("") && (!record.getMessage().contains(this.substringMatch) ? this.inclusive : !this.inclusive)) {
                return false;
            }
            return !this.disabledLoggers.contains(record.getLoggerName());
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSubstringMatch(String s) {
        this.substringMatch = s;
    }

    public String getSubstringMatch() {
        return this.substringMatch;
    }

    protected boolean isInclusive() {
        return this.inclusive;
    }

    protected void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public void enableLogger(String path) {
        this.disabledLoggers.remove(path);
    }

    public void disableLogger(String path) {
        this.disabledLoggers.add(path);
    }

    public Set<String> getDisabledLoggers() {
        return Collections.unmodifiableSet(this.disabledLoggers);
    }

    public void saveState(IMemento memento) {
        memento.putString(P_NAME, this.name);
        memento.putString(P_ACTIVE, Boolean.toString(this.active));
        memento.putString(P_SUBSTRING, this.substringMatch);
        memento.putString(P_INCLUSIVE, Boolean.toString(this.inclusive));
        memento.putInteger(P_LEVEL, this.level.intValue());
        StringBuilder disabledFilters = new StringBuilder();
        for (String s : this.disabledLoggers) {
            disabledFilters.append(s);
            disabledFilters.append(P_LOGGER_DELIMITER);
        }
        memento.putString(P_DISABLED_LOGGERS, disabledFilters.toString());
    }

    public static LoggerViewFilter readFilter(IMemento mm) {
        String name = mm.getString(P_NAME);
        if (name == null) {
            return null;
        }
        try {
            Integer level;
            LoggerViewFilter filter = new LoggerViewFilter(name);
            String active = mm.getString(P_ACTIVE);
            if (active != null) {
                filter.active = Boolean.parseBoolean(active);
            }
            filter.substringMatch = mm.getString(P_SUBSTRING);
            String containsPositive = mm.getString(P_INCLUSIVE);
            if (containsPositive != null) {
                filter.inclusive = Boolean.parseBoolean(containsPositive);
            }
            filter.level = (level = mm.getInteger(P_LEVEL)) != null ? Level.parse(level.toString()) : Level.ALL;
            String disabledLoggers = mm.getString(P_DISABLED_LOGGERS);
            if (disabledLoggers != null && disabledLoggers.length() > 0) {
                String[] stringArray = disabledLoggers.split(P_LOGGER_DELIMITER);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    filter.disabledLoggers.add(s);
                    ++n2;
                }
            }
            return filter;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getName() {
        return this.name;
    }
}

