/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview.views;

import de.aristaflow.adept2.ui.loggerview.views.LoggerViewFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class LoggerViewFilterDialog
extends Dialog {
    protected Shell shell;
    private Button allLevel;
    private Button severeLevel;
    private Button warningLevel;
    private Button infoLevel;
    private Button fineLevel;
    private Button finerLevel;
    private Button finestLevel;
    protected CheckboxTableViewer filterViewer;
    private Composite patternArea;
    private Text contains;
    private Combo containsPositive;
    private Composite loggerArea;
    protected CheckboxTreeViewer loggerTree;
    protected List<LoggerViewFilter> filters = null;
    private LoggerViewFilter currentFilter;
    protected int result = 1;

    protected LoggerViewFilterDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    public void setFilter(List filters) {
        this.filters = new ArrayList<LoggerViewFilter>(filters);
    }

    public List<?> getFilters() {
        return this.filters;
    }

    public int open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67616);
        this.shell.setText("Configure Filters");
        this.shell.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this.shell, 0);
        this.createContent(composite);
        this.shell.pack();
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void updateFromFilters() {
        if (this.filters.size() == 0) {
            this.filters.add(this.createDefaultFilter());
        }
        this.filterViewer.setInput(this.filters);
        for (LoggerViewFilter f : this.filters) {
            this.filterViewer.setChecked((Object)f, f.isActive());
        }
        try {
            if (this.filters.size() > 0) {
                this.filterViewer.setSelection((ISelection)new StructuredSelection((Object)this.filters.get(0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateFilterView(ViewerFilter filter) {
        this.currentFilter = (LoggerViewFilter)filter;
        if (this.currentFilter != null) {
            this.patternArea.setEnabled(true);
            this.loggerArea.setEnabled(true);
            this.allLevel.setSelection(this.currentFilter.getLevel().equals(Level.ALL));
            this.severeLevel.setSelection(this.currentFilter.getLevel().equals(Level.SEVERE));
            this.warningLevel.setSelection(this.currentFilter.getLevel().equals(Level.WARNING));
            this.infoLevel.setSelection(this.currentFilter.getLevel().equals(Level.INFO));
            this.fineLevel.setSelection(this.currentFilter.getLevel().equals(Level.FINE));
            this.finerLevel.setSelection(this.currentFilter.getLevel().equals(Level.FINER));
            this.finestLevel.setSelection(this.currentFilter.getLevel().equals(Level.FINEST));
            this.contains.setText(this.currentFilter.getSubstringMatch());
            this.containsPositive.select(this.currentFilter.isInclusive() ? 0 : 1);
            this.updateLoggers(this.currentFilter.getDisabledLoggers(), this.loggerTree.getTree());
        } else {
            this.patternArea.setEnabled(false);
            this.loggerArea.setEnabled(false);
            this.contains.setText("");
            this.containsPositive.select(0);
            this.allLevel.setSelection(true);
            this.severeLevel.setSelection(false);
            this.warningLevel.setSelection(false);
            this.infoLevel.setSelection(false);
            this.fineLevel.setSelection(false);
            this.finerLevel.setSelection(false);
            this.finestLevel.setSelection(false);
            this.loggerTree.setAllChecked(true);
        }
    }

    private void updateLoggers(Set<String> disabledLoggers, Tree tree) {
        tree.selectAll();
        this.updateLoggers(disabledLoggers, tree.getItems());
    }

    private void updateLoggers(Set<String> disabledLoggers, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i.getData() != null) {
                i.setChecked(!disabledLoggers.contains(((LoggerContentProvider.Node)i.getData()).path));
                if (i.getItems().length > 0) {
                    this.updateLoggers(disabledLoggers, i.getItems());
                }
            }
            ++n2;
        }
    }

    protected LoggerViewFilter createDefaultFilter() {
        return new LoggerViewFilter("DEFAULT");
    }

    protected void acceptChanges() {
        if (this.currentFilter != null) {
            if (this.allLevel.getSelection()) {
                this.currentFilter.setLevel(Level.ALL);
            } else if (this.severeLevel.getSelection()) {
                this.currentFilter.setLevel(Level.SEVERE);
            } else if (this.warningLevel.getSelection()) {
                this.currentFilter.setLevel(Level.WARNING);
            } else if (this.infoLevel.getSelection()) {
                this.currentFilter.setLevel(Level.INFO);
            } else if (this.fineLevel.getSelection()) {
                this.currentFilter.setLevel(Level.FINE);
            } else if (this.finerLevel.getSelection()) {
                this.currentFilter.setLevel(Level.FINER);
            } else if (this.finestLevel.getSelection()) {
                this.currentFilter.setLevel(Level.FINEST);
            }
            this.currentFilter.setSubstringMatch(this.contains.getText());
            this.currentFilter.setInclusive(this.containsPositive.getSelectionIndex() == 0);
            this.acceptTreeItemChanges(this.currentFilter, this.loggerTree.getTree().getItems());
        }
    }

    private void acceptTreeItemChanges(LoggerViewFilter currentFilter, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i.getData() != null) {
                if (i.getChecked()) {
                    currentFilter.enableLogger(((LoggerContentProvider.Node)i.getData()).path);
                } else {
                    currentFilter.disableLogger(((LoggerContentProvider.Node)i.getData()).path);
                }
                this.acceptTreeItemChanges(currentFilter, i.getItems());
            }
            ++n2;
        }
    }

    protected void createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createFilterArea(composite);
        this.createPatternArea(composite);
        this.createLoggerArea(composite);
        if (this.filters != null) {
            this.updateFromFilters();
        }
    }

    private void createFilterArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(-1, 4, true, true);
        gridData.heightHint = 400;
        gridData.widthHint = 250;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("User Filters");
        new Label(composite, 0);
        Table table = new Table(composite, 2080);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFilterAddRemoveButtons(composite);
        this.createFilterSelectionButtons(composite);
        this.filterViewer = new CheckboxTableViewer(table);
        this.filterViewer.setContentProvider((IContentProvider)new FilterContentProvider());
        this.filterViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.filterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    LoggerViewFilterDialog.this.acceptChanges();
                    if (event.getSelection() instanceof IStructuredSelection) {
                        LoggerViewFilterDialog.this.updateFilterView((ViewerFilter)((IStructuredSelection)event.getSelection()).getFirstElement());
                    } else {
                        LoggerViewFilterDialog.this.updateFilterView(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createFilterSelectionButtons(Composite composite) {
        Composite buttonArea = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        buttonArea.setLayoutData((Object)gridData);
        RowLayout buttonAreaLayout = new RowLayout(256);
        buttonAreaLayout.fill = true;
        buttonArea.setLayout((Layout)buttonAreaLayout);
        Button selectAll = new Button(buttonArea, 8);
        selectAll.setText("Select All");
        selectAll.setLayoutData((Object)new RowData(80, -1));
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LoggerViewFilterDialog.this.filterViewer.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonArea, 8);
        deselectAll.setText("Deselect All");
        deselectAll.setLayoutData((Object)new RowData(80, -1));
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LoggerViewFilterDialog.this.filterViewer.setAllChecked(false);
            }
        });
    }

    private void createFilterAddRemoveButtons(Composite composite) {
        Composite buttonArea = new Composite(composite, 0);
        buttonArea.setLayoutData((Object)new GridData(131072, 128, false, false));
        RowLayout buttonAreaLayout = new RowLayout(512);
        buttonAreaLayout.fill = true;
        buttonArea.setLayout((Layout)buttonAreaLayout);
        Button add = new Button(buttonArea, 8);
        add.setText("New");
        add.setLayoutData((Object)new RowData(70, -1));
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(new Shell(), "Add New Filter", "Select Filter Name", "New Filter", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null) {
                            return "Text can't be null";
                        }
                        if (newText.equals("")) {
                            return "Please enter a Filter Name";
                        }
                        for (LoggerViewFilter filter : (this).LoggerViewFilterDialog.this.filters) {
                            if (!newText.equals(filter.getName())) continue;
                            return "Filter name must be unique";
                        }
                        return null;
                    }
                });
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    LoggerViewFilter filter = new LoggerViewFilter(dialog.getValue());
                    LoggerViewFilterDialog.this.filters.add(filter);
                    LoggerViewFilterDialog.this.filterViewer.add((Object)filter);
                    LoggerViewFilterDialog.this.filterViewer.setChecked((Object)filter, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button remove = new Button(buttonArea, 8);
        remove.setText("Remove");
        remove.setLayoutData((Object)new RowData(70, -1));
        remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewerFilter filter;
                ISelection selection = LoggerViewFilterDialog.this.filterViewer.getSelection();
                if (selection instanceof IStructuredSelection && (filter = (ViewerFilter)((IStructuredSelection)selection).getFirstElement()) != null) {
                    LoggerViewFilterDialog.this.filterViewer.remove((Object)filter);
                    LoggerViewFilterDialog.this.filters.remove(filter);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createLoggerArea(Composite parent) {
        this.loggerArea = new Composite(parent, 0);
        GridData gridData = new GridData(-1, 4, true, true);
        gridData.heightHint = 400;
        gridData.widthHint = 250;
        this.loggerArea.setLayoutData((Object)gridData);
        this.loggerArea.setEnabled(false);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.makeColumnsEqualWidth = true;
        this.loggerArea.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        Label label = new Label(this.loggerArea, 0);
        label.setText("Loggers");
        label.setLayoutData((Object)gridData);
        Tree tree = new Tree(this.loggerArea, 2080);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        tree.setLayoutData((Object)gridData);
        this.createLoggerSelectionButtons(this.loggerArea);
        this.loggerTree = new CheckboxTreeViewer(tree);
        this.loggerTree.setContentProvider((IContentProvider)new LoggerContentProvider());
        this.loggerTree.setInput((Object)LogManager.getLogManager());
        this.loggerTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                LoggerViewFilterDialog.this.loggerTree.setSubtreeChecked(event.getElement(), event.getChecked());
            }
        });
        this.loggerTree.setSubtreeChecked(this.loggerTree.getTree().getItem(0).getData(), true);
    }

    private void createLoggerSelectionButtons(Composite composite) {
        Composite buttonArea = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        buttonArea.setLayoutData((Object)gridData);
        RowLayout buttonAreaLayout = new RowLayout(256);
        buttonAreaLayout.fill = true;
        buttonArea.setLayout((Layout)buttonAreaLayout);
        Button selectAll = new Button(buttonArea, 8);
        selectAll.setLayoutData((Object)new RowData(80, -1));
        selectAll.setText("Select All");
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LoggerViewFilterDialog.this.loggerTree.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonArea, 8);
        deselectAll.setLayoutData((Object)new RowData(80, -1));
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LoggerViewFilterDialog.this.loggerTree.setAllChecked(false);
            }
        });
    }

    public void createPatternArea(Composite parent) {
        this.patternArea = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 400;
        gridData.widthHint = 200;
        this.patternArea.setLayoutData((Object)gridData);
        this.patternArea.setLayout((Layout)new GridLayout(1, true));
        this.patternArea.setEnabled(false);
        Group levelGroup = new Group(this.patternArea, 0);
        gridData = new GridData(4, -1, true, false);
        levelGroup.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        levelGroup.setLayout((Layout)rowLayout);
        levelGroup.setText("Level");
        this.allLevel = new Button((Composite)levelGroup, 16);
        this.allLevel.setText("All");
        this.severeLevel = new Button((Composite)levelGroup, 16);
        this.severeLevel.setText("Severe");
        this.warningLevel = new Button((Composite)levelGroup, 16);
        this.warningLevel.setText("Warning");
        this.infoLevel = new Button((Composite)levelGroup, 16);
        this.infoLevel.setText("Info");
        this.fineLevel = new Button((Composite)levelGroup, 16);
        this.fineLevel.setText("Fine");
        this.finerLevel = new Button((Composite)levelGroup, 16);
        this.finerLevel.setText("Finer");
        this.finestLevel = new Button((Composite)levelGroup, 16);
        this.finestLevel.setText("Finest");
        Group containsGroup = new Group(this.patternArea, 0);
        gridData = new GridData(4, -1, true, false);
        containsGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        containsGroup.setLayout((Layout)gridLayout);
        containsGroup.setText("Contains:");
        Label label = new Label((Composite)containsGroup, 0);
        label.setText("Message");
        this.containsPositive = new Combo((Composite)containsGroup, 0);
        this.containsPositive.add("contains");
        this.containsPositive.add("doesn't contain");
        this.contains = new Text((Composite)containsGroup, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 15;
        this.contains.setLayoutData((Object)gridData);
    }

    private void createContent(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        this.createDialogArea(composite);
        this.result = 1;
        this.createHorizontalLine(composite);
        this.createButtonArea(composite);
    }

    private void createButtonArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        composite.setLayoutData((Object)new GridData(131072, -1, true, false));
        Button okButton = new Button(composite, 8);
        RowData rowData = new RowData(80, -1);
        okButton.setLayoutData((Object)rowData);
        okButton.setText("Ok");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerViewFilterDialog.this.acceptChanges();
                for (LoggerViewFilter f : LoggerViewFilterDialog.this.filters) {
                    f.setActive(LoggerViewFilterDialog.this.filterViewer.getChecked((Object)f));
                }
                LoggerViewFilterDialog.this.result = 0;
                LoggerViewFilterDialog.this.shell.dispose();
            }
        });
        Button cancelButton = new Button(composite, 8);
        rowData = new RowData(80, -1);
        cancelButton.setLayoutData((Object)rowData);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerViewFilterDialog.this.result = 1;
                LoggerViewFilterDialog.this.shell.dispose();
            }
        });
    }

    private void createHorizontalLine(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        separator.setLayoutData((Object)gd);
    }

    public class FilterContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }
    }

    public class LoggerContentProvider
    implements ITreeContentProvider {
        Node root = new Node("root", null);

        public void dispose() {
            this.root = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.root = null;
                return;
            }
            if (!(newInput instanceof LogManager)) {
                throw new RuntimeException("Input must be a LogManager. Programming error!");
            }
            LogManager manager = (LogManager)newInput;
            this.root = new Node("", null);
            Enumeration<String> e = manager.getLoggerNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if (!name.startsWith("")) continue;
                Node node = this.root;
                String[] stringArray = name.split("\\.");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String substring = stringArray[n2];
                    node = node.getNode(substring);
                    ++n2;
                }
                node.setIsLogger(true);
            }
        }

        public Object[] getChildren(Object parentElement) {
            Node node = (Node)parentElement;
            return node.children.toArray();
        }

        public Object getParent(Object element) {
            Node node = (Node)element;
            return node.parent;
        }

        public boolean hasChildren(Object element) {
            Node node = (Node)element;
            return !node.children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return this.root.children.toArray();
        }

        public class Node {
            public String name;
            public String path;
            public Node parent = null;
            public List<Node> children = new ArrayList<Node>();
            private boolean isLogger;

            public Node(String name, Node parent) {
                this.name = name;
                this.parent = parent;
                this.isLogger = false;
                if (parent == null) {
                    this.path = name;
                } else {
                    parent.children.add(this);
                    this.path = "".equals(parent.path) ? name : String.valueOf(parent.path) + "." + name;
                }
            }

            public Node getNode(String name) {
                Node child2;
                if (this.name.equals(name)) {
                    return this;
                }
                for (Node child2 : this.children) {
                    if (!child2.name.equals(name)) continue;
                    return child2;
                }
                child2 = new Node(name, this);
                return child2;
            }

            public String toString() {
                if (this.isLogger) {
                    return String.valueOf(this.name) + " *";
                }
                return this.name;
            }

            public void setIsLogger(boolean isLogger) {
                this.isLogger = isLogger;
            }
        }
    }
}

