/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview.views;

import de.aristaflow.adept2.ui.loggerview.Activator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class LoggerViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String DATE_FORMAT = "HH:mm:ss.SS";
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss.SS");

    public String getColumnText(Object obj, int index) {
        LogRecord record = (LogRecord)obj;
        switch (index) {
            case 0: {
                return record.getMessage();
            }
            case 1: {
                return record.getLoggerName();
            }
            case 2: {
                return this.dateFormatter.format(new Date(record.getMillis()));
            }
            case 3: {
                return record.getLevel().toString();
            }
        }
        return "";
    }

    public Image getColumnImage(Object obj, int index) {
        if (index == 0) {
            return this.getImage(((LogRecord)obj).getLevel());
        }
        return null;
    }

    private Image getImage(Level level) {
        if (level.equals(Level.SEVERE)) {
            return Activator.getSharedImage("icons/error_obj.gif");
        }
        if (level.equals(Level.WARNING)) {
            return Activator.getSharedImage("icons/warning_obj.gif");
        }
        if (level.equals(Level.INFO)) {
            return Activator.getSharedImage("icons/info_obj.gif");
        }
        return null;
    }
}

