/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview.views;

import de.aristaflow.adept2.ui.loggerview.Activator;
import de.aristaflow.adept2.ui.loggerview.LoggerViewHandler;
import de.aristaflow.adept2.ui.loggerview.views.LoggerView;
import de.aristaflow.adept2.ui.loggerview.views.LoggerViewLabelProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.LogRecord;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MessageDetailsDialog
extends Dialog {
    private static final int COPY_ID = 22;
    private LogRecord currentLogRecord;
    private TableViewer provider;
    private Comparator comparator;
    private boolean isOpen;
    private LoggerViewLabelProvider labelProvider;
    private Point dialogLocation;
    private Point dialogSize;
    private int[] sashWeights;
    private Label dateLabel;
    private Label severityImageLabel;
    private Label severityLabel;
    private Label loggerNameLabel;
    private Label sourceClassLabel;
    private Label sourceMethodLabel;
    private Text msgText;
    private SashForm sashForm;
    private Text stackTraceText;
    private Text parameterDataText;
    private Button prevButton;
    private Button nextButton;
    private Button copyButton;
    private LogRecord[] logRecords;
    private int currentIndex = 0;
    private Clipboard clipboard;

    public MessageDetailsDialog(Shell parent, LogRecord selection, ISelectionProvider provider, Comparator<LogRecord> comparator) {
        super(parent);
        this.setShellStyle(3312);
        this.currentLogRecord = selection;
        this.provider = (TableViewer)provider;
        this.comparator = comparator;
        this.labelProvider = new LoggerViewLabelProvider();
        this.clipboard = new Clipboard(parent.getDisplay());
        this.initialize();
        this.readConfiguration();
    }

    private void initialize() {
        this.setEntrys();
        this.resetEntryIndex();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(500, 550);
        }
        this.getShell().setText("Message Details");
        MessageDetailsDialog.applyDialogFont((Control)this.buttonBar);
        this.getButton(0).setFocus();
    }

    public int open() {
        this.isOpen = true;
        if (this.sashWeights == null) {
            int width = this.sashForm.getClientArea().width;
            width = width - 100 > 0 ? (width -= 100) : (width /= 2);
            this.sashWeights = new int[]{width, this.sashForm.getClientArea().width - width};
        }
        this.sashForm.setWeights(this.sashWeights);
        return super.open();
    }

    public boolean close() {
        try {
            this.writeConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isOpen = false;
        return super.close();
    }

    public void resetSelection(LogRecord selectedEntry) {
        if (this.currentLogRecord.equals(selectedEntry) && this.logRecords.length == this.getElementCount()) {
            this.updateProperties();
            return;
        }
        this.currentLogRecord = selectedEntry;
        this.initialize();
        this.updateProperties();
    }

    private int getElementCount() {
        return ((LoggerView.LoggerViewContentProvider)this.provider.getContentProvider()).getElementCount();
    }

    public void resetButtons() {
        this.nextButton.setEnabled(false);
        this.prevButton.setEnabled(false);
    }

    public void setComparator(Comparator<LogRecord> comparator) {
        this.comparator = comparator;
        this.initialize();
        this.updateProperties();
    }

    private void setEntrys() {
        Object[] children = ((LoggerView.LoggerViewContentProvider)this.provider.getContentProvider()).getElements(null);
        ViewerFilter[] viewerFilterArray = this.provider.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            children = filter.filter(null, null, children);
            ++n2;
        }
        if (this.comparator != null) {
            Arrays.sort(children, this.comparator);
        }
        this.logRecords = new LogRecord[children.length];
        System.arraycopy(children, 0, this.logRecords, 0, children.length);
    }

    private void resetEntryIndex() {
        int i = 0;
        while (i < this.logRecords.length) {
            if (this.logRecords[i] == this.currentLogRecord) {
                this.currentIndex = i;
                break;
            }
            ++i;
        }
    }

    private void updateProperties() {
        Date date = new Date(this.currentLogRecord.getMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SS");
        this.dateLabel.setText(formatter.format(date));
        this.severityImageLabel.setImage(this.labelProvider.getColumnImage(this.currentLogRecord, 0));
        this.severityLabel.setText(this.currentLogRecord.getLevel().getName() != null ? this.currentLogRecord.getLevel().getName() : "");
        this.loggerNameLabel.setText(this.currentLogRecord.getLoggerName() != null ? this.currentLogRecord.getLoggerName() : "");
        this.sourceClassLabel.setText(this.currentLogRecord.getSourceClassName() != null ? this.currentLogRecord.getSourceClassName() : "");
        this.sourceMethodLabel.setText(this.currentLogRecord.getSourceMethodName() != null ? this.currentLogRecord.getSourceMethodName() : "");
        this.msgText.setText(this.currentLogRecord.getMessage() != null ? this.currentLogRecord.getMessage() : "");
        Throwable stack = this.currentLogRecord.getThrown();
        if (stack != null) {
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            stack.printStackTrace(pwriter);
            pwriter.flush();
            pwriter.close();
            this.stackTraceText.setText(swriter.toString());
        } else {
            this.stackTraceText.setText("An exception stack trace is not available.");
        }
        Object[] parameters = this.currentLogRecord.getParameters();
        if (parameters != null && parameters.length > 0) {
            StringBuilder p = new StringBuilder();
            int i = 0;
            while (i < parameters.length) {
                p.append(i + 1);
                p.append(": ");
                p.append(parameters[i]);
                p.append("\n");
                ++i;
            }
            this.parameterDataText.setText(p.toString());
        } else {
            this.parameterDataText.setText("No Parameters given!");
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.nextButton.setEnabled(this.currentIndex < this.logRecords.length - 1);
        this.prevButton.setEnabled(this.currentIndex > 0);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (14 == buttonId) {
            this.backPressed();
        } else if (15 == buttonId) {
            this.nextPressed();
        } else if (22 == buttonId) {
            this.copyPressed();
        }
    }

    private void copyPressed() {
        String textVersion = LoggerViewHandler.formatLogRecord(this.currentLogRecord);
        if (textVersion.trim().length() > 0) {
            this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void nextPressed() {
        this.currentLogRecord = this.logRecords[++this.currentIndex];
        this.setEntrySelectionInTable();
    }

    private void backPressed() {
        this.currentLogRecord = this.logRecords[--this.currentIndex];
        this.setEntrySelectionInTable();
    }

    private void setEntrySelectionInTable() {
        StructuredSelection selection = new StructuredSelection((Object)this.currentLogRecord);
        this.provider.setSelection((ISelection)selection);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createDetailsSection(container);
        this.createSashForm(container);
        this.createStackSection((Composite)this.sashForm);
        this.createParametersSection((Composite)this.sashForm);
        this.updateProperties();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.sashForm.setLayout((Layout)layout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
    }

    private void createDetailsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.createTextSection(container);
        this.createToolbarButtonBar(container);
    }

    private void createTextSection(Composite parent) {
        Composite textContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textContainer.setLayout((Layout)layout);
        textContainer.setLayoutData((Object)new GridData(768));
        Label label = new Label(textContainer, 0);
        label.setText("Date:");
        this.dateLabel = new Label(textContainer, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.dateLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Severity:");
        this.severityImageLabel = new Label(textContainer, 0);
        this.severityLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        this.severityLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Logger Name:");
        this.loggerNameLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.loggerNameLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Source Class:");
        this.sourceClassLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.sourceClassLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Source Method:");
        this.sourceMethodLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.sourceMethodLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText("Message:");
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.msgText = new Text(textContainer, 2626);
        this.msgText.setEditable(false);
        gd = new GridData(1810);
        gd.horizontalSpan = 2;
        gd.heightHint = 44;
        gd.grabExcessVerticalSpace = true;
        this.msgText.setLayoutData((Object)gd);
    }

    private void createStackSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Exception Stack Trace:");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.stackTraceText = new Text(container, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        this.stackTraceText.setLayoutData((Object)gd);
        this.stackTraceText.setEditable(false);
    }

    private void createParametersSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label line = new Label(container, 258);
        gd = new GridData(256);
        gd.widthHint = 1;
        line.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Parameters:");
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.parameterDataText = new Text(container, 2816);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        this.parameterDataText.setLayoutData((Object)gd);
        this.parameterDataText.setEditable(false);
    }

    private void createToolbarButtonBar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.prevButton = this.createButton(container, 14, "", false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.prevButton.setLayoutData((Object)gd);
        this.prevButton.setToolTipText("Previous");
        this.prevButton.setImage(Activator.getSharedImage("icons/event_prev.gif"));
        this.nextButton = this.createButton(container, 15, "", false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.nextButton.setLayoutData((Object)gd);
        this.nextButton.setToolTipText("Next");
        this.nextButton.setImage(Activator.getSharedImage("icons/event_next.gif"));
        this.copyButton = this.createButton(container, 22, "", false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.copyButton.setLayoutData((Object)gd);
        this.copyButton.setImage(Activator.getSharedImage("icons/event_copy.gif"));
        this.copyButton.setToolTipText("Copy");
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
            this.sashWeights = new int[2];
            this.sashWeights[0] = s.getInt("sashWidth1");
            this.sashWeights[1] = s.getInt("sashWidth2");
        }
        catch (NumberFormatException numberFormatException) {
            this.dialogLocation = null;
            this.dialogSize = null;
            this.sashWeights = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
        this.sashWeights = this.sashForm.getWeights();
        s.put("sashWidth1", this.sashWeights[0]);
        s.put("sashWidth2", this.sashWeights[1]);
    }
}

