/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.loggerview.views;

import de.aristaflow.adept2.ui.loggerview.views.MessageDetailsDialog;
import java.util.Comparator;
import java.util.logging.LogRecord;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class MessageDetailsDialogAction
extends SelectionProviderAction {
    private Shell shell;
    private ISelectionProvider provider;
    private MessageDetailsDialog propertyDialog;
    private Comparator<LogRecord> comparator;

    public MessageDetailsDialogAction(Shell shell, ISelectionProvider provider, Comparator<LogRecord> comparator) {
        super(provider, "Message Details");
        this.shell = shell;
        this.provider = provider;
        this.comparator = comparator;
        this.setToolTipText("Display message details");
    }

    public void run() {
        if (this.propertyDialog != null && this.propertyDialog.isOpen()) {
            this.resetSelection();
            return;
        }
        LogRecord element = (LogRecord)this.getStructuredSelection().getFirstElement();
        if (element == null) {
            return;
        }
        this.propertyDialog = new MessageDetailsDialog(this.shell, element, this.provider, this.comparator);
        this.propertyDialog.create();
        this.propertyDialog.open();
    }

    public void resetSelection() {
        LogRecord element = (LogRecord)this.getStructuredSelection().getFirstElement();
        if (element == null) {
            return;
        }
        if (this.propertyDialog != null && this.propertyDialog.isOpen()) {
            this.propertyDialog.resetSelection(element);
        }
    }

    public void resetDialogButtons() {
        if (this.propertyDialog != null && this.propertyDialog.isOpen()) {
            this.propertyDialog.resetButtons();
        }
    }

    public void setComparator(Comparator<LogRecord> comparator) {
        this.comparator = comparator;
        if (this.propertyDialog != null && this.propertyDialog.isOpen()) {
            this.propertyDialog.setComparator(comparator);
        }
    }
}

