/*
 * Decompiled with CFR 0.152.
 */
package de.uniulm.dbis.eclipse.filecomment.actions;

import de.uniulm.dbis.eclipse.filecomment.actions.MultiLineInputDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AddComment
implements IObjectActionDelegate {
    ISelection selection = null;
    public static final String ID = "de.uniulm.dbis.eclipse.filecomment.actions.AddComment";
    private static final String MARKER_ID = "de.uniulm.dbis.eclipse.filecomment.comment";

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        IFile file = (IFile)structSelection.getFirstElement();
        MultiLineInputDialog dialog = new MultiLineInputDialog(Display.getDefault().getActiveShell(), "Add Comment", String.format("Add a comment to file '%s'", file.getName()), "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().length() == 0) {
                    return "Please enter a comment!";
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String comment = dialog.getValue();
            try {
                IMarker marker = file.createMarker(MARKER_ID);
                marker.setAttribute("severity", 0);
                marker.setAttribute("message", (Object)comment);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"An error occurred!", (String)e.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

