/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;

public class ChangeOperationTracker
implements ChangeListener {
    protected final Editor editor;
    final UpdateManager updateManager;
    private Template template;
    protected final ProcessModelXMLImport xmlImport;
    protected final ProcessModelXMLExport xmlExport;
    private Document doc;
    private String lastTransactionLabel;
    protected UndoableChangeOperation lastOperation;
    protected UndoableChangeOperation lastSavedOperation;
    private final IUndoContext undoContext;
    boolean expectReplaceEvent = false;

    public ChangeOperationTracker(Editor editor, IUndoContext undoContext) {
        this.editor = editor;
        this.undoContext = undoContext;
        this.updateManager = Activator.getService().getUpdateManager();
        ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
        pmf.setCreateChangeable(true);
        this.xmlImport = new ProcessModelXMLImport(pmf);
        this.xmlExport = new ProcessModelXMLExport();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(UpdateManager.TransactionProperties.TRANSACTION_LABEL)) {
            this.lastTransactionLabel = (String)event.getNewValue();
        }
        if (event.getProperty().equals(UpdateManager.TransactionProperties.TRANSACTION_ENDED)) {
            if (this.lastTransactionLabel == null) {
                this.lastTransactionLabel = "Change Operation";
            }
            try {
                Document oldTemplateDoc = this.doc;
                this.updateDoc();
                Document newTemplateDoc = this.doc;
                this.lastOperation = new UndoableChangeOperation(this.lastTransactionLabel, oldTemplateDoc, newTemplateDoc);
                this.lastOperation.addContext(this.undoContext);
                this.editor.getOperationhistory().execute((IUndoableOperation)this.lastOperation, null, null);
                this.lastTransactionLabel = null;
            }
            catch (ExecutionException executionException) {}
        } else if (event.getProperty().equals(UpdateManager.ProcessProperties.OBJECT_REPLACED)) {
            if (this.expectReplaceEvent) {
                this.expectReplaceEvent = false;
            } else {
                Document newTemplateDoc;
                Document oldTemplateDoc;
                try {
                    oldTemplateDoc = this.xmlExport.getDocumentForTemplate((Template)event.getOldValue());
                    newTemplateDoc = this.xmlExport.getDocumentForTemplate((Template)event.getNewValue());
                }
                catch (XMLFormatException e) {
                    String message = "Error creating undo information.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                    return;
                }
                this.lastOperation = new UndoableChangeOperation("Replace Document", oldTemplateDoc, newTemplateDoc);
                this.lastOperation.addContext(this.undoContext);
                try {
                    this.editor.getOperationhistory().execute((IUndoableOperation)this.lastOperation, null, null);
                }
                catch (ExecutionException executionException) {}
            }
        }
    }

    private void updateDoc() {
        try {
            this.doc = this.xmlExport.getDocumentForTemplate(this.template);
        }
        catch (XMLFormatException e) {
            String message = "Error creating undo information.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
    }

    public void setTemplate(Template template) {
        this.updateManager.removeListener((Object)this.template, (ChangeListener)this);
        this.template = template;
        this.updateManager.addListener((Object)template, (ChangeListener)this);
        this.updateDoc();
    }

    public void dispose() {
        this.updateManager.removeListener((Object)this.template, (ChangeListener)this);
    }

    public class UndoableChangeOperation
    extends AbstractOperation
    implements IUndoableOperation {
        private final Document oldTemplateDoc;
        private final Document newTemplateDoc;

        public UndoableChangeOperation(String label, Document oldTemplateDoc, Document newTemplateDoc) {
            super(label);
            this.oldTemplateDoc = oldTemplateDoc;
            this.newTemplateDoc = newTemplateDoc;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Template newTemplate = ChangeOperationTracker.this.xmlImport.getTemplateFromDocument(this.newTemplateDoc);
            ChangeOperationTracker.this.expectReplaceEvent = true;
            TemplateInput.Holder holder = new TemplateInput.Holder(newTemplate, null);
            ChangeOperationTracker.this.editor.setTemplate(holder);
            ChangeOperationTracker.this.editor.setLocalDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Template oldTemplate = ChangeOperationTracker.this.xmlImport.getTemplateFromDocument(this.oldTemplateDoc);
            ChangeOperationTracker.this.expectReplaceEvent = true;
            TemplateInput.Holder holder = new TemplateInput.Holder(oldTemplate, null);
            ChangeOperationTracker.this.editor.setTemplate(holder);
            ChangeOperationTracker.this.editor.setLocalDirty(true);
            return Status.OK_STATUS;
        }
    }
}

