/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class CheckModeCombo
extends WorkbenchWindowControlContribution
implements IPartListener2,
SelectionListener,
IPropertyChangeListener {
    private final ProcessCheckService.CheckSet[] checkSets = ProcessCheckService.CheckSet.values();
    private Combo combo;
    private IPreferenceStore preferencesStore;

    public CheckModeCombo() {
        super("CheckModeCombo");
    }

    protected Control createControl(Composite parent) {
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
                window.getActivePage().addPartListener((IPartListener2)CheckModeCombo.this);
            }
        });
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        control.setLayout((Layout)gridLayout);
        String[] checkSetLabels = new String[this.checkSets.length];
        int i = 0;
        while (i < this.checkSets.length) {
            checkSetLabels[i] = this.checkSets[i].label;
            ++i;
        }
        this.combo = new Combo(control, 8);
        this.combo.setItems(checkSetLabels);
        this.preferencesStore = Activator.getDefault().getPreferenceStore();
        this.preferencesStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.combo.setText(ProcessCheckService.CheckSet.valueOf((String)this.preferencesStore.getString((String)"ChecksRunCheckSet")).label);
        GridData gridData = new GridData(-1, 0x1000000, false, true);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setVisibleItemCount(5);
        this.combo.setVisible(false);
        this.combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof Editor) {
            ((Editor)activeEditor).setCheckSet(this.checkSets[this.combo.getSelectionIndex()]);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.showCombo(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.showCombo(partRef);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getPart(false) instanceof Editor && !this.combo.isDisposed()) {
            this.combo.setVisible(false);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.showCombo(partRef);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.showCombo(partRef);
    }

    private void showCombo(IWorkbenchPartReference partRef) {
        if (this.combo.isDisposed()) {
            return;
        }
        if (partRef.getPart(false) instanceof Editor) {
            Editor editor = (Editor)partRef.getPart(false);
            this.combo.setVisible(true);
            this.combo.removeSelectionListener((SelectionListener)this);
            this.combo.select(editor.getCheckSet().ordinal());
            this.combo.addSelectionListener((SelectionListener)this);
        } else if (partRef.getPart(false) instanceof IEditorPart) {
            this.combo.setVisible(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!this.combo.isDisposed()) {
            this.combo.setText(ProcessCheckService.CheckSet.valueOf((String)this.preferencesStore.getString((String)"ChecksRunCheckSet")).label);
        }
    }
}

