/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangePrimitives;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.ChangeOperationTracker;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteBorderNodesAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteBranchAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteDataElementAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.DeleteNodeAction;
import de.aristaflow.adept2.ui.processediting.actions.changeoperations.RemoveDataAccessAction;
import de.aristaflow.adept2.ui.processediting.dnd.ActivityTransferDropTargetListener;
import de.aristaflow.adept2.ui.processediting.dnd.SubProcessTransferDropTargetListener;
import de.aristaflow.adept2.ui.processediting.editorinputs.EmbeddedTemplateInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.FileTemplateInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.IFileInstanceInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.IFileTemplateInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.InstanceChangingInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.InstanceInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.ProcessInput;
import de.aristaflow.adept2.ui.processediting.editorinputs.SilentException;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.ui.processediting.wizards.DataElementWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.PnPWizard;
import de.aristaflow.adept2.ui.processvisualisation.OutlinePage;
import de.aristaflow.adept2.ui.processvisualisation.PaletteFactory;
import de.aristaflow.adept2.ui.processvisualisation.ProblemMarker;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.actions.PrintTemplateAction;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.ProcessEditPartFactory;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroup;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroupDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.util.wizard.OverviewWizardDialogue;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.tools.PanningSelectionTool;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class Editor
extends GraphicalEditorWithFlyoutPalette
implements ChangeListener,
MouseListener,
KeyListener,
ITabbedPropertySheetPageContributor,
IResourceChangeListener,
IReusableEditor,
ISaveablePart2,
ProcessVisualiser {
    public static final String ID = Activator.getPluginID();
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    Instance instance;
    Template template;
    private TemplateStatus templateStatus;
    private boolean localDirty;
    private boolean overallDirty;
    Set<Editor> childEditors = new HashSet<Editor>();
    private boolean autoZoom;
    private String autoZoomLevel;
    private SelectionManager selectionManager;
    private UpdateManager updateManager;
    private MenuManager contextMenuManager;
    private PaletteFactory PALETTE = new PaletteFactory();
    private boolean saveable;
    OutlinePage outlinePage;
    private IPropertySheetPage propertyPage;
    IPreferenceStore preferencesStore;
    IPropertyChangeListener preferenceChangeListener;
    IPartListener2 partListener;
    protected boolean autoRunConsistencyChecks = true;
    protected boolean autoRunStructureChecks = true;
    protected ProcessCheckService.CheckSet checkSet = ProcessCheckService.CheckSet.BASIC_MODELLING;
    protected UISettings uiSettings;
    private boolean isInitialised = false;
    Exception setInputException;
    private ChangeOperationTracker changeOpTracker;
    private final IPropertyListener childEditorListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257 && ((Editor)((Object)source)).isDirty()) {
                Editor.this.updateOverallDirty();
            }
        }
    };
    private IGotoMarker gotoMarker = new IGotoMarker(){

        public void gotoMarker(IMarker marker) {
            URI elementIdentifier;
            String elementType = marker.getAttribute("elementType", "");
            String elementIdentifierStr = marker.getAttribute("elementId", null);
            if (elementIdentifierStr == null) {
                return;
            }
            try {
                elementIdentifier = new URI(elementIdentifierStr);
            }
            catch (URISyntaxException e1) {
                String errorMessage = String.format("Cannot reveal the affected process element '%s' : The element identifier is no ADEPT2ProcessElementIdentifier!", elementIdentifierStr);
                Editor.this.logger.log(Level.SEVERE, errorMessage, e1);
                return;
            }
            if (!elementType.equalsIgnoreCase(ProcessElementIdentifierTools.getElementType((URI)elementIdentifier))) {
                String errorMessage = String.format("Cannot reveal the affected process element '%s': The type '%s' of the passed ADEPT2ProcessElementIdentifier does not match the expected type '%s'!", elementIdentifierStr, ProcessElementIdentifierTools.getElementType((URI)elementIdentifier), elementType);
                Editor.this.logger.log(Level.SEVERE, errorMessage);
                return;
            }
            String[] typesOfIdentifierPath = ProcessElementIdentifierTools.getTypesOfIdentifierPath((URI)elementIdentifier);
            String[] idsOfIdentifierPath = ProcessElementIdentifierTools.getPathIDsOfIdentifierPath((URI)elementIdentifier);
            String elementIdStr = null;
            if (elementType.equalsIgnoreCase("template")) {
                elementIdStr = idsOfIdentifierPath[0];
                elementType = typesOfIdentifierPath[0];
            } else if (elementType.equalsIgnoreCase("node")) {
                elementIdStr = idsOfIdentifierPath[1];
                elementType = typesOfIdentifierPath[1];
            } else if (elementType.equalsIgnoreCase("ebp")) {
                elementIdStr = idsOfIdentifierPath[1];
                elementType = typesOfIdentifierPath[1];
            } else if (elementType.equalsIgnoreCase("parameter")) {
                elementIdStr = idsOfIdentifierPath[1];
                elementType = typesOfIdentifierPath[1];
            } else if (elementType.equalsIgnoreCase("dataelement")) {
                elementIdStr = idsOfIdentifierPath[1];
                elementType = typesOfIdentifierPath[1];
            } else {
                String errorMessage = String.format("Cannot reveal the affected process element '%s': The type '%s' of the passed ADEPT2ProcessElementIdentifier is not supported, yet!", elementIdentifierStr, ProcessElementIdentifierTools.getElementType((URI)elementIdentifier), elementType);
                Editor.this.logger.log(Level.SEVERE, errorMessage);
                return;
            }
            int elementId = -1;
            try {
                elementId = new Long(elementIdStr).intValue();
            }
            catch (NumberFormatException e) {
                String errorMessage = String.format("Cannot reveal the affected process element '%s' with ID='%s': An NumberFormatException occurred!", elementType, elementIdentifierStr);
                Editor.this.logger.log(Level.SEVERE, errorMessage, e);
                return;
            }
            EditPart part = Editor.this.findEditPart(elementType, elementId);
            if (part != null) {
                Editor.this.getGraphicalViewer().reveal(part);
            } else {
                Editor.this.logger.warning("Can't find Element for Marker: " + elementType + ":" + elementIdentifierStr);
            }
        }
    };
    private final Set<IMarker> markers = new HashSet<IMarker>();
    private final IUndoContext undoContext = new ObjectUndoContext((Object)this);
    private CheckReport currentReport;

    public Editor() {
        this.changeOpTracker = new ChangeOperationTracker(this, this.undoContext);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this){

            public void loadDefaultTool() {
                this.setActiveTool((Tool)new PanningSelectionTool());
            }
        });
        this.updateManager = Activator.getService().getUpdateManager();
        this.preferencesStore = Activator.getDefault().getPreferenceStore();
        this.autoRunConsistencyChecks = this.preferencesStore.getBoolean("ChecksRunConsistencyPreference");
        this.autoRunStructureChecks = this.preferencesStore.getBoolean("ChecksRunStructurePreference");
        this.checkSet = ProcessCheckService.CheckSet.valueOf((String)this.preferencesStore.getString("ChecksRunCheckSet"));
        this.preferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(org.eclipse.jface.util.PropertyChangeEvent event) {
                ProcessCheckService.CheckSet newCheckSet;
                if (event.getProperty().equals("ChecksRunConsistencyPreference")) {
                    Editor.this.autoRunConsistencyChecks = Editor.this.preferencesStore.getBoolean("ChecksRunConsistencyPreference");
                    if (Editor.this.autoRunConsistencyChecks) {
                        Editor.this.performChecks();
                    }
                }
                if (event.getProperty().equals("ChecksRunStructurePreference")) {
                    Editor.this.autoRunStructureChecks = Editor.this.preferencesStore.getBoolean("ChecksRunStructurePreference");
                    if (Editor.this.autoRunStructureChecks) {
                        Editor.this.performChecks();
                    }
                }
                if (event.getProperty().equals("ChecksRunCheckSet") && (newCheckSet = ProcessCheckService.CheckSet.valueOf((String)Editor.this.preferencesStore.getString("ChecksRunCheckSet"))) != Editor.this.checkSet) {
                    Editor.this.checkSet = newCheckSet;
                    Editor.this.performChecks();
                }
            }
        };
        this.preferencesStore.addPropertyChangeListener(this.preferenceChangeListener);
    }

    public ProcessCheckService.CheckSet getCheckSet() {
        return this.checkSet;
    }

    public void setCheckSet(ProcessCheckService.CheckSet checkSet) {
        if (this.checkSet == checkSet) {
            return;
        }
        this.checkSet = checkSet;
        this.performChecks();
        this.firePropertyChange(258);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == Editor.this) {
                    Editor.this.deleteMarkers((IResource)ResourcesPlugin.getWorkspace().getRoot());
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (Editor.this.setInputException != null) {
                    Editor.this.getSite().getWorkbenchWindow().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Editor.this.getSite().getPage().closeEditor((IEditorPart)Editor.this, false);
                        }
                    });
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == Editor.this) {
                    Editor.this.performChecks();
                }
            }
        };
        site.getPage().addPartListener(this.partListener);
        if (this.setInputException != null) {
            String msg = "The editor input '%s' could not be loaded!";
            msg = String.format(msg, input.getName());
            throw new PartInitException(msg, (Throwable)this.setInputException);
        }
        this.isInitialised = true;
    }

    protected void createActions() {
        super.createActions();
        this.getActionRegistry().registerAction((IAction)new PrintTemplateAction((IWorkbenchPart)this));
        UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), this.undoContext);
        RedoActionHandler redoAction = new RedoActionHandler(this.getSite(), this.undoContext);
        undoAction.setId(ActionFactory.UNDO.getId());
        redoAction.setId(ActionFactory.REDO.getId());
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redoAction);
        this.getActionRegistry().registerAction((IAction)undoAction);
        this.getActionRegistry().registerAction((IAction)redoAction);
        IOperationHistory history = this.getOperationhistory();
        history.setLimit(this.undoContext, 100);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart(){

            protected LayeredPane createPrintableLayers() {
                LayeredPane pane = new LayeredPane();
                pane.setOpaque(true);
                ConnectionLayer connectionLayer = new ConnectionLayer();
                connectionLayer.setPreferredSize(new Dimension(5, 5));
                Layer primaryLayer = new Layer();
                primaryLayer.setLayoutManager((LayoutManager)new StackLayout());
                pane.add((IFigure)primaryLayer, (Object)"Primary Layer");
                pane.add((IFigure)connectionLayer, (Object)"Connection Layer");
                return pane;
            }
        };
        this.uiSettings = new UISettings(viewer);
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        this.selectionManager = new SelectionManager(viewer, this.getPalette(), viewer.getEditDomain(), this.uiSettings);
        this.contextMenuManager = new MenuManager("My Context Menu", ID);
        this.contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.contextMenuManager.add((IContributionItem)new Separator());
        this.contextMenuManager.add((IAction)new Action("Display Options"){

            public void run() {
                Editor.this.uiSettings.showConfigDialog(Editor.this.getSite().getShell());
            }
        });
        this.getSite().registerContextMenu(this.contextMenuManager, (ISelectionProvider)this.selectionManager);
        viewer.setContextMenu(this.contextMenuManager);
        viewer.getControl().addMouseListener((MouseListener)this);
        viewer.getControl().addKeyListener((KeyListener)this);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new ActivityTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new SubProcessTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), SubProcessTransferDropTargetListener.TransferType.TEMPLATE_REFERENCE));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new SubProcessTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), SubProcessTransferDropTargetListener.TransferType.TEMPLATE_RESOURCE));
    }

    protected void initializeGraphicalViewer() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionManager);
        this.refreshGraphUI();
    }

    public void dispose() {
        super.dispose();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        if (this.selectionManager != null) {
            for (SelectionGroup grp : this.selectionManager.getAllGroups()) {
                this.selectionManager.removeGroup(grp.getDefinition());
            }
        }
        if (this.getInstance() != null) {
            this.updateManager.removeListener((Object)this.getInstance(), (ChangeListener)this);
        } else if (this.getTemplate() != null) {
            this.updateManager.removeListener((Object)this.getTemplate(), (ChangeListener)this);
        } else {
            this.logger.log(Level.WARNING, "Editor could not deregister from listener!");
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.preferencesStore.removePropertyChangeListener(this.preferenceChangeListener);
        this.changeOpTracker.dispose();
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        this.getOperationhistory().dispose(this.undoContext, true, true, true);
        this.disposeInput();
    }

    private void disposeInput() {
        if (this.getEditorInput() instanceof ProcessInput) {
            try {
                ((ProcessInput)this.getEditorInput()).dispose();
            }
            catch (Exception ex) {
                String msg = "An exception occured while disposing the content of this editor!";
                this.logger.log(Level.WARNING, msg, ex);
            }
        }
        if (this.getEditorInput() instanceof EmbeddedTemplateInput) {
            EmbeddedTemplateInput subProcessInput = (EmbeddedTemplateInput)this.getEditorInput();
            subProcessInput.getParentEditor().unregisterChildEditor(this);
        }
        if (this.getSite().getWorkbenchWindow().getActivePage() != null) {
            for (Editor childEditor : this.childEditors) {
                this.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)childEditor, false);
            }
        }
        this.childEditors.clear();
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public UISettings getUISettings() {
        return this.uiSettings;
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    public boolean isDirty() {
        return this.isSaveable() && this.overallDirty;
    }

    public void markDirty() {
        this.setLocalDirty(true);
    }

    protected void setLocalDirty(boolean dirty) {
        if ((this.isSaveable() || dirty) && this.localDirty != dirty) {
            this.localDirty = dirty;
            this.updateOverallDirty();
        }
    }

    protected void updateOverallDirty() {
        boolean newOverallDirty = this.localDirty;
        if (!newOverallDirty) {
            for (Editor childEditor : this.childEditors) {
                if (!childEditor.isDirty()) continue;
                newOverallDirty = true;
                break;
            }
        }
        if (this.overallDirty != newOverallDirty) {
            this.overallDirty = newOverallDirty;
            this.firePropertyChange(257);
        }
    }

    public int promptToSaveOnClose() {
        if (this.getSite().getWorkbenchWindow().getWorkbench().isClosing() && this.isChildEditor()) {
            return 1;
        }
        String title = "Save Resource";
        String msg = "'%s' has been modified. Save changes?";
        msg = String.format(msg, this.getPartName());
        if (this.isChildEditor()) {
            msg = String.valueOf(msg) + "\n\nChanges will only be saved to the parent editor. Since this is a child editor, saved changes will only be persisted when the root editor is saved.";
        } else if (this.childEditors.size() > 0) {
            msg = String.valueOf(msg) + "\n\nAll (direct and indirect) child editors will be saved and closed as well:";
            for (Editor childEditor : this.getChildEditors(null, true)) {
                msg = String.valueOf(msg) + "\n" + childEditor.getPartName();
            }
        }
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        int result = dialog.open();
        switch (result) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case -1: 
            case 2: {
                return 2;
            }
        }
        throw new AssertionError();
    }

    private List<Editor> getChildEditors(List<Editor> childEditors, boolean recursive) {
        if (childEditors == null) {
            childEditors = new ArrayList<Editor>();
        }
        if (recursive) {
            for (Editor childEditor : this.childEditors) {
                childEditors.add(childEditor);
                childEditor.getChildEditors(childEditors, true);
            }
        } else {
            childEditors.addAll(this.childEditors);
        }
        return childEditors;
    }

    private boolean isChildEditor() {
        return this.getEditorInput() instanceof EmbeddedTemplateInput;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Object holder;
            for (Editor childEditor : this.childEditors) {
                if (!childEditor.isDirty()) continue;
                childEditor.doSave(null);
            }
            if (this.getEditorInput() instanceof TemplateInput) {
                TemplateInput templateInput = (TemplateInput)this.getEditorInput();
                holder = templateInput.doSave(this.getTemplate(), this.getTemplateStatus(), monitor);
                this.setLocalDirty(false);
                if (holder != null) {
                    this.setTemplate((TemplateInput.Holder)holder);
                }
            } else if (this.getEditorInput() instanceof InstanceInput) {
                InstanceInput instanceInput = (InstanceInput)this.getEditorInput();
                holder = instanceInput.doSave(this.getInstance(), monitor);
                this.setLocalDirty(false);
                if (holder != null) {
                    this.setInstance((InstanceInput.Holder)holder);
                }
            } else {
                this.logger.info("Saving is not supported for this kind of Content (" + this.getEditorInput().getClass() + ") .");
            }
        }
        catch (SilentException silentException) {
            monitor.setCanceled(true);
        }
        catch (Exception ex) {
            monitor.setCanceled(true);
            String type = this.getEditorInput() instanceof TemplateInput ? "template" : "instance";
            String msg = "An error occured while trying to save the %s!";
            msg = String.format(msg, type);
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.getEditorInput() instanceof TemplateInput) {
            return true;
        }
        return ((ProcessInput)this.getEditorInput()).isSaveAsAllowed();
    }

    public void doSaveAs() {
        block6: {
            try {
                if (this.getEditorInput() instanceof TemplateInput) {
                    TemplateInput templateInput = (TemplateInput)this.getEditorInput();
                    TemplateInput newInput = templateInput.isSaveAsAllowed() ? templateInput.doSaveAs(this.getTemplate(), this.getTemplateStatus(), null) : FileTemplateInput.saveTemplateToNewFile(this.getTemplate(), null);
                    if (newInput != null) {
                        this.setInput(newInput);
                    }
                    break block6;
                }
                InstanceInput instanceInput = (InstanceInput)this.getEditorInput();
                if (instanceInput.isSaveAsAllowed()) {
                    InstanceInput newInput = instanceInput.doSaveAs(this.getInstance(), null);
                    if (newInput != null) {
                        this.setInput(newInput);
                    }
                    break block6;
                }
                throw new Exception("'Save as...' not supported here!");
            }
            catch (Exception ex) {
                String type = this.getEditorInput() instanceof TemplateInput ? "template" : "instance";
                String msg = "An error occured while trying to save the %s!";
                msg = String.format(msg, type);
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
            }
        }
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null || this.outlinePage.isDisposed()) {
                this.outlinePage = new OutlinePage((EditPartViewer)this.getGraphicalViewer(), this.getSelectionSynchronizer());
            }
            return this.outlinePage;
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (type == IPropertySheetPage.class) {
            if (this.propertyPage == null) {
                this.propertyPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.propertyPage;
        }
        if (type == IGotoMarker.class) {
            return this.gotoMarker;
        }
        if (type == Instance.class) {
            return this.getInstance();
        }
        return super.getAdapter(type);
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Template getTemplate() {
        if (this.instance != null) {
            return this.instance.getTemplate();
        }
        return this.template;
    }

    public TemplateStatus getTemplateStatus() {
        return this.templateStatus;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return PaletteFactory.createPalettePreferences();
    }

    public PaletteFactory getPalette() {
        return this.PALETTE;
    }

    protected PaletteRoot getPaletteRoot() {
        return this.PALETTE.getRoot();
    }

    public void setInput(IEditorInput input) {
        block17: {
            if (this.getEditorInput() == input) {
                return;
            }
            this.disposeInput();
            TemplateInput templateInput = null;
            InstanceInput instanceInput = null;
            if (input instanceof TemplateInput) {
                templateInput = (TemplateInput)input;
            } else if (input instanceof InstanceInput) {
                instanceInput = (InstanceInput)input;
            } else if (input instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)input;
                IFile file = fileEditorInput.getFile();
                String extension = file.getFileExtension();
                if (extension != null && extension.equals("instance")) {
                    instanceInput = new IFileInstanceInput(fileEditorInput);
                } else {
                    templateInput = new IFileTemplateInput(fileEditorInput);
                }
            }
            if (templateInput == null && instanceInput == null) {
                throw new IllegalArgumentException("This editor does not know how to handle " + input + " IEditorInputs");
            }
            try {
                Object holder;
                boolean reused;
                boolean bl = reused = this.template != null;
                if (templateInput != null) {
                    holder = templateInput.load();
                    this.setTemplate((TemplateInput.Holder)holder);
                    this.setSaveable(templateInput.isSaveAllowed());
                    input = templateInput;
                } else if (instanceInput != null) {
                    holder = instanceInput.load();
                    this.setInstance((InstanceInput.Holder)holder);
                    this.setSaveable(instanceInput.isSaveAllowed());
                    input = instanceInput;
                }
                if (reused) {
                    super.setInputWithNotify(input);
                } else {
                    super.setInput(input);
                }
                this.logger.info("input: " + input);
                this.updateTitle();
                this.setLocalDirty(false);
                if (input instanceof EmbeddedTemplateInput) {
                    EmbeddedTemplateInput subProcessInput = (EmbeddedTemplateInput)input;
                    subProcessInput.getParentEditor().registerChildEditor(this);
                }
                this.setInputException = null;
            }
            catch (Exception ex) {
                this.setInputException = ex;
                String type = input instanceof TemplateInput ? "template" : (input instanceof InstanceInput ? "instance" : "template or instance");
                if (!this.isInitialised) break block17;
                String msg = "An error occured while trying to load the %s!";
                msg = String.format(msg, type);
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
            }
        }
    }

    public void setTemplate(TemplateInput.Holder holder) {
        ArgChecks.checkForNull((Object)holder, (String)"holder");
        if (this.getInstance() != null) {
            this.updateManager.removeListener((Object)this.getInstance(), (ChangeListener)this);
        } else {
            this.updateManager.removeListener((Object)this.getTemplate(), (ChangeListener)this);
        }
        Template oldTemplate = this.template;
        this.instance = null;
        this.template = holder.template;
        this.templateStatus = holder.templateStatus;
        this.updateManager.addListener((Object)this.getTemplate(), (ChangeListener)this);
        this.refreshGraphUI();
        this.performChecks();
        if (this.selectionManager != null) {
            for (SelectionGroup group : this.selectionManager.getAllGroups()) {
                SelectionGroupDefinition definition = group.getDefinition();
                this.selectionManager.updateSelectionReferencesForGroup(this.template, definition);
            }
        }
        this.updateManager.firePropertyChange((Object)oldTemplate, (Object)UpdateManager.ProcessProperties.OBJECT_REPLACED, (Object)oldTemplate, (Object)this.template);
        this.updateManager.sendPropertyChanges();
        this.changeOpTracker.setTemplate(this.getTemplate());
    }

    protected IOperationHistory getOperationhistory() {
        return this.getSite().getWorkbenchWindow().getWorkbench().getOperationSupport().getOperationHistory();
    }

    void setInstance(InstanceInput.Holder holder) {
        ArgChecks.checkForNull((Object)holder, (String)"holder");
        if (this.getInstance() != null) {
            this.updateManager.removeListener((Object)this.instance, (ChangeListener)this);
        } else {
            this.updateManager.removeListener((Object)this.template, (ChangeListener)this);
        }
        this.instance = holder.instance;
        this.template = this.instance.getTemplate();
        this.templateStatus = null;
        this.updateManager.addListener((Object)this.getInstance(), (ChangeListener)this);
        this.performChecks();
        this.refreshGraphUI();
    }

    private void refreshGraphUI() {
        if (this.getGraphicalViewer() != null) {
            ScalableRootEditPart rootPart = (ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart();
            if (this.getEditorInput() instanceof InstanceChangingInput) {
                IFigure figure = rootPart.getLayer((Object)"Printable Layers");
                Figure topFigure = new Figure();
                topFigure.setBorder((Border)new MarginBorder(20));
                Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                Label topLabel = new Label("You have locked the instance for modification. When finished close the editor tab to unlock the instance again.", image);
                topFigure.setLayoutManager((LayoutManager)new FlowLayout());
                topFigure.add((IFigure)topLabel);
                figure.add((IFigure)topFigure, 0);
            }
            if (this.getTemplate() != null) {
                this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new ProcessEditPartFactory(this.updateManager, this.uiSettings, this.getTemplate(), this.getInstance()));
            }
            this.getGraphicalViewer().setContents((Object)this.getTemplate());
            final ZoomManager zoom = (ZoomManager)this.getAdapter(ZoomManager.class);
            final EditPart rootEditPart = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(this.template.getStartNode());
            this.getGraphicalControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (rootEditPart instanceof DefaultNodeEditPart && Editor.this.getGraphicalControl() != null && !Editor.this.getGraphicalControl().isDisposed()) {
                        DefaultNodeEditPart part = (DefaultNodeEditPart)rootEditPart;
                        part.revealTo(zoom);
                    }
                }
            });
        }
    }

    void registerChildEditor(Editor childEditor) {
        ArgChecks.checkForNull((Object)((Object)childEditor), (String)"childEditor");
        this.childEditors.add(childEditor);
        childEditor.addPropertyListener(this.childEditorListener);
    }

    void unregisterChildEditor(Editor childEditor) {
        ArgChecks.checkForNull((Object)((Object)childEditor), (String)"childEditor");
        this.childEditors.remove((Object)childEditor);
        childEditor.removePropertyListener(this.childEditorListener);
        this.updateOverallDirty();
    }

    void updateTitle() {
        IEditorInput input = this.getEditorInput();
        if (this.instance == null) {
            if (this.template instanceof ChangeableTemplate) {
                this.setPartName(String.valueOf(this.template.getName()) + " (Source: " + input.getName() + ")");
            } else {
                this.setPartName(String.valueOf(this.template.getName()) + " (Source: " + input.getName() + "; read only)");
            }
        } else {
            this.setPartName(input.getName());
        }
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Editor.this.doAutoFit();
                if (event.getProperty().equals(UpdateManager.TransactionProperties.TRANSACTION_STARTED)) {
                    Template newTemplate;
                    Editor.this.logger.info("Process property changed event received - setting dirty - running checks.");
                    Editor.this.setLocalDirty(true);
                    if (Editor.this.instance != null && Editor.this.template != (newTemplate = Editor.this.instance.getTemplate())) {
                        Editor.this.getGraphicalViewer().setContents((Object)newTemplate);
                        SelectionManager manager = Editor.this.getSelectionManager();
                        SelectionGroupDefinition definition = manager.getActiveGroup().getDefinition();
                        manager.updateSelectionReferencesForGroup(newTemplate, definition);
                        Editor.this.template = newTemplate;
                    }
                } else if (event.getProperty().equals(UpdateManager.TransactionProperties.TRANSACTION_ENDED)) {
                    Editor.this.performChecks();
                } else if (event.getProperty().equals(UpdateManager.ProcessProperties.PROCESS_NAME)) {
                    Editor.this.updateTitle();
                } else {
                    Editor.this.logger.info("Don't know how to handle event " + event);
                }
            }
        });
    }

    protected boolean isSaveable() {
        return this.saveable;
    }

    protected void setSaveable(boolean saveable) {
        this.saveable = saveable;
    }

    EditPart findEditPart(String modelType, int id) {
        Template modelElement = null;
        if ("template".equals(modelType)) {
            modelElement = this.getTemplate();
        }
        if ("dataelement".equals(modelType)) {
            modelElement = this.getTemplate().getDataElement(id);
        } else if ("node".equals(modelType)) {
            modelElement = this.getTemplate().getNode(id);
        }
        return (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(modelElement);
    }

    public CheckReport getCheckReport() {
        return this.currentReport;
    }

    public void performChecks() {
        ArrayList<ProcessTemplateCheck> checks;
        NodeRelations relations;
        CheckReport report;
        Template template;
        IWorkspaceRoot resource;
        block22: {
            block20: {
                ProcessCheckService processChecks;
                block21: {
                    resource = ResourcesPlugin.getWorkspace().getRoot();
                    template = this.getTemplate();
                    ArgChecks.checkForNull((Object)resource, (String)"resource");
                    ArgChecks.checkForNull((Object)template, (String)"template");
                    this.deleteMarkers((IResource)resource);
                    URI base = null;
                    base = ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost");
                    report = new CheckReport(base);
                    relations = new NodeRelations(template);
                    boolean consistency = true;
                    boolean structure = true;
                    processChecks = Activator.getService().getProcessChecks();
                    checks = new ArrayList<ProcessTemplateCheck>();
                    if (this.autoRunConsistencyChecks) {
                        checks.add(processChecks.getConsistencyChecks());
                    } else {
                        this.logger.fine("Not Running Consistency Checks");
                    }
                    if (this.autoRunStructureChecks) {
                        checks.add(processChecks.getStructureChecks());
                    } else {
                        this.logger.fine("Not Running Structural Checks");
                    }
                    if (!consistency || !structure) break block20;
                    if (this.getInstance() != null) break block21;
                    switch (this.checkSet) {
                        case BASIC_MODELLING: {
                            checks.add(processChecks.getBasicModellingChecks());
                            break block22;
                        }
                        case EXECUTION_TEST_CLIENT: {
                            checks.add(processChecks.getExecutionTestClientChecks());
                            break block22;
                        }
                        case EXECUTION_PRODUCTION: {
                            checks.add(processChecks.getExecutionProductionChecks());
                            break block22;
                        }
                        default: {
                            throw new RuntimeException("Unknown enum value: " + this.checkSet);
                        }
                    }
                }
                checks.add(processChecks.getExecutionProductionChecks());
                break block22;
            }
            this.logger.warning("Not performing dataflow and other checks since a consistency or structural check failed before!");
        }
        ProcessTemplateCheckRunner checkRunner = new ProcessTemplateCheckRunner(false, checks.toArray(new ProcessTemplateCheck[checks.size()]));
        checkRunner.performCheck(template, relations, report);
        this.logger.info(relations.getStatsString());
        this.currentReport = report;
        this.firePropertyChange(258);
        for (CheckReport.ReportEntry reportEntry : report.getReportEntries()) {
            int severity = 0;
            if (reportEntry.getReportEntryType() == CheckReport.ResultType.FAILURE) {
                severity = 2;
            } else if (reportEntry.getReportEntryType() == CheckReport.ResultType.WARNING) {
                severity = 1;
            } else if (reportEntry.getReportEntryType() == CheckReport.ResultType.INFO) {
                severity = 0;
            } else if (reportEntry.getReportEntryType() == CheckReport.ResultType.OK) continue;
            GraphicalViewer viewer = this.getGraphicalViewer();
            if (viewer == null) {
                return;
            }
            URI[] affectedADEPT2ProcessElements = reportEntry.getAffectedADEPT2ProcessElements();
            if (affectedADEPT2ProcessElements.length == 0) {
                this.markers.add(ProblemMarker.addMarkerToFile((IResource)resource, (String)reportEntry.getMessage(), (String)"Unknown", (int)severity));
                continue;
            }
            URI[] uRIArray = affectedADEPT2ProcessElements;
            int n = affectedADEPT2ProcessElements.length;
            int n2 = 0;
            while (n2 < n) {
                URI element = uRIArray[n2];
                if (element != null) {
                    this.markers.add(ProblemMarker.addMarkerToFile((IResource)resource, (Object)element, (String)reportEntry.getMessage(), (int)severity));
                    this.assignStatusToProcessElement(element, severity);
                }
                ++n2;
            }
        }
    }

    void deleteMarkers(IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            GraphicalViewer viewer = this.getGraphicalViewer();
            if (viewer != null) {
                this.resetStatusOfAffectedProcessElements(markers);
            }
            for (IMarker marker : this.markers) {
                marker.delete();
            }
        }
        catch (CoreException coreException) {
            this.logger.severe("Couldn't delete old Markers!");
        }
    }

    protected void resetStatusOfAffectedProcessElements(IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String elementId = marker.getAttribute("elementId", null);
            if (elementId != null) {
                this.assignStatusToProcessElement(elementId, -1);
            }
            ++n2;
        }
    }

    protected void assignStatusToProcessElement(String elementIdentifierStr, int status) {
        try {
            URI elementIdentifier = new URI(elementIdentifierStr);
            this.assignStatusToProcessElement(elementIdentifier, status);
        }
        catch (URISyntaxException e1) {
            String errorMessage = String.format("Cannot set the error status of process element '%s': The element identifier is no ADEPT2ProcessElementIdentifier!", elementIdentifierStr);
            this.logger.log(Level.SEVERE, errorMessage, e1);
        }
    }

    protected void assignStatusToProcessElement(URI elementIdentifier, int status) {
        block9: {
            String[] idsOfIdentifierPath;
            String[] typesOfIdentifierPath;
            String elementType;
            block8: {
                elementType = ProcessElementIdentifierTools.getElementType((URI)elementIdentifier);
                typesOfIdentifierPath = ProcessElementIdentifierTools.getTypesOfIdentifierPath((URI)elementIdentifier);
                idsOfIdentifierPath = ProcessElementIdentifierTools.getPathIDsOfIdentifierPath((URI)elementIdentifier);
                if (!elementType.equalsIgnoreCase("node") && !elementType.equalsIgnoreCase("dataelement")) break block8;
                int pathID = -1;
                int i = 1;
                while (i < idsOfIdentifierPath.length) {
                    block6: {
                        try {
                            pathID = new Long(idsOfIdentifierPath[i]).intValue();
                        }
                        catch (NumberFormatException e) {
                            String errorMessage = String.format("Cannot show the error state of process element '%s' with ID='%s': An NumberFormatException occurred!", typesOfIdentifierPath[i], idsOfIdentifierPath[i]);
                            this.logger.log(Level.SEVERE, errorMessage, e);
                            break block6;
                        }
                        this.displayProcessElementStatus(typesOfIdentifierPath[i], pathID, status);
                    }
                    ++i;
                }
                break block9;
            }
            if (!elementType.equalsIgnoreCase("parameter") && !elementType.equalsIgnoreCase("ebp")) break block9;
            int pathID = -1;
            int i = 1;
            while (i <= 1) {
                block7: {
                    try {
                        pathID = new Long(idsOfIdentifierPath[i]).intValue();
                    }
                    catch (NumberFormatException e) {
                        String errorMessage = String.format("Cannot show the error state of process element '%s' with ID='%s': An NumberFormatException occurred!", typesOfIdentifierPath[i], idsOfIdentifierPath[i]);
                        this.logger.log(Level.SEVERE, errorMessage, e);
                        break block7;
                    }
                    this.displayProcessElementStatus(typesOfIdentifierPath[i], pathID, status);
                }
                ++i;
            }
        }
    }

    private void displayProcessElementStatus(String elementType, int elementID, int status) {
        EditPart part = this.findEditPart(elementType, elementID);
        if (part != null) {
            if (part instanceof IProcessEditPart) {
                IProcessEditPart processEditPart = (IProcessEditPart)part;
                processEditPart.setErrorStatus(status);
            } else {
                String errorMessage = String.format("Cannot reset the error state of process element '%s' with ID='%s': The associated EditPart does not implement IProcessEditPart!", elementType, elementID);
                this.logger.log(Level.SEVERE, errorMessage);
            }
        } else {
            String errorMessage = String.format("Cannot reset the error state of process element '%s' with ID='%s': Could not find the associated IProcessEditPart!", elementType, elementID);
            this.logger.log(Level.INFO, errorMessage);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        if (!(this.getTemplate() instanceof ChangeableTemplate) && !(this.getInstance() instanceof ChangeableInstance)) {
            return;
        }
        EditPart editpart = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        this.openWizardForEditPart(editpart);
    }

    public void openWizardForEditPart(EditPart editpart) {
        if (editpart instanceof DefaultNodeEditPart && !(editpart instanceof DataElementEditPart)) {
            Node node = (Node)editpart.getModel();
            if (this.instance != null && this.instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_ACTIVATED && this.instance.getNodeState(node.getID()) != ProcessConstants.NodeState.NS_NOT_ACTIVATED) {
                return;
            }
            PnPWizard wizard = new PnPWizard(PlatformUI.getWorkbench(), null, node);
            Shell parentShell = this.getGraphicalViewer().getControl().getShell();
            OverviewWizardDialogue dialog = new OverviewWizardDialogue(parentShell, (IWizard)wizard);
            dialog.create();
            dialog.open();
        } else if (editpart instanceof DataElementEditPart) {
            DataElement dataElement = (DataElement)editpart.getModel();
            SessionToken session = Activator.getService().getSessionToken();
            if (this.instance instanceof ChangeableInstance) {
                DataElementWizard.openForChanging(this.getGraphicalViewer().getControl().getShell(), null, (ChangeableInstance)this.instance, this.updateManager, dataElement, session);
            } else if (this.template instanceof ChangeableTemplate) {
                DataElementWizard.openForChanging(this.getGraphicalViewer().getControl().getShell(), (ChangeableTemplate)this.template, null, this.updateManager, dataElement, session);
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        EditPart editPart = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (editPart instanceof IProcessEditPart && this.selectionManager != null && this.selectionManager.getActiveGroup() == null) {
            this.selectionManager.editPartClicked((IProcessEditPart)editPart, e.stateMask == 262144);
        }
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void setAutoZoom(boolean enabled) {
        this.autoZoom = enabled;
        this.doAutoFit();
    }

    void doAutoFit() {
        if (this.autoZoom && this.autoZoomLevel != null) {
            ZoomManager zoom = (ZoomManager)this.getAdapter(ZoomManager.class);
            zoom.setZoomAsText(this.autoZoomLevel);
        }
    }

    public void setZoomLevel(String zoomLevel) {
        this.autoZoomLevel = zoomLevel;
        ZoomManager zoom = (ZoomManager)this.getAdapter(ZoomManager.class);
        zoom.setZoomAsText(this.autoZoomLevel);
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        IFile file;
        if (this.getEditorInput() instanceof IFileTemplateInput) {
            file = ((IFileTemplateInput)this.getEditorInput()).getFile();
        } else if (this.getEditorInput() instanceof IFileInstanceInput) {
            file = ((IFileInstanceInput)this.getEditorInput()).getFile();
        } else {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta != null && (delta = rootDelta.findMember(file.getFullPath())) != null) {
            Runnable changeRunnable = null;
            if (delta.getKind() == 2) {
                changeRunnable = (0x2000 & delta.getFlags()) != 0 ? new Runnable(){

                    @Override
                    public void run() {
                        IPath path = delta.getMovedToPath();
                        IFile newFile = delta.getResource().getWorkspace().getRoot().getFile(path);
                        if (newFile != null) {
                            try {
                                ProcessInput processInput;
                                if (Editor.this.getEditorInput() instanceof IFileTemplateInput) {
                                    IFileTemplateInput templateInput = new IFileTemplateInput(newFile);
                                    if (Editor.this.isDirty()) {
                                        ((TemplateInput)templateInput).doSave(Editor.this.getTemplate(), Editor.this.getTemplateStatus(), null);
                                    }
                                    processInput = templateInput;
                                } else {
                                    IFileInstanceInput instanceInput = new IFileInstanceInput(newFile);
                                    if (Editor.this.isDirty()) {
                                        instanceInput.doSave(Editor.this.getInstance(), null);
                                    }
                                    processInput = instanceInput;
                                }
                                Editor.this.setLocalDirty(false);
                                Editor.this.setInput(processInput);
                            }
                            catch (Exception exception) {
                                Editor.this.getSite().getPage().closeEditor((IEditorPart)Editor.this, true);
                            }
                        }
                    }
                } : new Runnable(){

                    @Override
                    public void run() {
                        Editor.this.setLocalDirty(false);
                        Editor.this.getSite().getPage().closeEditor((IEditorPart)Editor.this, true);
                    }
                };
            }
            if (changeRunnable != null) {
                this.getSite().getShell().getDisplay().asyncExec(changeRunnable);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 127) {
            DeleteNodeAction delNodeAction;
            DeleteBranchAction emptyBranchAction;
            DeleteBorderNodesAction borderAction;
            DeleteDataElementAction action;
            ArrayList<IProcessEditPart> primPreSelList = new ArrayList<IProcessEditPart>();
            ArrayList<Object> primPostSelList = new ArrayList<IProcessEditPart>();
            for (Selection sel : this.selectionManager.getActiveGroup().getAllSelections()) {
                if (sel.getDefinition().getID().equals("primaryPreSelection") && sel.getSelection() instanceof Selection.SelectionList) {
                    primPreSelList = new ArrayList((Selection.SelectionList)sel.getSelection());
                }
                if (!sel.getDefinition().getID().equals("primaryPostSelection") || !(sel.getSelection() instanceof Selection.SelectionList)) continue;
                primPostSelList = new ArrayList((Selection.SelectionList)sel.getSelection());
            }
            if (this.getInstance() != null && this.getInstance() instanceof ChangeableInstance) {
                action = new DeleteDataElementAction();
                action.update((ChangePrimitives)((ChangeableInstance)this.getInstance()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                action.run();
                borderAction = new DeleteBorderNodesAction();
                borderAction.update((ChangePrimitives)((ChangeableInstance)this.getInstance()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                borderAction.run();
                emptyBranchAction = new DeleteBranchAction();
                emptyBranchAction.update((ChangePrimitives)((ChangeableInstance)this.getInstance()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                emptyBranchAction.run();
                delNodeAction = new DeleteNodeAction();
                delNodeAction.update((ChangePrimitives)((ChangeableInstance)this.getInstance()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                delNodeAction.run();
            } else if (this.getTemplate() instanceof ChangeableTemplate) {
                action = new DeleteDataElementAction();
                action.update((ChangePrimitives)((ChangeableTemplate)this.getTemplate()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                action.run();
                borderAction = new DeleteBorderNodesAction();
                borderAction.update((ChangePrimitives)((ChangeableTemplate)this.getTemplate()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                borderAction.run();
                emptyBranchAction = new DeleteBranchAction();
                emptyBranchAction.update((ChangePrimitives)((ChangeableTemplate)this.getTemplate()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                emptyBranchAction.run();
                delNodeAction = new DeleteNodeAction();
                delNodeAction.update((ChangePrimitives)((ChangeableTemplate)this.getTemplate()), primPreSelList, primPostSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                delNodeAction.run();
            }
            if ((primPreSelList.size() > 0 && primPostSelList.isEmpty() || primPostSelList.size() > 0 && primPreSelList.isEmpty()) && primPostSelList.isEmpty()) {
                for (IProcessEditPart part : primPreSelList) {
                    RemoveDataAccessAction action2;
                    if (!(part instanceof DataEdgeEditPart)) continue;
                    DataEdgeEditPart dePart = (DataEdgeEditPart)part;
                    ActivityConstants.AccessType accessType = ((DataEdge)dePart.getModel()).getType();
                    ArrayList<IProcessEditPart> preSelList = new ArrayList<IProcessEditPart>();
                    ArrayList<IProcessEditPart> postSelList = new ArrayList<IProcessEditPart>();
                    preSelList.add((IProcessEditPart)dePart.getSource());
                    postSelList.add((IProcessEditPart)dePart.getTarget());
                    if (accessType == ActivityConstants.AccessType.READ || accessType == ActivityConstants.AccessType.WRITE) {
                        action2 = new RemoveDataAccessAction();
                    } else if (accessType == ActivityConstants.AccessType.SYSTEM_READ || accessType == ActivityConstants.AccessType.SYSTEM_WRITE) {
                        action2 = new RemoveDataAccessAction.RemoveSystemDataAccessAction();
                    } else {
                        throw new RuntimeException("Unknown access type: " + accessType);
                    }
                    if (this.getInstance() != null && this.getInstance() instanceof ChangeableInstance) {
                        action2.update((ChangePrimitives)((ChangeableInstance)this.getInstance()), preSelList, postSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                        action2.run();
                        continue;
                    }
                    if (!(this.getTemplate() instanceof ChangeableTemplate)) continue;
                    action2.update((ChangePrimitives)((ChangeableTemplate)this.getTemplate()), preSelList, postSelList, this.updateManager, new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.getTemplate(), (String)"localhost")));
                    action2.run();
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

