/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting;

import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.FileTemplateInput;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.actions.ActionFactory;

public class TemplateActionBarContributor
extends ActionBarContributor {
    public static final String ACTION_SAVE_COPY_TO = "saveCopyTo";

    protected void buildActions() {
        this.addAction((IAction)new Action("Save Copy To..."){
            {
                this.setId(TemplateActionBarContributor.ACTION_SAVE_COPY_TO);
            }

            public void run() {
                if (TemplateActionBarContributor.this.getPage().getActiveEditor() instanceof Editor) {
                    try {
                        Template template = ((Editor)TemplateActionBarContributor.this.getPage().getActiveEditor()).getTemplate();
                        FileTemplateInput.saveTemplateToNewFile(template, null);
                    }
                    catch (Exception ex) {
                        String msg = "The template could not be saved to the file!";
                        StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    }
                }
            }
        });
    }

    public void contributeToMenu(IMenuManager menuManager) {
        menuManager.findMenuUsingPath("file").appendToGroup("save.ext", this.getAction(ACTION_SAVE_COPY_TO));
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.PRINT.getId());
        this.addGlobalActionKey(ActionFactory.UNDO.getId());
        this.addGlobalActionKey(ActionFactory.REDO.getId());
    }
}

